.\" Automatically generated by Pod::Man v1.37, Pod::Parser v1.14
.\"
.\" Standard preamble:
.\" ========================================================================
.de Sh \" Subsection heading
.br
.if t .Sp
.ne 5
.PP
\fB\\$1\fR
.PP
..
.de Sp \" Vertical space (when we can't use .PP)
.if t .sp .5v
.if n .sp
..
.de Vb \" Begin verbatim text
.ft CW
.nf
.ne \\$1
..
.de Ve \" End verbatim text
.ft R
.fi
..
.\" Set up some character translations and predefined strings.  \*(-- will
.\" give an unbreakable dash, \*(PI will give pi, \*(L" will give a left
.\" double quote, and \*(R" will give a right double quote.  | will give a
.\" real vertical bar.  \*(C+ will give a nicer C++.  Capital omega is used to
.\" do unbreakable dashes and therefore won't be available.  \*(C` and \*(C'
.\" expand to `' in nroff, nothing in troff, for use with C<>.
.tr \(*W-|\(bv\*(Tr
.ds C+ C\v'-.1v'\h'-1p'\s-2+\h'-1p'+\s0\v'.1v'\h'-1p'
.ie n \{\
.    ds -- \(*W-
.    ds PI pi
.    if (\n(.H=4u)&(1m=24u) .ds -- \(*W\h'-12u'\(*W\h'-12u'-\" diablo 10 pitch
.    if (\n(.H=4u)&(1m=20u) .ds -- \(*W\h'-12u'\(*W\h'-8u'-\"  diablo 12 pitch
.    ds L" ""
.    ds R" ""
.    ds C` ""
.    ds C' ""
'br\}
.el\{\
.    ds -- \|\(em\|
.    ds PI \(*p
.    ds L" ``
.    ds R" ''
'br\}
.\"
.\" If the F register is turned on, we'll generate index entries on stderr for
.\" titles (.TH), headers (.SH), subsections (.Sh), items (.Ip), and index
.\" entries marked with X<> in POD.  Of course, you'll have to process the
.\" output yourself in some meaningful fashion.
.if \nF \{\
.    de IX
.    tm Index:\\$1\t\\n%\t"\\$2"
..
.    nr % 0
.    rr F
.\}
.\"
.\" For nroff, turn off justification.  Always turn off hyphenation; it makes
.\" way too many mistakes in technical documents.
.hy 0
.if n .na
.\"
.\" Accent mark definitions (@(#)ms.acc 1.5 88/02/08 SMI; from UCB 4.2).
.\" Fear.  Run.  Save yourself.  No user-serviceable parts.
.    \" fudge factors for nroff and troff
.if n \{\
.    ds #H 0
.    ds #V .8m
.    ds #F .3m
.    ds #[ \f1
.    ds #] \fP
.\}
.if t \{\
.    ds #H ((1u-(\\\\n(.fu%2u))*.13m)
.    ds #V .6m
.    ds #F 0
.    ds #[ \&
.    ds #] \&
.\}
.    \" simple accents for nroff and troff
.if n \{\
.    ds ' \&
.    ds ` \&
.    ds ^ \&
.    ds , \&
.    ds ~ ~
.    ds /
.\}
.if t \{\
.    ds ' \\k:\h'-(\\n(.wu*8/10-\*(#H)'\'\h"|\\n:u"
.    ds ` \\k:\h'-(\\n(.wu*8/10-\*(#H)'\`\h'|\\n:u'
.    ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'^\h'|\\n:u'
.    ds , \\k:\h'-(\\n(.wu*8/10)',\h'|\\n:u'
.    ds ~ \\k:\h'-(\\n(.wu-\*(#H-.1m)'~\h'|\\n:u'
.    ds / \\k:\h'-(\\n(.wu*8/10-\*(#H)'\z\(sl\h'|\\n:u'
.\}
.    \" troff and (daisy-wheel) nroff accents
.ds : \\k:\h'-(\\n(.wu*8/10-\*(#H+.1m+\*(#F)'\v'-\*(#V'\z.\h'.2m+\*(#F'.\h'|\\n:u'\v'\*(#V'
.ds 8 \h'\*(#H'\(*b\h'-\*(#H'
.ds o \\k:\h'-(\\n(.wu+\w'\(de'u-\*(#H)/2u'\v'-.3n'\*(#[\z\(de\v'.3n'\h'|\\n:u'\*(#]
.ds d- \h'\*(#H'\(pd\h'-\w'~'u'\v'-.25m'\f2\(hy\fP\v'.25m'\h'-\*(#H'
.ds D- D\\k:\h'-\w'D'u'\v'-.11m'\z\(hy\v'.11m'\h'|\\n:u'
.ds th \*(#[\v'.3m'\s+1I\s-1\v'-.3m'\h'-(\w'I'u*2/3)'\s-1o\s+1\*(#]
.ds Th \*(#[\s+2I\s-2\h'-\w'I'u*3/5'\v'-.3m'o\v'.3m'\*(#]
.ds ae a\h'-(\w'a'u*4/10)'e
.ds Ae A\h'-(\w'A'u*4/10)'E
.    \" corrections for vroff
.if v .ds ~ \\k:\h'-(\\n(.wu*9/10-\*(#H)'\s-2\u~\d\s+2\h'|\\n:u'
.if v .ds ^ \\k:\h'-(\\n(.wu*10/11-\*(#H)'\v'-.4m'^\v'.4m'\h'|\\n:u'
.    \" for low resolution devices (crt and lpr)
.if \n(.H>23 .if \n(.V>19 \
\{\
.    ds : e
.    ds 8 ss
.    ds o a
.    ds d- d\h'-1'\(ga
.    ds D- D\h'-1'\(hy
.    ds th \o'bp'
.    ds Th \o'LP'
.    ds ae ae
.    ds Ae AE
.\}
.rm #[ #] #H #V #F C
.\" ========================================================================
.\"
.IX Title "KANIF 1"
.TH KANIF 1 "2007-11-27" "perl v5.8.6" "kanif TakTuk Wrapper"
.SH "NAME"
\&\fBkanif\fR \- a TakTuk wrapper for cluster management
.SH "SYNOPSIS"
.IX Header "SYNOPSIS"
\&\fBkash\fR|\fBkaget\fR|\fBkaput\fR [\fB\-aHhimsV\fR] [\fB\-f\fR conf\-file] [\fB\-l\fR login]
[\fB\-M\fR machines\-list] [\fB\-n\fR|\fB\-w\fR nodes] [\fB\-o\fR options] [\fB\-p\fR level]
[\fB\-r\fR command] [\fB\-T\fR options] [\fB\-t\fR timeout] [\fB\-u\fR timeout] [\fB\-x\fR nodes]
[machines specifications] [command body]
.SH "DESCRIPTION"
.IX Header "DESCRIPTION"
\&\fBkanif\fR is a tool for cluster management and administration. It
combines main features of well known cluster management tools such as
c3, pdsh and dsh and mimics their syntax. For the effective cluster management
it relies on \fBTakTuk\fR, a tool for large scale remote execution deployment.
.PP
For simple parallel tasks that have to be executed on regular machines such as
clusters, \fBTakTuk\fR syntax is too complicated.  The goal of \fBkanif\fR is
to provide an easier and familiar syntax to cluster administrators while still
taking advantage of \fBTakTuk\fR characteristics and features (adaptivity,
scalability, portability, autopropagation and informations redirection).
.PP
To work, \fBkanif\fR needs to find the \f(CW\*(C`taktuk\*(C'\fR command (version 3.3 and
above) in the user path. The other requirements are the same as \fBTakTuk\fR: it
requires, on all the nodes of the cluster, a working Perl interpreter (version
5.8 and above) and a command to log without password (such as \f(CW\*(C`ssh\*(C'\fR with
proper rsa keys installed).
.PP
\&\fBkanif\fR provides three simple commands for clusters administration and
management:
.IP "\fBkash\fR: runs the same command on multiple nodes" 4
.IX Item "kash: runs the same command on multiple nodes"
.PD 0
.IP "\fBkaput\fR: broadcasts the copy of files or directories to several nodes" 4
.IX Item "kaput: broadcasts the copy of files or directories to several nodes"
.IP "\fBkaget\fR: gathers several remote files or directories" 4
.IX Item "kaget: gathers several remote files or directories"
.PD
.PP
\&\fBkanif\fR combines the advantages of several cluster management tools.
Its main features can be summarized as follows:
.IP "\(bu" 4
C3\-style configuration file for static clusters setups
.IP "\(bu" 4
pdsh-like options such as nodes ranges and timeouts
.IP "\(bu" 4
dshbak-like gathering, sorting and merging of output
.PP
As with \f(CW\*(C`pdsh\*(C'\fR, \fBkanif\fR deployment can be monitored and controlled by
signals.  When \fBkanif\fR receives a \s-1SIGINT\s0 (usually sent by typing Ctrl\-C), it
displays a brief summary of its deployment state and commands execution
progress. After this first \s-1SIGINT\s0, if \fBkanif\fR receives a second signal within
one second:
.IP "\(bu" 4
it terminates its execution (cancelling any ongoing task) if
this is a \s-1SIGINT\s0
.IP "\(bu" 4
it cancels any ongoing connections and start executions on
the already deployed nodes if this is a \s-1SIGTSTP\s0 (usually sent by typing
Ctrl\-Z)
.PP
At the end of executions, \fBkanif\fR also reports a quick summary of
failures: connections and commands execution.
.SH "OPTIONS"
.IX Header "OPTIONS"
To help administrators in their task, \fBkanif\fR options syntax is as
close as possible to C3/pdsh/dsh well known tools. 
.IP "\fB\-a\fR" 4
.IX Item "-a"
.PD 0
.IP "\fB\-\-all\fR" 4
.IX Item "--all"
.PD
Deploys on all nodes of all configured clusters.
.IP "\fB\-f\fR conf-file" 4
.IX Item "-f conf-file"
.PD 0
.IP "\fB\-\-file\fR conf-file" 4
.IX Item "--file conf-file"
.PD
Uses \f(CW\*(C`conf\-file\*(C'\fR as configuration file instead of default. Several
possibilities are examined for default configuration file, in order:
\&\f(CW\*(C`$HOME/.kanif.conf\*(C'\fR, \f(CW\*(C`/etc/kanif.conf\*(C'\fR, \f(CW\*(C`/etc/c3.conf\*(C'\fR.
.IP "\fB\-F\fR" 4
.IX Item "-F"
.PD 0
.IP "\fB\-\-flat\-deployment\fR" 4
.IX Item "--flat-deployment"
.PD
Deploys all remote execution from the root node (which executes kanif). Useful
when remote nodes cannot log on each other.
.IP "\fB\-H\fR" 4
.IX Item "-H"
.PD 0
.IP "\fB\-\-head\fR" 4
.IX Item "--head"
.PD
Deploys only on clusters \f(CW\*(C`head\*(C'\fR node (using local interface) for all specified
clusters.
.IP "\fB\-h\fR" 4
.IX Item "-h"
.PD 0
.IP "\fB\-\-help\fR" 4
.IX Item "--help"
.PD
Prints a short help text and exits.
.IP "\fB\-i\fR" 4
.IX Item "-i"
.PD 0
.IP "\fB\-\-interactive\fR" 4
.IX Item "--interactive"
.PD
Ask confirmation before any action. An action is either the execution of one
command on all the hosts (default) or the execution of one command on one host
(sequential mode, see \fB\-s\fR switch).
.IP "\fB\-l\fR login" 4
.IX Item "-l login"
.PD 0
.IP "\fB\-\-login\fR login" 4
.IX Item "--login login"
.PD
Uses the given \f(CW\*(C`login\*(C'\fR to connect to remote hosts.
.IP "\fB\-M\fR machines-list" 4
.IX Item "-M machines-list"
.PD 0
.IP "\fB\-\-list\fR machines-list" 4
.IX Item "--list machines-list"
.PD
Adds to the remote hosts the names contained in the file named
\&\f(CW\*(C`machines\-list\*(C'\fR. \fBkanif\fR accepts as many \fB\-M\fR options as you wish.
.IP "\fB\-m\fR" 4
.IX Item "-m"
.PD 0
.IP "\fB\-\-monitoring\fR" 4
.IX Item "--monitoring"
.PD
Makes \fBkanif\fR more verbose about whats happening during deployment
commands execution.
.IP "\fB\-n\fR nodes" 4
.IX Item "-n nodes"
.PD 0
.IP "\fB\-\-nodes\fR nodes" 4
.IX Item "--nodes nodes"
.PD
Adds the given \f(CW\*(C`nodes\*(C'\fR to the deployment. See section
\&\*(L"\s-1HOSTNAMES\s0 \s-1SPECIFICATION\s0\*(R" for more information about \f(CW\*(C`nodes\*(C'\fR syntax.
\&\fBkanif\fR accepts as many \fB\-n\fR options as you wish.
.IP "\fB\-o\fR options" 4
.IX Item "-o options"
.PD 0
.IP "\fB\-\-remote\-opts\fR options" 4
.IX Item "--remote-opts options"
.PD
Sets additional options to be passed to the remote shell command.
.IP "\fB\-p\fR level" 4
.IX Item "-p level"
.PD 0
.IP "\fB\-\-postprocess\fR level" 4
.IX Item "--postprocess level"
.PD
Sets the level of output formating made in \fBkanif\fR. The general idea
is: the higher the level, the more sorted, merged and human readable the
output. Default is 4, differents levels are:
.RS 4
.IP "0" 4
No processing at all: raw commands output is printed to stdout and raw commands
error is printed to stderr. Connections and executions errors are not reported.
.IP "1" 4
.IX Item "1"
Same as 0 except that the name of the host which produced the output is
prepended before each line.
.IP "2" 4
.IX Item "2"
Same as 1 except that the output is sorted by command (one complete command
execution is outputed entirely before another one). Connections and
executions errors are summarized at the end to stderr.
.IP "3" 4
.IX Item "3"
Same as 2 except that the hostname is printed once, formatted as a title,
before its output.
.IP "4" 4
.IX Item "4"
Same as 3 except that identical output produced by multiple nodes is printed
once with all the hosts summarized in the title.
.RE
.RS 4
.RE
.IP "\fB\-q\fR" 4
.IX Item "-q"
.PD 0
.IP "\fB\-\-dry\-run\fR" 4
.IX Item "--dry-run"
.PD
When this option is given, \fBkanif\fR does nothing and prints its configuration,
the remote nodes it would have tried to contact and the \fBTakTuk\fR command that
would have been executed.
.IP "\fB\-r\fR command" 4
.IX Item "-r command"
.PD 0
.IP "\fB\-\-remote\-cmd\fR command" 4
.IX Item "--remote-cmd command"
.PD
Sets the name of the \f(CW\*(C`command\*(C'\fR used to contact remote hosts (default is
\&\f(CW\*(C`ssh \-o StrictHostKeyChecking=no \-o BatchMode=yes\*(C'\fR).
.IP "\fB\-s\fR" 4
.IX Item "-s"
.PD 0
.IP "\fB\-\-sequential\fR" 4
.IX Item "--sequential"
.PD
Each command is executed sequentially on remote hosts (using the order
given on the command line as hosts order).
.IP "\fB\-T\fR options" 4
.IX Item "-T options"
.PD 0
.IP "\fB\-\-taktuk\-options\fR options" 4
.IX Item "--taktuk-options options"
.PD
Allows power users to pass some options to the \fBTakTuk\fR command executed
(caution: always include \fB\-s\fR which is the default unless you really know what
you are doing).
.IP "\fB\-t\fR timeout" 4
.IX Item "-t timeout"
.PD 0
.IP "\fB\-\-timeout\fR timeout" 4
.IX Item "--timeout timeout"
.PD
Gives a timeout value for connection attempts. At expiration, connection is
canceled and deployment on the remote host is aborted.
.IP "\fB\-u\fR timeout" 4
.IX Item "-u timeout"
.PD 0
.IP "\fB\-\-upper\-limit\fR timeout" 4
.IX Item "--upper-limit timeout"
.PD
Gives a timeout value for commands execution. At expiration the command is
killed with a \s-1TERM\s0 signal.
.IP "\fB\-V\fR" 4
.IX Item "-V"
.PD 0
.IP "\fB\-\-version\fR" 4
.IX Item "--version"
.PD
Prints \fBkanif\fR version and exits.
.IP "\fB\-w\fR" 4
.IX Item "-w"
.PD 0
.IP "\fB\-wcoll\fR" 4
.IX Item "-wcoll"
.PD
Synonym to \fB\-n\fR.
.IP "\fB\-x\fR nodes" 4
.IX Item "-x nodes"
.PD 0
.IP "\fB\-\-exclude\fR nodes" 4
.IX Item "--exclude nodes"
.PD
Excludes some nodes from the ones given using \fB\-n\fR or \fB\-w\fR. Applies to all
hosts sets that do not already contain an exclusion part. Does not apply to
host given with \fB\-M\fR option.
.SH "ENVIRONMENT"
.IX Header "ENVIRONMENT"
Usually all \fBkanif\fR options can be set by environment variables.
The rationale is that boolean options have 0/1 value and environment settings
are overridden by command line switches.
.PP
The name of an environment variable used by \fBkanif\fR is made of
the long option name capitalized with dashes replaced by underscores and
\&\f(CW\*(C`KANIF_\*(C'\fR prepended (for instance \f(CW\*(C`KANIF_ALL\*(C'\fR, \f(CW\*(C`KANIF_HEAD\*(C'\fR, and so on).
This rule admits the following exceptions (that have been
chosen to mimic C3/dsh behavior):
.IP "\s-1KANIF_CONF\s0" 4
.IX Item "KANIF_CONF"
Instead of \s-1KANIF_FILE\s0 for configuration file.
.IP "\s-1KANIF_USER\s0" 4
.IX Item "KANIF_USER"
Instead of \s-1KANIF_LOGIN\s0 for login name.
.PP
Notice also that the variable \s-1KANIF_WCOLL\s0 has no meaning to \fBkanif\fR.
.SH "HOSTNAMES SPECIFICATION"
.IX Header "HOSTNAMES SPECIFICATION"
Hostnames given to \fBkanif\fR might be simple machine name or complex hosts lists
specifications. In its general form, an hostname is made of an host set and an
optional exclusion set separated by a slash.  Each of those sets is a comma
separated list of host templates. Each of these templates is made of constant
parts (characters outside brackets) and optional range parts (characters inside
brackets). Each range part is a comma separated list of intervals or single
values. Each interval is made of two single values separated by a dash. This is
true for all hostnames given to \fBkanif\fR (both with \fB\-M\fR or \fB\-n/\-w\fR options).
.PP
In other words, the following expressions are valid host specifications:
    node1
    node[19]
    node[1\-3]
    node[1\-3],otherhost/node2
    node[1\-3,5]part[a\-b]/node[3\-5]parta,node1partb
.PP
they respectively expand to:
    node1
    node19
    node1 node2 node3
    node1 node3 otherhost
    node1parta node2parta node2partb node3partb node5partb
.PP
Notice that these list of values are not regular expressions (\f(CW\*(C`node[19]\*(C'\fR is
\&\f(CW\*(C`node19\*(C'\fR and not \f(CW\*(C`node1, node2, ...., node9\*(C'\fR). Intervals are implemented
using the perl magical auto increment feature, thus you can use alphanumeric
values as interval bounds (see perl documentation, operator ++ for limitations
of this auto increment).
.SH "MACHINES SPECIFICATIONS"
.IX Header "MACHINES SPECIFICATIONS"
With \fBkanif\fR, you can specify the remote nodes on which you want to do
some stuff using the command line switches (\fB\-n\fR and \fB\-x\fR, pdsh/dsh style),
using machines specifications (C3 style) or both. Thus, this part of the
documentation might be ignored if you do not want to use C3 style nodes
management.
.PP
To use machines specification you must describe your cluster in a configuration
file (see \fB\-f\fR option and \fIkanif.conf\fR\|(5)).
Machines specifications are nodes intervals taken from clusters defined in this
file.
.PP
A machine specification is an optional cluster name followed by a colon and an
optional range. The default cluster is taken if no cluster name is given.
All the nodes of the cluster are taken if no range is given. Notice that if
none of \fB\-n\fR/\fB\-w\fR, \fB\-M\fR or machine specification is given on the command
line, the remote hosts are assumed to be all the nodes of the default cluster.
.SH "COMMAND BODY"
.IX Header "COMMAND BODY"
Depending on the name used to invoke it (\fBkash\fR, \fBkaput\fR or \fBkaget\fR),
\&\fBkanif\fR does not perform the same task. Here are its various behavior:
.IP "\fBkash\fR [options] [command line]" 4
.IX Item "kash [options] [command line]"
Executes the last part of the command line on all the remote hosts. If this
last part is empty, enters interactive mode in which \fBkanif\fR waits for
command (one per line) on stdin. In interactive mode, just send an \s-1EOF\s0
character (Ctrl\-D) to exit kash.
.IP "\fBkaput\fR [options] src1 [src2 ...] dest" 4
.IX Item "kaput [options] src1 [src2 ...] dest"
Copies one ore more files or directories to all the remote hosts. The last
argument is the path to the destination file or directory on the remote machine.
The other arguments are local files or directories to copy. Behavior and
limitations are similar to the command \f(CWcp(1)\fR.
.IP "\fBkaget\fR [options] src1 [src2 ...] dest" 4
.IX Item "kaget [options] src1 [src2 ...] dest"
Download one ore more files or directories from all the remote hosts. The last
argument is the path to the destination directory on the local machine. The
other arguments are path to files or directories on remote hosts. Each source
must be present on all the remote hosts. Sources are copied to the
destination directory having the originating host appended to their name.
.PP
Notice that when using \fBkaget\fR or \fBkaput\fR each file or directory is
completely copied before proceeding to the next one.
.SH "EXAMPLES"
.IX Header "EXAMPLES"
When a configuration file exists on the system or is given on the command line
(see option \fB\-f\fR), remote machines can be specified via clusters names. For
instance, the simple execution of the command \f(CW\*(C`ls \-l\*(C'\fR on all the nodes of the
cluster named \f(CW\*(C`megacluster\*(C'\fR can be written:
.PP
.Vb 1
\&    kash megacluster: ls -l
.Ve
.PP
Intervals can also be given. The following command copies the local .cshrc file
to the login directory of a subset of the default cluster and another subset of
the \f(CW\*(C`megacluster\*(C'\fR:
.PP
.Vb 1
\&    kaput :3-6 megacluster:2-5 $HOME/.cshrc .
.Ve
.PP
Finally, one can take advantage of the default behavior to gather a file named
\&\f(CW\*(C`results.txt\*(C'\fR placed
in the \f(CW\*(C`/tmp\*(C'\fR directory on all the nodes of the default cluster to the local
directory \f(CW\*(C`results\*(C'\fR:
.PP
.Vb 1
\&    kaget /tmp/results.txt results
.Ve
.PP
When a user does not want to write a configuration file or just wants to deploy
on some other nodes, it is possible to give remote hosts on the command line:
.PP
.Vb 1
\&    kash -n localhost,supernode uptime
.Ve
.PP
This last command will just execute \f(CW\*(C`uptime\*(C'\fR on \f(CW\*(C`localhost\*(C'\fR and \f(CW\*(C`supernode\*(C'\fR.
Giving intervals and exclusion lists is also possible on the command line. The
following command copie the file \f(CW\*(C`/tmp/temporary.txt\*(C'\fR to the remote \f(CW\*(C`/tmp\*(C'\fR
directories of node1 and node5:
.PP
.Vb 1
\&    kaput -n node[1-6] -x node[2-4],node6 /tmp/temporary.txt /tmp
.Ve
.PP
Finally, without entering into the details of each option, the final command
illustrates the \fB\-u\fR option. It executes during 5 seconds a \f(CW\*(C`ping\*(C'\fR to
\&\f(CW\*(C`gateway\*(C'\fR from 5 nodes:
.PP
.Vb 1
\&    kash -n node[1-2],node[4-6] -u 5 ping gateway
.Ve
.SH "BUGS"
.IX Header "BUGS"
Missing features:
.IP "\(bu" 4
indirect clusters not supported (see C3 documentation about such clusters)
.IP "\(bu" 4
when there are no machine to deploy and \fBkanif\fR runs in interactive
mode, kanif still waits for a command (or eof) before exiting
.PP
Performance issues:
.IP "\(bu" 4
the algorithm used by \fBkaput\fR is not very efficient for transferring large
files. Although the precise limit depends on the machine, it should not scale
well above a few hundreds of megabytes.
.SH "SEE ALSO"
.IX Header "SEE ALSO"
\&\fItaktuk\fR\|(1), \fIkanif.conf\fR\|(5)
.SH "AUTHOR"
.IX Header "AUTHOR"
The author of \fBkanif\fR and current maintainer of the package is
Guillaume Huard. Acknowledgements to Lucas Nussbaum for the idea of the name
\&\*(L"kanif\*(R".
.SH "COPYRIGHT"
.IX Header "COPYRIGHT"
\&\fBkanif\fR is provided under the terms of the \s-1GNU\s0 General Public License
version 2 or later.
