/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef WEATHER_GLOBAL_H
#define WEATHER_GLOBAL_H

#include <qvaluelist.h>
#include <qstringlist.h>
#include "forecast_container.h"

struct WeatherGlobal
{
	WeatherGlobal();
	~WeatherGlobal();
	
	struct Server
	{
		QString name_;
		QString configFile_;
		bool use_;
		
		Server() : use_(true) {}
		Server( const Server& s ) : name_(s.name_), configFile_(s.configFile_), use_(s.use_) {}
		Server( const QString& name, const QString& configFile, bool use ) : name_(name),configFile_(configFile), use_(use) {}
	};
	/**
		klucz - nazwa serwisu pogodowego
		warto - nazwa pliku
	**/
	typedef QValueList<Server> SERVERS;
	typedef QValueListConstIterator<Server> SERVERITERATOR;
	SERVERS servers_;
	
	ForecastContainer savedForecast_;

	QStringList recentLocations_;
	
	static const int CONNECTION_TIMEOUT;
	static const int CONNECTION_COUNT;
	static const QString WeatherConfigPath;
	static const QString WeatherIconPath;
	static const unsigned int RECENT_LOCATIONS_COUNT;
	static const int KEEP_FORECAST; // w godzinach
	
	SERVERITERATOR beginServer() const;
	SERVERITERATOR nextServer( SERVERITERATOR it ) const;
	SERVERITERATOR endServer() const { return servers_.end(); }

	/**
		\fn getConfigFile
		\return plik konfiguracyjny serwisu pogodowego o podanej nazwie
	**/
	QString getConfigFile( const QString& serverName ) const;
	
	/**
		\fn getServerName
		\return nazwa serwisu dla podanego pliku konfiguracyjnego serwisu
	**/
	QString getServerName( const QString& configFile ) const;
	
	/**
		\fn configFileExists
		Sprawdza, czy istnieje plik konfiguracyjny serwsu pogodowego
		\return true, jeli plik istnieje
	**/
	bool configFileExists( const QString& configFile ) const;
	
	/**
		\fn setServerUsing
		Ustawia serwis pogodowy jako uywany/nieuywany
		\param severName nazwa serwisu
		\param use true, jeli ma by uywany, false, jeli nie
	**/
	void setServerUsing( const QString serverName, bool use );

	void setServerPos( const QString& serverName, uint pos );

	/**
		Dodaje pozycj na list ostatnio szukanych miejscowoci
		\param location nazwa miejscowoci
		\return true, jeli 'location' byo nowe, false, jeli ju byo na licie
	**/
	bool insertRecentLocation( const QString& location );
	
};

extern WeatherGlobal* weather_global;

#endif // WEATHER_GLOBAL_H
