
/*
 * background.h -- written for Juice
 *	Copyright (C) 1999, 2000, 2001 Abraham vd Merwe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef DIALOGS_BACKGROUND_H
#define DIALOGS_BACKGROUND_H

#include "typedefs.h"
#include "windows.h"

typedef struct StatusRec
{
   struct StatusRec *next;
   char *keyname;
   char *description;
} StatusType;

class Background : public Windows
{
 public:
   /* Initialize datastructures */
   Background ();
   /* Cleanup datastructures */
   ~Background ();
   /* Create a background */
   void CreateBackground (const char *progname,const char *version,const char *author);
   /* Add a hotkey to the status bar */
   void AddHotkeyStatus (const char *keyname,const char *description);
   /* Remove a function from the status bar */
   void RemoveHotkeyStatus (const char *keyname);
 private:
   /* Hotkey datastructure */
   StatusType *status;
};

#endif
