from jppy.core import Component, Interface, implements
from jppy.config import OrderedExtensionsOption

class IConduit(Interface):
    def pre_sync_pre_connect(self):
        pass
    
    def pre_sync(self):
        pass

    def sync(self, sd):
        pass

    def post_sync(self):
        pass

class Conduit(Component):
    implements(IConduit)

    def pre_sync_pre_connect(self):
        pass
    
    def pre_sync(self):
        pass

    def sync(self, sd):
        pass

    def post_sync(self):
        pass

class ConduitManager(Component):
    conduits = OrderedExtensionsOption("conduit","enabled",IConduit,
                                       default="jppy.conduits.example.ExampleSync",
                                       include_missing=False)

    def pre_sync_pre_connect(self):
        for conduit in self.conduits:
            conduit.pre_sync_pre_connect()
    
    def pre_sync(self):
        for conduit in self.conduits:
            conduit.pre_sync()

    def sync(self, sd):
        for conduit in self.conduits:
            conduit.sync(sd)

    def post_sync(self):
        for conduit in self.conduits:
            conduit.post_sync()
