<?php

require_once 'common_child.inc.php';
jffnms_load_api('iad');

$Child = new JffnmsEngineChild($argv);
iad_child_main_loop();

function iad_child_main_loop()
{
    global $Child;
  $old_time = 0;

  while(TRUE)
  {
    //child_send_pong();
    $read_fds = array($Child->stdin);
    $write_fds = NULL;
    $except_fds = NULL;

    $nr = stream_select($read_fds, $write_fds, $except_fds, 1);
    if ($nr === FALSE)
    {
      $Child->send_error("Child process had error on select.");
      continue;
    }
    if ($nr == 0)
    {
      $old_time = $Child->check_heartbeat($old_time);
      continue;
    }

    $line = fgets($Child->stdin,4096);
    $params = unserialize($line);
    if (!is_array($params))
    {
        $Child->send_error("Received bad line from parent, not an array");
        continue;
    }
    if (!array_key_exists('cmd', $params)) {
        $Child->send_error("Recieved array from parent with no cmd field.");
        continue;
    }
    switch($params['cmd']) {
    case 'DIE':
      die();
      break;
    case 'POLL':
      if (child_discover_interfaces($params) === TRUE)
          $Child->send_array('DONE');
      else
          $Child->send_array('NOTDONE');
      break;
    default:
        $Child->send_error("Received unknown command '".$params['cmd']."'");
    }//switch cmd
    $old_time = $Child->check_heartbeat($old_time);
  }
}

function child_discover_interfaces($params)
{
  $iad_time = time_msec();
  $Interfaces = new JffnmsInterfaces();
  $InterfaceTypesFields = new JffnmsInterface_types_fields();

  $autodiscovery = iad_get_autodiscovery($params['autodiscovery_id']);
  $interface_types = iad_get_interface_types($params['itype']);
  if ($interface_types === FALSE)
    return FALSE;

  if ($params['sysobjectid'] == NULL && $params['rocommunity'] != '')
    $params['sysobjectid'] = update_sysobject_id($params['host_id'], 
    $params['host_ip'], $params['rocommunity']);
  // loop through itypes
  foreach($interface_types as $it_id => $itype)
  {
    discovery_logger($params['host_id'], $it_id, FALSE, 
        'Autodiscovering '.$itype['description']);

    // skip it if the sysobjectids don't match
    if ($itype['snmp_oid'] != NULL && $itype['snmp_oid'] != '')
    {
      if ($params['rocommunity'] == '' )
      {
        discovery_logger($params['host_id'], $it_id, FALSE, 
          "  Skipping: No host RO community to find OID $itype[snmp_oid]");
        continue;
      }
      if (sysobjectid_matches($params['sysobjectid'], $itype['snmp_oid']) == FALSE)
      {
        discovery_logger($params['host_id'], $it_id, FALSE, 
          "  Skipping: Host sysObjectId $params[sysobjectid] != $itype[snmp_oid]");
        continue;
      }
    }
    $db_interfaces = iad_interfaces_from_db($Interfaces, $params['host_id'], $it_id);
    $ad_interfaces = iad_interfaces_from_discovery(
      $itype['autodiscovery_function'], $params['host_ip'], 
      $params['rocommunity'], $params['host_id'],
      $itype['autodiscovery_parameters']);

     $fields = $InterfaceTypesFields->get_all (NULL,
        array('itype'=>$itype['id'],'exclude_types'=>20));
    if (is_array($ad_interfaces) && count($ad_interfaces) > 0)
    {
      $unique_interfaces = array_unique(array_merge(array_merge(array_keys($ad_interfaces), array_keys($db_interfaces))));
      foreach($unique_interfaces as $key)
      {
        if ($key < 0)
          continue;
        $processed = FALSE;
        discovery_logger($params['host_id'], $itype['id'], $key,
          'DB  : '.(isset($db_interfaces[$key])?iad_show_interface($fields,$db_interfaces[$key]):'Not Found'));
        discovery_logger($params['host_id'], $itype['id'], $key,
          'HOST: '.(isset($ad_interfaces[$key])?iad_show_interface($fields,$ad_interfaces[$key]):'Not Found'));

        // Not in DB but in Host = add new
        if (!isset($db[$key]) && isset($host[$key]))
        {
          if (iad_permit_new($host[$key], $host_info))
          {
            $text = '';
            discovery_logger($host_info['id'], $it['id'], $key,
              'RES : New Interface Found');
            //if the AD policy permits adding an interface.
            if ($host_info['permit_add']==1)
            {
              //if the AD policy says use default poller
              if ($host_info['poller_default']==1)
                ad_set_default ($host[$key]['poll'],$it['autodiscovery_default_poller']); //use the interface type default poller for this new interface
              ad_set_default ($host[$key]['client'],$host_info['autodiscovery_default_customer']);
              ad_set_default ($host[$key]['sla'],$it['sla_default']);
              //Find the Index Field
               foreach ($fields as $fdata)
                if ($fdata['ftype']==3)
                {
                  $index_field = $fdata['name'];
                  break;
                }
              //add the index field as data to use when adding a record
              $host[$key][$index_field]=$key;

                //delete the status fields, because they will not be found in the db
                unset ($host[$key]['admin']);
                unset ($host[$key]['oper']);

                $interface_id = adm_interfaces_add(array('host'=>$host_info['id'],'type'=>$it['id'])); //add new record
                adm_interfaces_update($interface_id,$host[$key]); //update it with the data
                $text = '- Added';
              } // permit add
              if ($log_events==true)
                insert_event ($now_date, $event_type_id, $host_info['id'], $host[$key]['interface'], //add informative event
                  'alert','autodiscovery',trim('Found '.$text),0); 
              $processed = 1;
            } // if allow add
          }

      } //foreach unique int id
    }
  } //foreach itype
  $iad_time = round(time_msec_diff($iad_time));
  logger('H '.str_pad($params['host_id'],3,' ',STR_PAD_LEFT)." : Autodiscovery took ".$iad_time." msec.\n");
  return TRUE;
}


function iad_get_autodiscovery($autodiscovery_id)
{
  static $autodiscovery_cache = array();

  if (array_key_exists($autodiscovery_id, $autodiscovery_cache))
    return $autodiscovery_cache[$autodiscovery_id];

  $iad_query = '
    SELECT
      poller_default, permit_add, permit_del, permit_mod, permit_disable,
      skip_loopback, check_state, check_address, alert_del
    FROM autodiscovery
    WHERE id = '.$autodiscovery_id;

  $iad_result = db_query($iad_query) or die ('Query failed - iad cache - '.db_error());
  if (!($iad_row = db_fetch_array($iad_result)))
    return FALSE;
  $autodiscovery_cache[$autodiscovery_id] = $iad_row;
  return $iad_row;
} //iad_get_autodiscovery()

function iad_get_interface_types($itype_id=FALSE)
{
  static $itypes_cache = FALSE;

  if (!is_array($itypes_cache))
  {
    //fill the cache
    $itype_query = '
      SELECT
        id, autodiscovery_validate, autodiscovery_function,
        autodiscovery_parameters, autodiscovery_default_poller,
        description, sla_default, snmp_oid
      FROM interface_types
      WHERE id > 1 AND
      autodiscovery_enabled = 1
      ORDER BY id';
    $itype_result = db_query($itype_query) or die ('Query failed - iad_get_interface_types() - '.db_error());
    while ($itype_row = db_fetch_array($itype_result))
    {
      $id = $itype_row['id'];
      $itypes_cache[$id] = $itype_row;
    }
  }//cache fill
  if (is_numeric($itype_id))
  {
    if (!array_key_exists($itype_id, $itypes_cache))
      return FALSE;
    return array($itype_id => $itypes_cache[$itype_id]);
  }
  return $itypes_cache;
} // iad_get_interface_types()

function discovery_logger($host, $itype, $intid, $result)
{
  logger( 'H '.str_pad($host,3,' ',STR_PAD_LEFT).' : '.
          'IT '.str_pad($itype,3,' ',STR_PAD_LEFT).' : '.
          ($intid?'I '.str_pad($intid,4,' ',STR_PAD_LEFT).' : ':'').
          "$result.\n");
}

function iad_show_interface ($fields,$data)
{
  $fields = array_merge(array(array('name'=>'interface', 'ftype'=>1, 'ftype_handler'=>'none')),$fields);  

  $text = array();   
  foreach ($fields as $fdata)
    if (isset($fdata['ftype']) && ($fdata['ftype']!=3) && isset($fdata['ftype_handler']) && ($fdata['ftype_handler']!='bool'))
    $text[] = substr($fdata['name'],0,4).': '.(isset($data[$fdata['name']])?$data[$fdata['name']]:'');
  $text = join(" | ",$text);
  return $text;
}

// Not in database but found in host - is it really supposed to be there?
function iad_permit_new(&$host_data, &$host_info)
{
  if ($itype['autodiscovery_validate'] == 1)
    return FALSE;

  if ($host_info['skip_loopback'] == 1 && (
    preg_match('/(loopback.*|null.*|lo\d*)$/i', $host_data['interface']) ||
    (array_key_exists('address', $host_data) && $host_data['address'] == '127.0.0.1')))
    return FALSE;

  if ($host_info['check_address'] == 1 && (
    !array_key_exists('address', $host_data ||
    $host_data['address'] == '' ||
    $host_data['address'] == '0.0.0.0')))
    return FALSE;

  if ($host_info['check_state'] == 1 &&
    $Alarms->lookup($host_data['oper']) != ALARM_UP)
    return FALSE;

  return TRUE;
}

function update_sysobject_id($host_id, $host_ip, $rocommunity)
{
  $oid = '.1.3.6.1.2.1.1.2.0';
  $sysObjectId = snmp_get($host_ip, $rocommunity, $oid);
  if ($sysObjectId === FALSE)
    return NULL;
  db_update('hosts', $host_id, array('sysobjectid' => $sysObjectId));
  return $sysObjectId;
}

function sysobjectid_matches($host_id, $itype_id)
{
    if ($itype_id == '')
        return TRUE;
    if ($itype_id == '.' && $host_id != '')
        return TRUE;
    $host_id = substr(preg_replace('/^'.ENTERPRISES_OID.'\./','ent.',
        $host_id), 0, strlen($itype_id));
    return ($host_id == $itype_id);
}
