/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.apache.jmeter.gui.action;

/*
 * Collect all the action names together in one place.
 * This helps to ensure that there are no duplicates
 *
 *
 */
public class ActionNames {

    public static final String ABOUT            = "about"; // $NON-NLS-1$
    public static final String ACTION_SHUTDOWN  = "shutdown"; // $NON-NLS-1$
    public static final String ACTION_START     = "start"; // $NON-NLS-1$
    public static final String ACTION_STOP      = "stop"; // $NON-NLS-1$
    public static final String ADD              = "Add"; // $NON-NLS-1$
    public static final String ADD_ALL          = "add_all"; // $NON-NLS-1$
    public static final String ADD_PARENT       = "Add Parent"; // $NON-NLS-1$
    public static final String ANALYZE_FILE     = "Analyze File"; // $NON-NLS-1$
    public static final String CHANGE_LANGUAGE  = "change_language"; // $NON-NLS-1$
    public static final String CHECK_DIRTY      = "check_dirty"; // $NON-NLS-1$
    public static final String CHECK_REMOVE     = "check_remove"; // $NON-NLS-1$
    public final static String CLEAR            = "action.clear"; // $NON-NLS-1$
    public final static String CLEAR_ALL        = "action.clear_all"; // $NON-NLS-1$
    public static final String CLOSE            = "close"; // $NON-NLS-1$
    public static final String COLLAPSE_ALL     = "collapse all"; // $NON-NLS-1$
    public static final String COPY             = "Copy"; // $NON-NLS-1$
    public final static String CUT              = "Cut"; // $NON-NLS-1$
    public static final String DEBUG_ON         = "debug_on"; // $NON-NLS-1$
    public static final String DEBUG_OFF        = "debug_off"; // $NON-NLS-1$
    public static final String DISABLE          = "disable"; // $NON-NLS-1$
    public final static String DRAG_ADD         = "drag_n_drop.add";//$NON-NLS-1$
    public static final String EDIT             = "edit"; // $NON-NLS-1$
    public static final String ENABLE           = "enable"; // $NON-NLS-1$
    public static final String EXIT             = "exit"; // $NON-NLS-1$
    public static final String EXPAND_ALL       = "expand all"; // $NON-NLS-1$
    public static final String FUNCTIONS        = "functions"; // $NON-NLS-1$
    public final static String HELP             = "help"; // $NON-NLS-1$
    public final static String INSERT_AFTER     = "drag_n_drop.insert_after";//$NON-NLS-1$
    public final static String INSERT_BEFORE    = "drag_n_drop.insert_before";//$NON-NLS-1$
    public static final String LAF_PREFIX       = "laf:"; // Look and Feel prefix
    public static final String MERGE            = "merge"; // $NON-NLS-1$
    public static final String OPEN             = "open"; // $NON-NLS-1$
    public static final String OPEN_RECENT      = "open_recent"; // $NON-NLS-1$
    public static final String PASTE            = "Paste"; // $NON-NLS-1$
    public static final String REMOTE_EXIT      = "remote_exit"; // $NON-NLS-1$
    public static final String REMOTE_EXIT_ALL  = "remote_exit_all"; // $NON-NLS-1$
    public static final String REMOTE_START     = "remote_start"; // $NON-NLS-1$
    public static final String REMOTE_START_ALL = "remote_start_all"; // $NON-NLS-1$
    public static final String REMOTE_STOP      = "remote_stop"; // $NON-NLS-1$
    public static final String REMOTE_STOP_ALL  = "remote_stop_all"; // $NON-NLS-1$
    public static final String REMOVE           = "remove"; // $NON-NLS-1$
    public static final String RESET_GUI        = "reset_gui"; // $NON-NLS-1$
    public static final String REVERT_PROJECT   = "revert_project"; // $NON-NLS-1$
    public final static String SAVE             = "save"; // $NON-NLS-1$
    public final static String SAVE_ALL_AS      = "save_all_as";  // $NON-NLS-1$
    public final static String SAVE_AS          = "save_as"; // $NON-NLS-1$
    public static final String SAVE_GRAPHICS    = "save_graphics"; // $NON-NLS-1$
    public static final String SAVE_GRAPHICS_ALL= "save_graphics_all"; // $NON-NLS-1$
    public static final String SSL_MANAGER      = "sslManager"; // $NON-NLS-1$
    public static final String SUB_TREE_LOADED  = "sub_tree_loaded"; // $NON-NLS-1$
    public static final String SUB_TREE_MERGED  = "sub_tree_merged"; // $NON-NLS-1$
    public static final String SUB_TREE_SAVED   = "sub_tree_saved"; // $NON-NLS-1$
    public static final String WHAT_CLASS       = "what_class"; // $NON-NLS-1$

    // Prevent instantiation
    private ActionNames(){

    }
}
