/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Instantbird messenging client, released
 * 2007.
 *
 * The Initial Developer of the Original Code is
 * Florian QUEZE <florian@instantbird.org>.
 * Portions created by the Initial Developer are Copyright (C) 2007
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#ifndef PURPLE_BUDDY_H_
#define PURPLE_BUDDY_H_

#include "purpleIBuddy.h"
#include "nsCOMPtr.h"
#include "purpleAccount.h"
#include "purpleAccountBuddy.h"
#include "nsTArray.h"

// 9090b5e6-51fb-4495-92d1-a0f713f4f7f9
#define PURPLE_BUDDY_CID                                        \
  { 0x9090b5e6, 0x51fb, 0x4495,                                 \
      { 0x92, 0xd1, 0xa0, 0xf7, 0x13, 0xf4, 0xf7, 0xf9 }        \
  }

#define PURPLE_BUDDY_CONTRACTID                 \
  "@instantbird.org/purple/buddy;1"

class purpleBuddy : public purpleIBuddy
{
public:
  NS_DECL_ISUPPORTS
  NS_DECL_PURPLEIBUDDY

  purpleBuddy();
  nsresult Init(PurpleBuddy *aBuddy);
  void UnInit() { mId = 0; }
  nsresult UnStore();
  nsresult load(PurpleBuddy *aBuddy, purpleIAccount *aAccount,
                PRUint32 aId, purpleTag *aTag);
  nsresult AddAccount(PurpleBuddy *aBuddy);
  purpleAccountBuddy *AddAccount(purpleIAccount *aAccount,
                                 PurpleBuddy *aBuddy,
                                 purpleTag *aTag);
  nsresult RemoveAccount(PurpleBuddy *aBuddy);
  PRInt32 GetAccountCount() { return mBuddies.Count(); }
  nsresult UpdateServerAlias(const char *aAlias);
  PRUint32 getId() { return mId; }

private:
  ~purpleBuddy();
  nsresult GetContactId(PRInt64 *aContactId);

protected:
  /* additional members */
  PRUint32 mId;
  nsCString mAlias;
  nsCOMArray<purpleAccountBuddy> mBuddies;
};

#endif /* !PURPLE_BUDDY_H_ */
