/*=========================================================================
 *
 *  Copyright Insight Software Consortium
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0.txt
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 *
 *=========================================================================*/
#ifndef __itkLevelSetEquationRegionTermBase_h
#define __itkLevelSetEquationRegionTermBase_h

#include "itkLevelSetEquationTermBase.h"

namespace itk
{
template< class TInput,
          class TLevelSetContainer >
class LevelSetEquationRegionTermBase :
    public LevelSetEquationTermBase< TInput, TLevelSetContainer >
{
public:
  typedef LevelSetEquationRegionTermBase                         Self;
  typedef SmartPointer< Self >                                   Pointer;
  typedef SmartPointer< const Self >                             ConstPointer;
  typedef LevelSetEquationTermBase< TInput, TLevelSetContainer > Superclass;

  typedef TInput                      InputType;
  typedef typename InputType::Pointer InputPointer;

  typedef TLevelSetContainer                           LevelSetContainerType;
  typedef typename LevelSetContainerType::Pointer      LevelSetContainerPointer;
  typedef typename LevelSetContainerType::OutputType   LevelSetOutputType;
  typedef typename LevelSetContainerType::InputType    LevelSetInputType;
  typedef typename LevelSetContainerType::GradientType GradientType;
  typedef typename LevelSetContainerType::HessianType  HessianType;

protected:
  LevelSetEquationRegionTermBase() : Superclass()
  {}

  virtual ~LevelSetEquationRegionTermBase() {}

private:
  LevelSetEquationRegionTermBase( const Self& );
  void operator = ( const Self& );
};
}
#endif // __itkLevelSetEquationRegionTermBase_h
