/*=========================================================================
*
*  Copyright Insight Software Consortium
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/

// This code fragment is included in the test driver generated by the
// CMake command create_test_sourcelist. This is included directly after
// the call to the test main function. It performs optional redirection
// of test output and regression testing if needed.

if (redirectOutputParameters.redirect)
  {
  // Restore cout
  std::cout.rdbuf(oldCoutBuf);
  redirectStream.close();
  }

// before the image to image compare we first check md5 hashes
for( size_t li = 0; li < hashTestList.size(); ++li )
  {
  const char * testFilename = hashTestList[li].first;

  int ret = 0;

  if ( (ret = HashTestImage( testFilename, hashTestList[li].second )) )
    {
    result += ret;
    }
  }

// Make a list of possible baselines
for ( int ii = 0;
      ii < static_cast< int >( regressionTestParameters.compareList.size() );
      ii++ )
  {
  char * baselineFilename = regressionTestParameters.compareList[ii].first;
  char * testFilename =     regressionTestParameters.compareList[ii].second;
  std::map< std::string, int > baselines =
    RegressionTestBaselines(baselineFilename);
  std::map< std::string, int >::iterator baseline = baselines.begin();
  std::string bestBaseline;
  int  bestBaselineStatus = itk::NumericTraits< int >::max();
  while ( baseline != baselines.end() )
    {
    baseline->second =
      RegressionTestImage(testFilename,
                          ( baseline->first ).c_str(),
                          0,
                          regressionTestParameters.intensityTolerance,
                          regressionTestParameters.numberOfPixelsTolerance,
                          regressionTestParameters.radiusTolerance);

    if ( baseline->second < bestBaselineStatus )
      {
      bestBaseline = baseline->first;
      bestBaselineStatus = baseline->second;
      }
    if ( baseline->second == 0 )
      {
      break;
      }
    ++baseline;
    }
  // if the best we can do still has errors, generate the error images
  if ( bestBaselineStatus )
    {
    RegressionTestImage( testFilename,
                         bestBaseline.c_str(),
                         1,
                         regressionTestParameters.intensityTolerance,
                         regressionTestParameters.numberOfPixelsTolerance,
                         regressionTestParameters.radiusTolerance);
    }

  // output the matching baseline
  std::cout << "<DartMeasurement name=\"BaselineImageName\" type=\"text/string\">";
  std::cout << itksys::SystemTools::GetFilenameName(bestBaseline);
  std::cout << "</DartMeasurement>" << std::endl;

  result += bestBaselineStatus;
  }
}
  catch ( const itk::ExceptionObject & e )
    {
    std::cerr << "ITK test driver caught an ITK exception:\n";
    e.Print(std::cerr);
    result = -1;
    }
  catch ( const std::exception & e )
    {
    std::cerr << "ITK test driver caught an exception:\n";
    std::cerr << e.what() << "\n";
    result = -1;
    }
  catch ( ... )
    {
    std::cerr << "ITK test driver caught an unknown exception!!!\n";
    result = -1;
    }
