if ("undefined" == typeof(ImapAclExt)) {
	var ImapAclExt = {};
};
if ("undefined" == typeof(ImapAclExt.ChangeAcl)) {
  ImapAclExt.ChangeAcl = {	
	Cc : Components.classes,
	Ci : Components.interfaces,
	_pref : null,
	_stringBundle : null,

	init : function() {
		this._stringBundle = document.getElementById("changeAcl-bundle");
		this._pref = this.Cc['@mozilla.org/preferences-service;1']
					.getService(this.Ci.nsIPrefBranch);
					
		this.toggleMode(this._pref.getBoolPref("extensions.ImapAclExt.advMode"));
		
		var usernameBox = document.getElementById("username_box");
		var selected = window.arguments[0];

		if (selected==-1)
		{
			document.title=this._stringBundle.getString("newUser");
		}
		else
		{
			document.title=this._stringBundle.getString("setRightsFor") + ": " + selected.username;
			usernameBox.value = selected.username;
			usernameBox.disabled = "true";
			
			var uacl = selected.permissions;
			
			if(this._pref.getBoolPref("extensions.ImapAclExt.advMode")) {
				//Parse ACL-string
				var atom=uacl.indexOf("l");
				var check = document.getElementById("lacl");
				if (atom!=-1) {
					check.checked="true";
				}
			
				atom=uacl.indexOf("r");
					check = document.getElementById("racl");
				if (atom!=-1) {
					check.checked="true";
				}

				atom=uacl.indexOf("s");
					check = document.getElementById("sacl");
				if (atom!=-1) {
					check.checked="true";
				}

				atom=uacl.indexOf("w");
					check = document.getElementById("wacl");
				if (atom!=-1) {
					check.checked="true";
				}

				atom=uacl.indexOf("i");
					check = document.getElementById("iacl");
				if (atom!=-1) {
					check.checked="true";
				}

				atom=uacl.indexOf("p");
					check = document.getElementById("pacl");
				if (atom!=-1) {
					check.checked="true";
				}

				atom=uacl.indexOf("c");
					check = document.getElementById("cacl");
				if (atom!=-1) {
					check.checked="true";
				}

				atom=uacl.indexOf("d");
					check = document.getElementById("dacl");
				if (atom!=-1) {
					check.checked="true";
				}

				atom=uacl.indexOf("a");
					check = document.getElementById("aacl");
				if (atom!=-1) {
					check.checked="true";
				}
			} else {
				if (uacl.indexOf("l")!=-1 && uacl.indexOf("r")!=-1 && 
					uacl.indexOf("s")!=-1) {
					document.getElementById("readAcl").checked="true";
				}
				
				if (uacl.indexOf("l")!=-1 && uacl.indexOf("r")!=-1 && 
					uacl.indexOf("s")!=-1 && uacl.indexOf("w")!=-1 &&
					uacl.indexOf("i")!=-1) {
					
					document.getElementById("insertAcl").checked="true";
					
				}
				
				if (uacl.indexOf("l")!=-1 && uacl.indexOf("r")!=-1 && 
					uacl.indexOf("s")!=-1 && uacl.indexOf("w")!=-1 &&
					uacl.indexOf("i")!=-1 && uacl.indexOf("d")!=-1) {
					
					document.getElementById("deleteAacl").checked="true";
					
				}							
			}			
		}
	},
	
	change : function() {
		var usernameBox = document.getElementById("username_box");
		var username = usernameBox.value
		if (username == "" || username == null) {
			alert(this._stringBundle.getString("noUser"));
			return false;
		}
		
		var aclstring = "";

		if(this._pref.getBoolPref("extensions.ImapAclExt.advMode")) {
			var check = document.getElementById("lacl");
			if (check.checked == true) {
				aclstring+="l";
			}

			check = document.getElementById("racl");
			if (check.checked == true) {
				aclstring+="r";
			}

			check = document.getElementById("sacl");
			if (check.checked == true) {
				aclstring+="s";
			}

			check = document.getElementById("wacl");
			if (check.checked == true) {
				aclstring+="w";
			}

			check = document.getElementById("iacl");
			if (check.checked == true) {
				aclstring+="i";
			}

			check = document.getElementById("pacl");
			if (check.checked == true) {
				aclstring+="p";
			}

			check = document.getElementById("cacl");
			if (check.checked == true) {
				aclstring+="c";
			}

			check = document.getElementById("dacl");
			if (check.checked == true) {
				aclstring+="d";
			}

			check = document.getElementById("aacl");
			if (check.checked == true) {
				aclstring+="a";
			}
		} else {
			if (document.getElementById("deleteAacl").checked == true) {
				aclstring = "lrswid";
			}
			else if (document.getElementById("insertAcl").checked == true) {
				aclstring = "lrswi";
			}
			else if (document.getElementById("readAcl").checked == true) {
				aclstring = "lrs";
			}
		}
				
		if (aclstring == "") {
			alert(this._stringBundle.getString("noAcl"));
			return false;
		}

		var imapFolder = window.arguments[3];
		if (imapFolder.server.realUsername == username) {
			alert(this._stringBundle.getString("noSelfAcl"));
		}

		var result = ImapAclExt.Utils.setAcl(imapFolder, username, aclstring);
		
		if (result != "success") {
			if (result == "noAclRight") {
				alert(this._stringBundle.getString("noAclRight"));
			} else {
				alert(result);
			}
			return false;
		}
		
		return true;
	},
	
	cancel : function(){
		window.arguments[1].value = "Cancel";
		return true;
	},
	
	toggleMode : function (advMode) {
		if (advMode) {
			document.getElementById("readAcl").hidden = true;
			document.getElementById("insertAcl").hidden = true;
			document.getElementById("deleteAacl").hidden = true;
		} else {
			document.getElementById("lacl").hidden = true;
			document.getElementById("racl").hidden = true;
			document.getElementById("sacl").hidden = true;
			document.getElementById("wacl").hidden = true;
			document.getElementById("iacl").hidden = true;
			document.getElementById("pacl").hidden = true;
			document.getElementById("cacl").hidden = true;
			document.getElementById("dacl").hidden = true;
			document.getElementById("aacl").hidden = true;
		}
	}
  };
  (function() {
		this.init();
  }).apply(ImapAclExt.ChangeAcl);
};
