if ("undefined" == typeof(ImapAclExt)) {
	var ImapAclExt = {};
};
if ("undefined" == typeof(ImapAclExt.Aclist)) {
  ImapAclExt.Aclist = {	  
	Cc : Components.classes,
	Ci : Components.interfaces, 
	_userAclList : new Array(),
	_timer : null,
	_callRefreshUserlist : { notify: function(timer) { this.refreshUserlist(); } },
	_pref : null,
	_stringBundle : null,
	_userList : null,
	
	init : function() {
		this._stringBundle = document.getElementById("acls-bundle");
		this._pref = this.Cc['@mozilla.org/preferences-service;1']
					.getService(this.Ci.nsIPrefBranch);
					
		this._userList = document.getElementById("user_list");
		
		if (this._userList == null) {
			if (this._timer == null)
				this._timer = this.Cc["@mozilla.org/timer;1"].createInstance(this.Ci.nsITimer);
			
			this._timer.initWithCallback(this._callRefreshUserlist, 2000, this.Ci.nsITimer.TYPE_ONE_SHOT);
			return;			
		}
		this.buildList();
	},

	buildList : function() {
		this._userAclList = new Array();
                var imapFolder = window.arguments[0];
                
                //manual check if cyrus -> manual getting of acls!
				ImapAclExt.Utils.check(imapFolder);
								
                var enumer = imapFolder.getOtherUsersWithAccess();
                while (enumer.hasMore()) {						
                        var user = enumer.getNext();
                        
                        if (imapFolder.server.realUsername != user) {
                                var rights = imapFolder.getPermissionsForUser(user);
                                if (rights != "") {
                                        this.addAclToList(this._userList, user, rights);
                                        this._userAclList.push({username: user, permissions: rights});
                                }
                        }
                }
	},

	addAclToList : function (userList, username, aclstring) {
		var usernameCell = document.createElement("listcell");
		var aclstringCell = document.createElement("listcell");
		
		usernameCell.setAttribute("label", username);
		aclstringCell.setAttribute("label", aclstring);
		aclstringCell.setAttribute("cvalue", aclstring);

		var item = document.createElement("listitem");
		item.name = "aclRightsListItemName";
		item.value = username;
		item.appendChild(usernameCell);
		item.appendChild(aclstringCell);

		this._userList.appendChild(item);
	},

	refresh : function() {
		//this.buildList();
		var items = this._userList.childNodes;
		//window.dump(this._userList.childNodes.length);
		for (var i=items.length-1;i>0;--i) {
			//window.dump("found: " + items[i].value + "\n");
			if (items[i].name == "aclRightsListItemName") {
			//	window.dump("removed" + items[i].value + "\n");
				items[i].parentNode.removeChild(items[i]); //items[i].hidden = true;
			}
		}
		this.buildList();
	},

	change : function() {
		var selected = this._userList.selectedIndex;
		
		if (selected == -1) {
			window.alert(this._stringBundle.getString("noEntry"));
			return "true";
		}

		var aclstring = new Object();
		var username = new Object();

		if (this._pref.getBoolPref("extensions.ImapAclExt.advMode")) {
			window.openDialog("chrome://imapaclext/content/changeAcl.xul", "changeAcl", 
				"modal=yes,dialog=yes,centerscreen=yes,resizable=no,height=295,width=300", 
				this._userAclList[selected], aclstring, username, window.arguments[0]);
		} else {
			window.openDialog("chrome://imapaclext/content/changeAcl.xul", "changeAcl", 
				"modal=yes,dialog=yes,centerscreen=yes,resizable=no,height=150,width=300", 
				this._userAclList[selected], aclstring, username, window.arguments[0]);		
		}
		
		if (aclstring.value != "Cancel") {
			this.refresh();
		}
	},

	cnew : function() {
		var aclstring = new Object();
		var username = new Object();
		
		if (this._pref.getBoolPref("extensions.ImapAclExt.advMode")) {
			window.openDialog("chrome://imapaclext/content/changeAcl.xul", "changeAcl", 
			"modal=yes,dialog=yes,centerscreen=yes,resizable=yes,height=295,width=300", 
			-1, aclstring, username, window.arguments[0]);
		} else {
			window.openDialog("chrome://imapaclext/content/changeAcl.xul", "changeAcl", 
			"modal=yes,dialog=yes,centerscreen=yes,resizable=yes,height=150,width=300", 
			-1, aclstring, username, window.arguments[0]);		
		}
		
		if (aclstring.value != "Cancel") {
			this.refresh();
		}
	},

	del : function() {
		var selected = this._userList.selectedIndex;

		if (selected == -1) {
			window.alert(this._stringBundle.getString("noEntry"));
			return "true";
		}
				
		var q = this._stringBundle.getString("delRights") + ": " + 
					this._userAclList[selected].username + "?";
		
		var check = confirm(q);
		if (check == true) {
			//delete && refresh
			var result = ImapAclExt.Utils.delAcl(window.arguments[0], this._userAclList[selected].username);
					
			if (result != "success") {
				if (result == "noAclRight") {
					alert(this._stringBundle.getString("noAclRight"));
				} else {
					alert(result);
				}
			}
			this.refresh();
		}
	},

	cancel : function () {
		window.arguments[1].value = "Cancel";
	}
  };
  (function() {
		this.init();
  }).apply(ImapAclExt.Aclist);
};
