/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.file.BaseFileObject;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.ClientCodeException;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.DiagnosticFormatter;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Messages;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.CharBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.tools.DiagnosticListener;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Log {
    public static final Context.Key<Log> logKey = new Context.Key();
    public static final Context.Key<PrintWriter> outKey = new Context.Key();
    public final PrintWriter errWriter;
    public final PrintWriter warnWriter;
    public final PrintWriter noticeWriter;
    public final int MaxErrors;
    public final int MaxWarnings;
    private final boolean showSourceLine;
    public boolean promptOnError;
    public boolean emitWarnings;
    public boolean dumpOnError;
    public boolean multipleErrors;
    protected DiagnosticListener<? super JavaFileObject> diagListener;
    private DiagnosticFormatter diagFormatter;
    private JCDiagnostic.Factory diags;
    protected JCDiagnostic.DiagnosticSource source;
    public int nerrors = 0;
    public int nwarnings = 0;
    public boolean unrecoverableError;
    private Set<Pair<JavaFileObject, Integer>> recorded = new HashSet<Pair<JavaFileObject, Integer>>();
    private Map<JavaFileObject, Map<JCTree, Integer>> endPosTables;
    private char[] buf = null;
    private int bp;
    private int line;
    private int lineStart;

    @Deprecated
    protected Log(Context context, PrintWriter printWriter, PrintWriter printWriter2, PrintWriter printWriter3) {
        DiagnosticListener diagnosticListener;
        context.put(logKey, this);
        this.errWriter = printWriter;
        this.warnWriter = printWriter2;
        this.noticeWriter = printWriter3;
        this.diags = JCDiagnostic.Factory.instance(context);
        Options options = Options.instance(context);
        this.dumpOnError = options.get("-doe") != null;
        this.promptOnError = options.get("-prompt") != null;
        this.emitWarnings = options.get("-Xlint:none") == null;
        this.MaxErrors = this.getIntOption(options, "-Xmaxerrs", 100);
        this.MaxWarnings = this.getIntOption(options, "-Xmaxwarns", 100);
        this.showSourceLine = options.get("rawDiagnostics") == null;
        this.diagFormatter = DiagnosticFormatter.instance(context);
        this.diagListener = diagnosticListener = context.get(DiagnosticListener.class);
    }

    private int getIntOption(Options options, String string, int n) {
        String string2 = options.get(string);
        try {
            if (string2 != null) {
                return Integer.parseInt(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    static final PrintWriter defaultWriter(Context context) {
        PrintWriter printWriter = context.get(outKey);
        if (printWriter == null) {
            printWriter = new PrintWriter(System.err);
            context.put(outKey, printWriter);
        }
        return printWriter;
    }

    protected Log(Context context) {
        this(context, Log.defaultWriter(context));
    }

    protected Log(Context context, PrintWriter printWriter) {
        this(context, printWriter, printWriter, printWriter);
    }

    public static Log instance(Context context) {
        Log log = context.get(logKey);
        if (log == null) {
            log = new Log(context);
        }
        return log;
    }

    public boolean hasDiagnosticListener() {
        return this.diagListener != null;
    }

    public void setEndPosTable(JavaFileObject javaFileObject, Map<JCTree, Integer> map) {
        if (this.endPosTables == null) {
            this.endPosTables = new HashMap<JavaFileObject, Map<JCTree, Integer>>();
        }
        this.endPosTables.put(javaFileObject, map);
    }

    public JavaFileObject useSource(final JavaFileObject javaFileObject) {
        JavaFileObject javaFileObject2 = this.currentSource();
        if (javaFileObject != javaFileObject2) {
            this.source = new JCDiagnostic.DiagnosticSource(){

                @Override
                public JavaFileObject getFile() {
                    return javaFileObject;
                }

                @Override
                public CharSequence getName() {
                    if (javaFileObject instanceof BaseFileObject) {
                        return ((BaseFileObject)javaFileObject).getShortName();
                    }
                    return BaseFileObject.getSimpleName(javaFileObject);
                }

                @Override
                public int getLineNumber(int n) {
                    return Log.this.getLineNumber(n);
                }

                @Override
                public int getColumnNumber(int n) {
                    return Log.this.getColumnNumber(n);
                }

                @Override
                public Map<JCTree, Integer> getEndPosTable() {
                    return Log.this.endPosTables == null ? null : (Map)Log.this.endPosTables.get(javaFileObject);
                }
            };
            this.buf = null;
        }
        return javaFileObject2;
    }

    protected void setBuf(char[] cArray) {
        this.buf = cArray;
        this.bp = 0;
        this.lineStart = 0;
        this.line = 1;
    }

    protected char[] getBuf() {
        return this.buf;
    }

    public JavaFileObject currentSource() {
        return this.source == null ? null : this.source.getFile();
    }

    public void flush() {
        this.errWriter.flush();
        this.warnWriter.flush();
        this.noticeWriter.flush();
    }

    protected boolean shouldReport(JavaFileObject javaFileObject, int n) {
        boolean bl;
        if (this.multipleErrors || javaFileObject == null) {
            return true;
        }
        Pair<JavaFileObject, Integer> pair = new Pair<JavaFileObject, Integer>(javaFileObject, n);
        boolean bl2 = bl = !this.recorded.contains(pair);
        if (bl) {
            this.recorded.add(pair);
        }
        return bl;
    }

    public void prompt() {
        if (this.promptOnError) {
            System.err.println(Log.getLocalizedString("resume.abort", new Object[0]));
            try {
                while (true) {
                    switch (System.in.read()) {
                        case 65: 
                        case 97: {
                            System.exit(-1);
                            return;
                        }
                        case 82: 
                        case 114: {
                            return;
                        }
                        case 88: 
                        case 120: {
                            throw new AssertionError((Object)"user abort");
                        }
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void printErrLine(int n, PrintWriter printWriter) {
        int n2;
        if (!this.findLine(n)) {
            return;
        }
        for (n2 = this.lineStart; n2 < this.buf.length && this.buf[n2] != '\r' && this.buf[n2] != '\n'; ++n2) {
        }
        if (n2 - this.lineStart == 0) {
            return;
        }
        Log.printLines(printWriter, new String(this.buf, this.lineStart, n2 - this.lineStart));
        this.bp = this.lineStart;
        while (this.bp < n) {
            printWriter.print(this.buf[this.bp] == '\t' ? "\t" : " ");
            ++this.bp;
        }
        printWriter.println("^");
        printWriter.flush();
    }

    protected static char[] getCharContent(JavaFileObject javaFileObject) throws IOException {
        CharSequence charSequence = javaFileObject.getCharContent(true);
        if (charSequence instanceof CharBuffer) {
            return JavacFileManager.toArray((CharBuffer)charSequence);
        }
        return ((Object)charSequence).toString().toCharArray();
    }

    private boolean findLine(int n) {
        if (n == -1 || this.currentSource() == null) {
            return false;
        }
        try {
            if (this.buf == null) {
                this.buf = Log.getCharContent(this.currentSource());
                this.lineStart = 0;
                this.line = 1;
            } else if (this.lineStart > n) {
                this.lineStart = 0;
                this.line = 1;
            }
            this.bp = this.lineStart;
            while (this.bp < this.buf.length && this.bp < n) {
                switch (this.buf[this.bp++]) {
                    case '\r': {
                        if (this.bp >= this.buf.length || this.buf[this.bp] == '\n') {
                            // empty if block
                        }
                        ++this.line;
                        this.lineStart = ++this.bp;
                        break;
                    }
                    case '\n': {
                        ++this.line;
                        this.lineStart = this.bp;
                    }
                }
            }
            return this.bp <= this.buf.length;
        }
        catch (IOException iOException) {
            Log.printLines(this.errWriter, Log.getLocalizedString("source.unavailable", new Object[0]));
            this.errWriter.flush();
            this.buf = new char[0];
            return false;
        }
    }

    public static void printLines(PrintWriter printWriter, String string) {
        int n;
        while ((n = string.indexOf(10)) != -1) {
            printWriter.println(string.substring(0, n));
            string = string.substring(n + 1);
        }
        if (string.length() != 0) {
            printWriter.println(string);
        }
    }

    public void error(String string, Object ... objectArray) {
        this.report(this.diags.error(this.source, null, string, objectArray));
    }

    public void error(JCDiagnostic.DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
        this.report(this.diags.error(this.source, diagnosticPosition, string, objectArray));
    }

    public void error(int n, String string, Object ... objectArray) {
        this.report(this.diags.error(this.source, this.wrap(n), string, objectArray));
    }

    public void warning(String string, Object ... objectArray) {
        this.report(this.diags.warning(this.source, null, string, objectArray));
    }

    public void warning(JCDiagnostic.DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
        this.report(this.diags.warning(this.source, diagnosticPosition, string, objectArray));
    }

    public void warning(int n, String string, Object ... objectArray) {
        this.report(this.diags.warning(this.source, this.wrap(n), string, objectArray));
    }

    public void mandatoryWarning(JCDiagnostic.DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
        this.report(this.diags.mandatoryWarning(this.source, diagnosticPosition, string, objectArray));
    }

    public void strictWarning(JCDiagnostic.DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
        this.writeDiagnostic(this.diags.warning(this.source, diagnosticPosition, string, objectArray));
        ++this.nwarnings;
    }

    public void note(String string, Object ... objectArray) {
        this.report(this.diags.note(this.source, null, string, objectArray));
    }

    public void note(JCDiagnostic.DiagnosticPosition diagnosticPosition, String string, Object ... objectArray) {
        this.report(this.diags.note(this.source, diagnosticPosition, string, objectArray));
    }

    public void note(int n, String string, Object ... objectArray) {
        this.report(this.diags.note(this.source, this.wrap(n), string, objectArray));
    }

    public void note(JavaFileObject javaFileObject, String string, Object ... objectArray) {
        this.report(this.diags.note(this.wrap(javaFileObject), null, string, objectArray));
    }

    public void mandatoryNote(JavaFileObject javaFileObject, String string, Object ... objectArray) {
        this.report(this.diags.mandatoryNote(this.wrap(javaFileObject), string, objectArray));
    }

    private JCDiagnostic.DiagnosticSource wrap(final JavaFileObject javaFileObject) {
        if (javaFileObject == null) {
            return null;
        }
        return new JCDiagnostic.DiagnosticSource(){

            @Override
            public JavaFileObject getFile() {
                return javaFileObject;
            }

            @Override
            public CharSequence getName() {
                if (javaFileObject instanceof BaseFileObject) {
                    return ((BaseFileObject)javaFileObject).getShortName();
                }
                return BaseFileObject.getSimpleName(javaFileObject);
            }

            @Override
            public int getLineNumber(int n) {
                return Log.this.getLineNumber(n);
            }

            @Override
            public int getColumnNumber(int n) {
                return Log.this.getColumnNumber(n);
            }

            @Override
            public Map<JCTree, Integer> getEndPosTable() {
                return Log.this.endPosTables == null ? null : (Map)Log.this.endPosTables.get(javaFileObject);
            }
        };
    }

    private JCDiagnostic.DiagnosticPosition wrap(int n) {
        return n == -1 ? null : new JCDiagnostic.SimpleDiagnosticPosition(n);
    }

    public void report(JCDiagnostic jCDiagnostic) {
        switch (jCDiagnostic.getType()) {
            case FRAGMENT: {
                throw new IllegalArgumentException();
            }
            case NOTE: {
                if (!this.emitWarnings && !jCDiagnostic.isMandatory()) break;
                this.writeDiagnostic(jCDiagnostic);
                break;
            }
            case WARNING: {
                if (!this.emitWarnings && !jCDiagnostic.isMandatory() || this.nwarnings >= this.MaxWarnings) break;
                this.writeDiagnostic(jCDiagnostic);
                ++this.nwarnings;
                break;
            }
            case ERROR: {
                if (this.nerrors >= this.MaxErrors || !this.shouldReport(jCDiagnostic.getSource(), jCDiagnostic.getIntPosition())) break;
                this.writeDiagnostic(jCDiagnostic);
                ++this.nerrors;
            }
        }
    }

    protected void writeDiagnostic(JCDiagnostic jCDiagnostic) {
        int n;
        if (this.diagListener != null) {
            try {
                this.diagListener.report(jCDiagnostic);
                return;
            }
            catch (Throwable throwable) {
                throw new ClientCodeException(throwable);
            }
        }
        PrintWriter printWriter = this.getWriterForDiagnosticType(jCDiagnostic.getType());
        Log.printLines(printWriter, this.diagFormatter.format(jCDiagnostic));
        if (this.showSourceLine && (n = jCDiagnostic.getIntPosition()) != -1) {
            JavaFileObject javaFileObject = this.useSource(jCDiagnostic.getSource());
            this.printErrLine(n, printWriter);
            this.useSource(javaFileObject);
        }
        if (this.promptOnError) {
            switch (jCDiagnostic.getType()) {
                case WARNING: 
                case ERROR: {
                    this.prompt();
                }
            }
        }
        if (this.dumpOnError) {
            new RuntimeException().printStackTrace(printWriter);
        }
        printWriter.flush();
    }

    @Deprecated
    protected PrintWriter getWriterForDiagnosticType(JCDiagnostic.DiagnosticType diagnosticType) {
        switch (diagnosticType) {
            case FRAGMENT: {
                throw new IllegalArgumentException();
            }
            case NOTE: {
                return this.noticeWriter;
            }
            case WARNING: {
                return this.warnWriter;
            }
            case ERROR: {
                return this.errWriter;
            }
        }
        throw new Error();
    }

    public static String getLocalizedString(String string, Object ... objectArray) {
        return Messages.getDefaultLocalizedString("compiler.misc." + string, objectArray);
    }

    private void printRawError(int n, String string) {
        if (!this.findLine(n)) {
            Log.printLines(this.errWriter, "error: " + string);
        } else {
            JavaFileObject javaFileObject = this.currentSource();
            if (javaFileObject != null) {
                Log.printLines(this.errWriter, javaFileObject.getName() + ":" + this.line + ": " + string);
            }
            this.printErrLine(n, this.errWriter);
        }
        this.errWriter.flush();
    }

    public void rawError(int n, String string) {
        if (this.nerrors < this.MaxErrors && this.shouldReport(this.currentSource(), n)) {
            this.printRawError(n, string);
            this.prompt();
            ++this.nerrors;
        }
        this.errWriter.flush();
    }

    public void rawWarning(int n, String string) {
        if (this.nwarnings < this.MaxWarnings && this.emitWarnings) {
            this.printRawError(n, "warning: " + string);
        }
        this.prompt();
        ++this.nwarnings;
        this.errWriter.flush();
    }

    protected int getLineNumber(int n) {
        if (this.findLine(n)) {
            return this.line;
        }
        return 0;
    }

    protected int getColumnNumber(int n) {
        if (this.findLine(n)) {
            int n2 = 0;
            this.bp = this.lineStart;
            while (this.bp < n) {
                if (this.bp >= this.buf.length) {
                    return 0;
                }
                n2 = this.buf[this.bp] == '\t' ? n2 / 8 * 8 + 8 : ++n2;
                ++this.bp;
            }
            return n2 + 1;
        }
        return 0;
    }

    public static String format(String string, Object ... objectArray) {
        return String.format((Locale)null, string, objectArray);
    }
}

