/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import java.io.File;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RelativePath
implements Comparable<RelativePath> {
    protected final String path;

    protected RelativePath(String string) {
        this.path = string;
    }

    public abstract RelativeDirectory dirname();

    public abstract String basename();

    public File getFile(File file) {
        if (this.path.length() == 0) {
            return file;
        }
        return new File(file, this.path.replace('/', File.separatorChar));
    }

    @Override
    public int compareTo(RelativePath relativePath) {
        return this.path.compareTo(relativePath.path);
    }

    public boolean equals(Object object) {
        if (!(object instanceof RelativePath)) {
            return false;
        }
        return this.path.equals(((RelativePath)object).path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    public String toString() {
        return "RelPath[" + this.path + "]";
    }

    public String getPath() {
        return this.path;
    }

    public static class RelativeFile
    extends RelativePath {
        static RelativeFile forClass(CharSequence charSequence, JavaFileObject.Kind kind) {
            return new RelativeFile(((Object)charSequence).toString().replace('.', '/') + kind.extension);
        }

        public RelativeFile(String string) {
            super(string);
            if (string.endsWith("/")) {
                throw new IllegalArgumentException(string);
            }
        }

        public RelativeFile(RelativeDirectory relativeDirectory, String string) {
            this(relativeDirectory.path + string);
        }

        RelativeFile(RelativeDirectory relativeDirectory, RelativePath relativePath) {
            this(relativeDirectory, relativePath.path);
        }

        public RelativeDirectory dirname() {
            int n = this.path.lastIndexOf(47);
            return new RelativeDirectory(this.path.substring(0, n + 1));
        }

        public String basename() {
            int n = this.path.lastIndexOf(47);
            return this.path.substring(n + 1);
        }

        ZipEntry getZipEntry(ZipFile zipFile) {
            return zipFile.getEntry(this.path);
        }

        public String toString() {
            return "RelativeFile[" + this.path + "]";
        }
    }

    public static class RelativeDirectory
    extends RelativePath {
        static RelativeDirectory forPackage(CharSequence charSequence) {
            return new RelativeDirectory(((Object)charSequence).toString().replace('.', '/'));
        }

        public RelativeDirectory(String string) {
            super(string.length() == 0 || string.endsWith("/") ? string : string + "/");
        }

        public RelativeDirectory(RelativeDirectory relativeDirectory, String string) {
            this(relativeDirectory.path + string);
        }

        public RelativeDirectory dirname() {
            int n = this.path.length();
            if (n == 0) {
                return this;
            }
            int n2 = this.path.lastIndexOf(47, n - 2);
            return new RelativeDirectory(this.path.substring(0, n2 + 1));
        }

        public String basename() {
            int n = this.path.length();
            if (n == 0) {
                return this.path;
            }
            int n2 = this.path.lastIndexOf(47, n - 2);
            return this.path.substring(n2 + 1, n - 1);
        }

        boolean contains(RelativePath relativePath) {
            return relativePath.path.length() > this.path.length() && relativePath.path.startsWith(this.path);
        }

        public String toString() {
            return "RelativeDirectory[" + this.path + "]";
        }
    }
}

