/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.file.BaseFileObject;
import com.sun.tools.javac.file.JavacFileManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RegularFileObject
extends BaseFileObject {
    private boolean hasParents = false;
    private String name;
    final File file;
    private Reference<File> absFileRef;

    public RegularFileObject(JavacFileManager javacFileManager, File file) {
        this(javacFileManager, file.getName(), file);
    }

    public RegularFileObject(JavacFileManager javacFileManager, String string, File file) {
        super(javacFileManager);
        if (file.isDirectory()) {
            throw new IllegalArgumentException("directories not supported");
        }
        this.name = string;
        this.file = file;
    }

    @Override
    public URI toUri() {
        return this.file.toURI().normalize();
    }

    @Override
    public String getName() {
        return this.file.getPath();
    }

    @Override
    public String getShortName() {
        return this.name;
    }

    @Override
    public JavaFileObject.Kind getKind() {
        return RegularFileObject.getKind(this.name);
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        this.ensureParentDirectoriesExist();
        return new FileOutputStream(this.file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CharBuffer getCharContent(boolean bl) throws IOException {
        CharBuffer charBuffer = this.fileManager.getCachedContent(this);
        if (charBuffer == null) {
            FileInputStream fileInputStream = new FileInputStream(this.file);
            try {
                ByteBuffer byteBuffer = this.fileManager.makeByteBuffer(fileInputStream);
                JavaFileObject javaFileObject = this.fileManager.log.useSource(this);
                try {
                    charBuffer = this.fileManager.decode(byteBuffer, bl);
                    Object var7_6 = null;
                    this.fileManager.log.useSource(javaFileObject);
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    this.fileManager.log.useSource(javaFileObject);
                    throw throwable;
                }
                this.fileManager.recycleByteBuffer(byteBuffer);
                if (!bl) {
                    this.fileManager.cache(this, charBuffer);
                }
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            ((InputStream)fileInputStream).close();
            {
            }
        }
        return charBuffer;
    }

    @Override
    public Writer openWriter() throws IOException {
        this.ensureParentDirectoriesExist();
        return new OutputStreamWriter((OutputStream)new FileOutputStream(this.file), this.fileManager.getEncodingName());
    }

    @Override
    public long getLastModified() {
        return this.file.lastModified();
    }

    @Override
    public boolean delete() {
        return this.file.delete();
    }

    @Override
    protected CharsetDecoder getDecoder(boolean bl) {
        return this.fileManager.getDecoder(this.fileManager.getEncodingName(), bl);
    }

    @Override
    protected String inferBinaryName(Iterable<? extends File> iterable) {
        String string = this.file.getPath();
        for (File file : iterable) {
            String string2 = file.getPath();
            if (string2.length() == 0) {
                string2 = System.getProperty("user.dir");
            }
            if (!string2.endsWith(File.separator)) {
                string2 = string2 + File.separator;
            }
            if (!string.regionMatches(true, 0, string2, 0, string2.length()) || !new File(string.substring(0, string2.length())).equals(new File(string2))) continue;
            String string3 = string.substring(string2.length());
            return RegularFileObject.removeExtension(string3).replace(File.separatorChar, '.');
        }
        return null;
    }

    @Override
    public boolean isNameCompatible(String string, JavaFileObject.Kind kind) {
        string.getClass();
        if (kind == JavaFileObject.Kind.OTHER && this.getKind() != kind) {
            return false;
        }
        String string2 = string + kind.extension;
        if (this.name.equals(string2)) {
            return true;
        }
        if (this.name.equalsIgnoreCase(string2)) {
            try {
                return this.file.getCanonicalFile().getName().equals(string2);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    private void ensureParentDirectoriesExist() throws IOException {
        if (!this.hasParents) {
            File file = this.file.getParentFile();
            if (!(file == null || file.exists() || file.mkdirs() || file.exists() && file.isDirectory())) {
                throw new IOException("could not create parent directories");
            }
            this.hasParents = true;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof RegularFileObject)) {
            return false;
        }
        RegularFileObject regularFileObject = (RegularFileObject)object;
        return this.getAbsoluteFile().equals(regularFileObject.getAbsoluteFile());
    }

    @Override
    public int hashCode() {
        return this.getAbsoluteFile().hashCode();
    }

    private File getAbsoluteFile() {
        File file;
        File file2 = file = this.absFileRef == null ? null : this.absFileRef.get();
        if (file == null) {
            file = this.file.getAbsoluteFile();
            this.absFileRef = new SoftReference<File>(file);
        }
        return file;
    }
}

