/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.file;

import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.file.FSInfo;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.main.OptionName;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipFile;
import javax.tools.JavaFileManager;
import javax.tools.StandardLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Paths {
    protected static final Context.Key<Paths> pathsKey = new Context.Key();
    private Log log;
    private Options options;
    private Lint lint;
    private FSInfo fsInfo;
    private boolean warn;
    private Map<JavaFileManager.Location, Path> pathsForLocation;
    private boolean inited = false;
    private File bootClassPathRtJar = null;
    private Path sourceSearchPath;
    private Path classSearchPath;
    private Path otherSearchPath;

    public static Paths instance(Context context) {
        Paths paths = context.get(pathsKey);
        if (paths == null) {
            paths = new Paths(context);
        }
        return paths;
    }

    protected Paths(Context context) {
        context.put(pathsKey, this);
        this.pathsForLocation = new HashMap<JavaFileManager.Location, Path>(16);
        this.setContext(context);
    }

    void setContext(Context context) {
        this.log = Log.instance(context);
        this.options = Options.instance(context);
        this.lint = Lint.instance(context);
        this.fsInfo = FSInfo.instance(context);
    }

    Path getPathForLocation(JavaFileManager.Location location) {
        Path path = this.pathsForLocation.get(location);
        if (path == null) {
            this.setPathForLocation(location, null);
        }
        return this.pathsForLocation.get(location);
    }

    void setPathForLocation(JavaFileManager.Location location, Iterable<? extends File> iterable) {
        Path path;
        if (iterable == null) {
            path = location == StandardLocation.CLASS_PATH ? this.computeUserClassPath() : (location == StandardLocation.PLATFORM_CLASS_PATH ? this.computeBootClassPath() : (location == StandardLocation.ANNOTATION_PROCESSOR_PATH ? this.computeAnnotationProcessorPath() : (location == StandardLocation.SOURCE_PATH ? this.computeSourcePath() : null)));
        } else {
            path = new Path();
            for (File file : iterable) {
                path.addFile(file, this.warn);
            }
        }
        this.pathsForLocation.put(location, path);
    }

    protected void lazy() {
        if (!this.inited) {
            this.warn = this.lint.isEnabled(Lint.LintCategory.PATH);
            this.pathsForLocation.put(StandardLocation.PLATFORM_CLASS_PATH, this.computeBootClassPath());
            this.pathsForLocation.put(StandardLocation.CLASS_PATH, this.computeUserClassPath());
            this.pathsForLocation.put(StandardLocation.SOURCE_PATH, this.computeSourcePath());
            this.inited = true;
        }
    }

    public Collection<File> bootClassPath() {
        this.lazy();
        return Collections.unmodifiableCollection(this.getPathForLocation(StandardLocation.PLATFORM_CLASS_PATH));
    }

    public Collection<File> userClassPath() {
        this.lazy();
        return Collections.unmodifiableCollection(this.getPathForLocation(StandardLocation.CLASS_PATH));
    }

    public Collection<File> sourcePath() {
        this.lazy();
        Path path = this.getPathForLocation(StandardLocation.SOURCE_PATH);
        return path == null || path.size() == 0 ? null : Collections.unmodifiableCollection(path);
    }

    boolean isBootClassPathRtJar(File file) {
        return file.equals(this.bootClassPathRtJar);
    }

    private static Iterable<File> getPathEntries(String string) {
        return Paths.getPathEntries(string, null);
    }

    private static Iterable<File> getPathEntries(String string, File file) {
        ListBuffer<File> listBuffer = new ListBuffer<File>();
        int n = 0;
        while (n <= string.length()) {
            int n2 = string.indexOf(File.pathSeparatorChar, n);
            if (n2 == -1) {
                n2 = string.length();
            }
            if (n < n2) {
                listBuffer.add(new File(string.substring(n, n2)));
            } else if (file != null) {
                listBuffer.add(file);
            }
            n = n2 + 1;
        }
        return listBuffer;
    }

    private Path computeBootClassPath() {
        this.bootClassPathRtJar = null;
        Path path = new Path();
        path.addFiles(this.options.get(OptionName.XBOOTCLASSPATH_PREPEND));
        String string = this.options.get(OptionName.ENDORSEDDIRS);
        if (string != null) {
            path.addDirectories(string);
        } else {
            path.addDirectories(System.getProperty("java.endorsed.dirs"), false);
        }
        string = this.options.get(OptionName.BOOTCLASSPATH);
        if (string != null) {
            path.addFiles(string);
        } else {
            String string2 = System.getProperty("sun.boot.class.path");
            path.addFiles(string2, false);
            File file = new File("rt.jar");
            for (File file2 : Paths.getPathEntries(string2)) {
                if (!new File(file2.getName()).equals(file)) continue;
                this.bootClassPathRtJar = file2;
            }
        }
        path.addFiles(this.options.get(OptionName.XBOOTCLASSPATH_APPEND));
        string = this.options.get(OptionName.EXTDIRS);
        if (string != null) {
            path.addDirectories(string);
        } else {
            path.addDirectories(System.getProperty("java.ext.dirs"), false);
        }
        return path;
    }

    private Path computeUserClassPath() {
        String string = this.options.get(OptionName.CLASSPATH);
        if (string == null) {
            string = System.getProperty("env.class.path");
        }
        if (string == null && System.getProperty("application.home") == null) {
            string = System.getProperty("java.class.path");
        }
        if (string == null) {
            string = ".";
        }
        return new Path().expandJarClassPaths(true).emptyPathDefault(new File(".")).addFiles(string);
    }

    private Path computeSourcePath() {
        String string = this.options.get(OptionName.SOURCEPATH);
        if (string == null) {
            return null;
        }
        return new Path().addFiles(string);
    }

    private Path computeAnnotationProcessorPath() {
        String string = this.options.get(OptionName.PROCESSORPATH);
        if (string == null) {
            return null;
        }
        return new Path().addFiles(string);
    }

    public Collection<File> sourceSearchPath() {
        if (this.sourceSearchPath == null) {
            this.lazy();
            Path path = this.getPathForLocation(StandardLocation.SOURCE_PATH);
            Path path2 = this.getPathForLocation(StandardLocation.CLASS_PATH);
            this.sourceSearchPath = path != null ? path : path2;
        }
        return Collections.unmodifiableCollection(this.sourceSearchPath);
    }

    public Collection<File> classSearchPath() {
        if (this.classSearchPath == null) {
            this.lazy();
            Path path = this.getPathForLocation(StandardLocation.PLATFORM_CLASS_PATH);
            Path path2 = this.getPathForLocation(StandardLocation.CLASS_PATH);
            this.classSearchPath = new Path();
            this.classSearchPath.addAll(path);
            this.classSearchPath.addAll(path2);
        }
        return Collections.unmodifiableCollection(this.classSearchPath);
    }

    Collection<File> otherSearchPath() {
        if (this.otherSearchPath == null) {
            this.lazy();
            Path path = this.getPathForLocation(StandardLocation.CLASS_PATH);
            Path path2 = this.getPathForLocation(StandardLocation.SOURCE_PATH);
            if (path2 == null) {
                this.otherSearchPath = path;
            } else {
                this.otherSearchPath = new Path();
                this.otherSearchPath.addAll(path);
                this.otherSearchPath.addAll(path2);
            }
        }
        return Collections.unmodifiableCollection(this.otherSearchPath);
    }

    private boolean isArchive(File file) {
        String string = file.getName().toLowerCase();
        return this.fsInfo.isFile(file) && (string.endsWith(".jar") || string.endsWith(".zip"));
    }

    public static URL[] pathToURLs(String string) {
        URL[] uRLArray;
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        URL[] uRLArray2 = new URL[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            uRLArray = Paths.fileToURL(new File(stringTokenizer.nextToken()));
            if (uRLArray == null) continue;
            uRLArray2[n++] = uRLArray;
        }
        if (uRLArray2.length != n) {
            uRLArray = new URL[n];
            System.arraycopy(uRLArray2, 0, uRLArray, 0, n);
            uRLArray2 = uRLArray;
        }
        return uRLArray2;
    }

    private static URL fileToURL(File file) {
        String string;
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = file.getAbsolutePath();
        }
        string = string.replace(File.separatorChar, '/');
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (!file.isFile()) {
            string = string + "/";
        }
        try {
            return new URL("file", "", string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException(file.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Path
    extends LinkedHashSet<File> {
        private static final long serialVersionUID = 0L;
        private boolean expandJarClassPaths = false;
        private Set<File> canonicalValues = new HashSet<File>();
        private File emptyPathDefault = null;

        public Path expandJarClassPaths(boolean bl) {
            this.expandJarClassPaths = bl;
            return this;
        }

        public Path emptyPathDefault(File file) {
            this.emptyPathDefault = file;
            return this;
        }

        public Path addDirectories(String string, boolean bl) {
            if (string != null) {
                for (File file : Paths.getPathEntries(string)) {
                    this.addDirectory(file, bl);
                }
            }
            return this;
        }

        public Path addDirectories(String string) {
            return this.addDirectories(string, Paths.this.warn);
        }

        private void addDirectory(File file, boolean bl) {
            if (!file.isDirectory()) {
                if (bl) {
                    Paths.this.log.warning("dir.path.element.not.found", file);
                }
                return;
            }
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return;
            }
            for (File file2 : fileArray) {
                if (!Paths.this.isArchive(file2)) continue;
                this.addFile(file2, bl);
            }
        }

        public Path addFiles(String string, boolean bl) {
            if (string != null) {
                for (File file : Paths.getPathEntries(string, this.emptyPathDefault)) {
                    this.addFile(file, bl);
                }
            }
            return this;
        }

        public Path addFiles(String string) {
            return this.addFiles(string, Paths.this.warn);
        }

        public void addFile(File file, boolean bl) {
            File file2 = Paths.this.fsInfo.getCanonicalFile(file);
            if (this.contains(file) || this.canonicalValues.contains(file2)) {
                return;
            }
            if (!Paths.this.fsInfo.exists(file)) {
                if (bl) {
                    Paths.this.log.warning("path.element.not.found", file);
                }
            } else if (Paths.this.fsInfo.isFile(file) && !Paths.this.isArchive(file)) {
                try {
                    ZipFile zipFile = new ZipFile(file);
                    zipFile.close();
                    if (bl) {
                        Paths.this.log.warning("unexpected.archive.file", file);
                    }
                }
                catch (IOException iOException) {
                    if (bl) {
                        Paths.this.log.warning("invalid.archive.file", file);
                    }
                    return;
                }
            }
            super.add(file);
            this.canonicalValues.add(file2);
            if (this.expandJarClassPaths && Paths.this.fsInfo.exists(file) && Paths.this.fsInfo.isFile(file)) {
                this.addJarClassPath(file, bl);
            }
        }

        private void addJarClassPath(File file, boolean bl) {
            try {
                for (File file2 : Paths.this.fsInfo.getJarClassPath(file)) {
                    this.addFile(file2, bl);
                }
            }
            catch (IOException iOException) {
                Paths.this.log.error("error.reading.file", file, JavacFileManager.getMessage(iOException));
            }
        }
    }
}

