#ifndef __HRN_TILER_H__
#define __HRN_TILER_H__

#include <glib-object.h>

#include "hrn-cluster-node.h"
#include "hrn-tileable.h"

G_BEGIN_DECLS

#define HRN_TYPE_TILER (hrn_tiler_get_type ())
#define HRN_TILER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), HRN_TYPE_TILER, HrnTiler))
#define HRN_IS_TILER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), HRN_TYPE_TILER))
#define HRN_TILER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), HRN_TYPE_TILER, HrnTilerInterface))

typedef struct _HrnTiler HrnTiler;
typedef struct _HrnTilerInterface HrnTilerInterface;

struct _HrnTilerInterface {
    GTypeInterface base_iface;

    void (* show_all) (HrnTiler *tiler);
    void (* show) (HrnTiler    *tiler,
                   HrnTileable *tile);
    void (*set_expanded) (HrnTiler *tiler,
                          gboolean  expanded);
    void (*set_items_per_row) (HrnTiler *tiler,
                               guint     items_per_row);
    void (*add_items) (HrnTiler       *tiler,
                       HrnClusterNode *root);
};

GType hrn_tiler_get_type (void);

void hrn_tiler_show_all (HrnTiler *tiler);
void hrn_tiler_show (HrnTiler    *tiler,
                     HrnTileable *tile);
void hrn_tiler_set_expanded (HrnTiler *tiler,
                             gboolean  expanded);
void hrn_tiler_set_items_per_row (HrnTiler *tiler,
                                  guint     items_per_row);
void hrn_tiler_add_items (HrnTiler       *tiler,
                          HrnClusterNode *node);

G_END_DECLS

#endif
