{- This module was generated from data in the Kate syntax
   highlighting file boo.xml, version 0.91, by Marc Dassonneville -}

module Text.Highlighting.Kate.Syntax.Boo
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import Text.ParserCombinators.Parsec hiding (State)
import Data.Map (fromList)
import Control.Monad.State
import Data.Char (isSpace)
import Data.Maybe (fromMaybe)
import qualified Data.Set as Set

-- | Full name of language.
syntaxName :: String
syntaxName = "Boo"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.boo"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine parseExpressionInternal pEndLine

-- | Parse an expression using appropriate local context.
parseExpression :: KateParser Token
parseExpression = do
  st <- getState
  let oldLang = synStLanguage st
  setState $ st { synStLanguage = "Boo" }
  context <- currentContext <|> (pushContext "Normal" >> currentContext)
  result <- parseRules context
  optional $ eof >> pEndLine
  updateState $ \st -> st { synStLanguage = oldLang }
  return result

startingState = SyntaxState {synStContexts = fromList [("Boo",["Normal"])], synStLanguage = "Boo", synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  case context of
    "Normal" -> return ()
    "parenthesised" -> return ()
    "Quasi-Quotation" -> return ()
    "Tripple A-comment" -> return ()
    "Tripple Q-comment" -> return ()
    "Tripple A-string" -> return ()
    "Raw Tripple A-string" -> return ()
    "Tripple Q-string" -> return ()
    "Raw Tripple Q-string" -> return ()
    "Comment SlashSlash" -> (popContext) >> pEndLine
    "Single A-comment" -> return ()
    "Single Q-comment" -> return ()
    "Single A-string" -> return ()
    "Single Q-string" -> return ()
    "Raw A-string" -> return ()
    "Raw Q-string" -> return ()
    _ -> return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)

parseExpressionInternal = do
  context <- currentContext
  parseRules context <|> (pDefault >>= withAttribute (fromMaybe NormalTok $ lookup context defaultAttributes))

list_namespace = Set.fromList $ words $ "import from as namespace"
list_operators = Set.fromList $ words $ "and assert in is not or"
list_primitive = Set.fromList $ words $ "bool byte sbyte double decimal single short ushort int char uint long ulong object duck string regex date timespan"
list_definition = Set.fromList $ words $ "abstract virtual override static final transient macro protected private public internal partial class struct interface enum callable of def constructor destructor do get set event return yield"
list_boolean = Set.fromList $ words $ "true false"
list_literals = Set.fromList $ words $ "null self super"
list_keywords = Set.fromList $ words $ "and break cast continue elif else except ensure for given goto if in is isa not or otherwise pass raise try unless when while ref"
list_builtins = Set.fromList $ words $ "assert __eval__ __switch__ enumerate filter len typeof map max min property using getter required lock range zip checked unchecked rawArrayIndexing normalArrayIndexing print array matrix yieldAll"

regex_'5ba'2dzA'2dZ'5f'5d'5ba'2dzA'2dZ'5f0'2d9'5d'2b = compileRegex "[a-zA-Z_][a-zA-Z_0-9]+"
regex__'28'28'28'5b0'2d9'5d'2a'5c'2e'5b0'2d9'5d'2b'7c'5b0'2d9'5d'2b'5c'2e'29'7c'28'5b0'2d9'5d'2b'7c'28'5b0'2d9'5d'2a'5c'2e'5b0'2d9'5d'2b'7c'5b0'2d9'5d'2b'5c'2e'29'29'5beE'5d'28'5c'2b'7c'2d'29'3f'5b0'2d9'5d'2b'29'7c'5b0'2d9'5d'2b'29'5bjJ'5d = compileRegex " ((([0-9]*\\.[0-9]+|[0-9]+\\.)|([0-9]+|([0-9]*\\.[0-9]+|[0-9]+\\.))[eE](\\+|-)?[0-9]+)|[0-9]+)[jJ]"
regex_'28'5b0'2d9'5d'2b'5c'2e'5b0'2d9'5d'2a'7c'5c'2e'5b0'2d9'5d'2b'29'28'5beE'5d'5b0'2d9'5d'2b'29'3f = compileRegex "([0-9]+\\.[0-9]*|\\.[0-9]+)([eE][0-9]+)?"
regex_'28'5b1'2d9'5d'5b0'2d9'5d'2a'28'5beE'5d'5b0'2d9'5d'2b'29'3f'7c0'29 = compileRegex "([1-9][0-9]*([eE][0-9]+)?|0)"
regex_'5b1'2d9'5d'5b0'2d9'5d'2a'28'5beE'5d'5b0'2d9'2e'5d'2b'29'3f'5bLl'5d = compileRegex "[1-9][0-9]*([eE][0-9.]+)?[Ll]"
regex_0'5bXx'5d'5b0'2d9a'2dfA'2dF'5d'2b = compileRegex "0[Xx][0-9a-fA-F]+"
regex_0'5b1'2d9'5d'5b0'2d9'5d'2a = compileRegex "0[1-9][0-9]*"
regex_'5brR'5d'27'27'27 = compileRegex "[rR]'''"
regex_'5brR'5d'22'22'22 = compileRegex "[rR]\"\"\""
regex_'5brR'5d'27 = compileRegex "[rR]'"
regex_'5brR'5d'22 = compileRegex "[rR]\""
regex_'23'2e'2a'24 = compileRegex "#.*$"
regex_'5cs'2au'3f'27'27'27 = compileRegex "\\s*u?'''"
regex_'5cs'2au'3f'22'22'22 = compileRegex "\\s*u?\"\"\""
regex_'5b'2b'2a'2f'25'5c'7c'3d'3b'5c'21'3c'3e'21'5e'26'7e'2d'5d = compileRegex "[+*/%\\|=;\\!<>!^&~-]"
regex_'25'5ba'2dzA'2dZ'5d = compileRegex "%[a-zA-Z]"
regex_'22'22'22 = compileRegex "\"\"\""
regex_'25'5c'28'5ba'2dzA'2dZ0'2d9'5f'5d'2b'5c'29'5ba'2dzA'2dZ'5d = compileRegex "%\\([a-zA-Z0-9_]+\\)[a-zA-Z]"
regex_'27'27'27 = compileRegex "'''"

defaultAttributes = [("Normal",NormalTok),("parenthesised",NormalTok),("Quasi-Quotation",NormalTok),("Tripple A-comment",CommentTok),("Tripple Q-comment",CommentTok),("Tripple A-string",StringTok),("Raw Tripple A-string",StringTok),("Tripple Q-string",StringTok),("Raw Tripple Q-string",StringTok),("Comment SlashSlash",CommentTok),("Single A-comment",CommentTok),("Single Q-comment",CommentTok),("Single A-string",StringTok),("Single Q-string",StringTok),("Raw A-string",StringTok),("Raw Q-string",StringTok)]

parseRules "Normal" =
  (((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_namespace >>= withAttribute CharTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_definition >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_operators >>= withAttribute NormalTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_keywords >>= withAttribute KeywordTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_builtins >>= withAttribute DataTypeTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_literals >>= withAttribute OtherTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_boolean >>= withAttribute OtherTok))
   <|>
   ((pKeyword " \n\t.():!+,-<=>%&*/;?[]^{|}~\\" list_primitive >>= withAttribute DataTypeTok))
   <|>
   ((pRegExpr regex_'5ba'2dzA'2dZ'5f'5d'5ba'2dzA'2dZ'5f0'2d9'5d'2b >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex__'28'28'28'5b0'2d9'5d'2a'5c'2e'5b0'2d9'5d'2b'7c'5b0'2d9'5d'2b'5c'2e'29'7c'28'5b0'2d9'5d'2b'7c'28'5b0'2d9'5d'2a'5c'2e'5b0'2d9'5d'2b'7c'5b0'2d9'5d'2b'5c'2e'29'29'5beE'5d'28'5c'2b'7c'2d'29'3f'5b0'2d9'5d'2b'29'7c'5b0'2d9'5d'2b'29'5bjJ'5d >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'28'5b0'2d9'5d'2b'5c'2e'5b0'2d9'5d'2a'7c'5c'2e'5b0'2d9'5d'2b'29'28'5beE'5d'5b0'2d9'5d'2b'29'3f >>= withAttribute FloatTok))
   <|>
   ((pRegExpr regex_'28'5b1'2d9'5d'5b0'2d9'5d'2a'28'5beE'5d'5b0'2d9'5d'2b'29'3f'7c0'29 >>= withAttribute DecValTok))
   <|>
   ((pRegExpr regex_'5b1'2d9'5d'5b0'2d9'5d'2a'28'5beE'5d'5b0'2d9'2e'5d'2b'29'3f'5bLl'5d >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_0'5bXx'5d'5b0'2d9a'2dfA'2dF'5d'2b >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_0'5b1'2d9'5d'5b0'2d9'5d'2a >>= withAttribute OtherTok))
   <|>
   ((pRegExpr regex_'5brR'5d'27'27'27 >>= withAttribute StringTok) >>~ pushContext "Raw Tripple A-string")
   <|>
   ((pRegExpr regex_'5brR'5d'22'22'22 >>= withAttribute StringTok) >>~ pushContext "Raw Tripple Q-string")
   <|>
   ((pRegExpr regex_'5brR'5d'27 >>= withAttribute StringTok) >>~ pushContext "Raw A-string")
   <|>
   ((pRegExpr regex_'5brR'5d'22 >>= withAttribute StringTok) >>~ pushContext "Raw Q-string")
   <|>
   ((pRegExpr regex_'23'2e'2a'24 >>= withAttribute CommentTok))
   <|>
   ((pColumn 0 >> pRegExpr regex_'5cs'2au'3f'27'27'27 >>= withAttribute CommentTok) >>~ pushContext "Tripple A-comment")
   <|>
   ((pColumn 0 >> pRegExpr regex_'5cs'2au'3f'22'22'22 >>= withAttribute CommentTok) >>~ pushContext "Tripple Q-comment")
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext "Comment SlashSlash")
   <|>
   ((pString False "'''" >>= withAttribute StringTok) >>~ pushContext "Tripple A-string")
   <|>
   ((pString False "\"\"\"" >>= withAttribute StringTok) >>~ pushContext "Tripple Q-string")
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ pushContext "Single A-string")
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext "Single Q-string")
   <|>
   ((pDetectChar False '(' >>= withAttribute NormalTok) >>~ pushContext "parenthesised")
   <|>
   ((pDetectChar False ')' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pString False "[|" >>= withAttribute NormalTok) >>~ pushContext "Quasi-Quotation")
   <|>
   ((pString False "|]" >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pRegExpr regex_'5b'2b'2a'2f'25'5c'7c'3d'3b'5c'21'3c'3e'21'5e'26'7e'2d'5d >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'25'5ba'2dzA'2dZ'5d >>= withAttribute NormalTok)))

parseRules "parenthesised" =
  ((parseRules "Normal"))

parseRules "Quasi-Quotation" =
  ((parseRules "Normal"))

parseRules "Tripple A-comment" =
  ((pString False "'''" >>= withAttribute CommentTok) >>~ (popContext))

parseRules "Tripple Q-comment" =
  (((pHlCChar >>= withAttribute CommentTok))
   <|>
   ((pRegExpr regex_'22'22'22 >>= withAttribute CommentTok) >>~ (popContext)))

parseRules "Tripple A-string" =
  (((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((pRegExpr regex_'25'5c'28'5ba'2dzA'2dZ0'2d9'5f'5d'2b'5c'29'5ba'2dzA'2dZ'5d >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'25'5ba'2dzA'2dZ'5d >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'27'27'27 >>= withAttribute StringTok) >>~ (popContext)))

parseRules "Raw Tripple A-string" =
  (((pHlCStringChar >>= withAttribute StringTok))
   <|>
   ((pRegExpr regex_'25'5c'28'5ba'2dzA'2dZ0'2d9'5f'5d'2b'5c'29'5ba'2dzA'2dZ'5d >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'25'5ba'2dzA'2dZ'5d >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'27'27'27 >>= withAttribute StringTok) >>~ (popContext)))

parseRules "Tripple Q-string" =
  (((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((pRegExpr regex_'25'5c'28'5ba'2dzA'2dZ0'2d9'5f'5d'2b'5c'29'5ba'2dzA'2dZ'5d >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'25'5ba'2dzA'2dZ'5d >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'22'22'22 >>= withAttribute StringTok) >>~ (popContext)))

parseRules "Raw Tripple Q-string" =
  (((pHlCStringChar >>= withAttribute StringTok))
   <|>
   ((pRegExpr regex_'25'5c'28'5ba'2dzA'2dZ0'2d9'5f'5d'2b'5c'29'5ba'2dzA'2dZ'5d >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'25'5ba'2dzA'2dZ'5d >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'22'22'22 >>= withAttribute StringTok) >>~ (popContext)))

parseRules "Comment SlashSlash" =
  ((pLineContinue >>= withAttribute CommentTok))

parseRules "Single A-comment" =
  (((pHlCStringChar >>= withAttribute CommentTok))
   <|>
   ((pDetectChar False '\'' >>= withAttribute CommentTok) >>~ (popContext)))

parseRules "Single Q-comment" =
  (((pHlCStringChar >>= withAttribute CommentTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute CommentTok) >>~ (popContext)))

parseRules "Single A-string" =
  (((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((pRegExpr regex_'25'5c'28'5ba'2dzA'2dZ0'2d9'5f'5d'2b'5c'29'5ba'2dzA'2dZ'5d >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'25'5ba'2dzA'2dZ'5d >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext)))

parseRules "Single Q-string" =
  (((pHlCStringChar >>= withAttribute CharTok))
   <|>
   ((pRegExpr regex_'25'5c'28'5ba'2dzA'2dZ0'2d9'5f'5d'2b'5c'29'5ba'2dzA'2dZ'5d >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'25'5ba'2dzA'2dZ'5d >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext)))

parseRules "Raw A-string" =
  (((pHlCStringChar >>= withAttribute StringTok))
   <|>
   ((pRegExpr regex_'25'5c'28'5ba'2dzA'2dZ0'2d9'5f'5d'2b'5c'29'5ba'2dzA'2dZ'5d >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'25'5ba'2dzA'2dZ'5d >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '\'' >>= withAttribute StringTok) >>~ (popContext)))

parseRules "Raw Q-string" =
  (((pHlCStringChar >>= withAttribute StringTok))
   <|>
   ((pRegExpr regex_'25'5c'28'5ba'2dzA'2dZ0'2d9'5f'5d'2b'5c'29'5ba'2dzA'2dZ'5d >>= withAttribute NormalTok))
   <|>
   ((pRegExpr regex_'25'5ba'2dzA'2dZ'5d >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext)))

parseRules "" = parseRules "Normal"

parseRules x = fail $ "Unknown context" ++ x
