/*
 * Copyright (C) 2011 Hermann Meyer, Andreas Degert
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 * ---------------------------------------------------------------------------
 *
 *        file: gxtuner.h   guitar tuner for jack
 *
 * ----------------------------------------------------------------------------
 */

#pragma once

#ifndef SRC_HEADERS_TUNER_H_
#define SRC_HEADERS_TUNER_H_

#include "./config.h"

#include <gtk/gtk.h>
#include <gtk/gtkprivate.h>
#include <jack/jack.h>

#include <string> 
#include <cmath>
#include <cstdlib>


G_BEGIN_DECLS

#define GX_TYPE_TUNER          (gx_tuner_get_type())
#define GX_TUNER(obj)          (G_TYPE_CHECK_INSTANCE_CAST ((obj), GX_TYPE_TUNER, GxTuner))
#define GX_IS_TUNER(obj)       (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GX_TYPE_TUNER))
#define GX_TUNER_CLASS(klass)  (G_TYPE_CHECK_CLASS_CAST ((klass),  GX_TYPE_TUNER, GxTunerClass))
#define GX_IS_TUNER_CLASS(obj) (G_TYPE_CHECK_CLASS_TYPE ((klass),  GX_TYPE_TUNER))

typedef struct _GxTuner GxTuner;
typedef struct _GxTunerClass GxTunerClass;

struct _GxTuner
{
    GtkDrawingArea parent;
    double GSEAL (freq);
    double GSEAL (reference_pitch);
};

struct _GxTunerClass
{
    GtkDrawingAreaClass parent_class;
    /*< private >*/
    cairo_surface_t *surface_tuner;
};

GType gx_tuner_get_type();

void gx_tuner_set_freq(GxTuner *tuner, double freq);
void gx_tuner_set_reference_pitch(GxTuner *tuner, double reference_pitch);
double gx_tuner_get_reference_pitch(GxTuner *tuner);
GtkWidget *gx_tuner_new(void);

G_END_DECLS

typedef std::string (*getcmdvar)
             (int x);
typedef float (*getptvar)
             ();
typedef jack_port_t* (*getport)
             ();
typedef jack_client_t* (*getclient)
             ();
typedef void (*setptvar)
             (float x);

class TunerWidget {
 private:
    GError*             err;
    GtkWidget*          box;
    GtkWidget*          hbox;
    GtkWidget*          abox;
    GtkWidget*          bbox;
    GtkObject*          adj;
    GtkWidget*          spinner;
    GtkObject*          adjt;
    GtkWidget*          window;
    GtkWidget*          tuner;
    GtkWidget*          spinnert;
    static gboolean     delete_event(GtkWidget *widget, GdkEvent *event,
                             gpointer data);
    static gboolean     ref_freq_changed(gpointer arg);
    static gboolean     threshold_changed(gpointer arg);
    static void         destroy( GtkWidget *widget, gpointer data);
 public:
    explicit TunerWidget();
    ~TunerWidget();
    int                 g_threads;
    void*               get_tuner() { return tuner;}
    void                session_quit();
    void                create_window();
    void                parse_cmd();
    void                show();
    void                window_area(int* x, int* y, int* w, int* l) {
        gtk_window_get_position(GTK_WINDOW(window), x, y);
        gtk_window_get_size(GTK_WINDOW(window), w, l);
    }
    static void         signal_handler(int sig);
    static gboolean     gx_update_frequency(gpointer arg);

};
extern TunerWidget tw;

class CmdPtr {
 public:
    getcmdvar           cv;
    getport             gp;
    getclient           gc;
    getptvar            ef;
    setptvar            sf;
};
extern CmdPtr *cptr;

#endif // SRC_HEADERS_TUNER_H_
