#!/usr/bin/env python
#
# setup.py for gnuConcept

from distutils.core import setup
from DistUtilsExtra.command import *
from glob import glob

setup(name="gwibber",
      version="3.0.0.1", # UPDATE gwibber/microblog/util/const.py too
      author="Ryan Paul",
      author_email="segphault@arstechnica.com",
      url="http://launchpad.net/gwibber/",
      license="GNU General Public License (GPL)",
      packages=['gwibber', 'gwibber.microblog', 'gwibber.microblog.util',
          'gwibber.microblog.urlshorter',
          'gwibber.lib', 'gwibber.lib.gtk'],

      data_files=[
    ('share/gwibber/plugins/twitter', glob("gwibber/microblog/plugins/twitter/*.*")),
    ('share/gwibber/plugins/twitter/gtk', glob("gwibber/microblog/plugins/twitter/gtk/*.*")),
    ('share/gwibber/plugins/twitter/gtk/twitter', glob("gwibber/microblog/plugins/twitter/gtk/twitter/*.*")),
    ('share/gwibber/plugins/twitter/ui', glob("gwibber/microblog/plugins/twitter/ui/*.*")),
    ('share/gwibber/plugins/identica', glob("gwibber/microblog/plugins/identica/*.*")),
    ('share/gwibber/plugins/identica/gtk', glob("gwibber/microblog/plugins/identica/gtk/*.*")),
    ('share/gwibber/plugins/identica/gtk/identica', glob("gwibber/microblog/plugins/identica/gtk/identica/*.*")),
    ('share/gwibber/plugins/identica/ui', glob("gwibber/microblog/plugins/identica/ui/*.*")),
    ('share/gwibber/plugins/statusnet', glob("gwibber/microblog/plugins/statusnet/*.*")),
    ('share/gwibber/plugins/statusnet/gtk', glob("gwibber/microblog/plugins/statusnet/gtk/*.*")),
    ('share/gwibber/plugins/statusnet/gtk/statusnet', glob("gwibber/microblog/plugins/statusnet/gtk/statusnet/*.*")),
    ('share/gwibber/plugins/statusnet/ui', glob("gwibber/microblog/plugins/statusnet/ui/*.*")),
    ('share/gwibber/plugins/facebook', glob("gwibber/microblog/plugins/facebook/*.*")),
    ('share/gwibber/plugins/facebook/gtk', glob("gwibber/microblog/plugins/facebook/gtk/*.*")),
    ('share/gwibber/plugins/facebook/gtk/facebook', glob("gwibber/microblog/plugins/facebook/gtk/facebook/*.*")),
    ('share/gwibber/plugins/facebook/ui', glob("gwibber/microblog/plugins/facebook/ui/*.*")),
    ('share/gwibber/plugins/flickr', glob("gwibber/microblog/plugins/flickr/*.*")),
    ('share/gwibber/plugins/flickr/gtk', glob("gwibber/microblog/plugins/flickr/gtk/*.*")),
    ('share/gwibber/plugins/flickr/gtk/flickr', glob("gwibber/microblog/plugins/flickr/gtk/flickr/*.*")),
    ('share/gwibber/plugins/flickr/ui', glob("gwibber/microblog/plugins/flickr/ui/*.*")),
    ('share/gwibber/plugins/digg', glob("gwibber/microblog/plugins/digg/*.*")),
    ('share/gwibber/plugins/digg/gtk', glob("gwibber/microblog/plugins/digg/gtk/*.*")),
    ('share/gwibber/plugins/digg/gtk/digg', glob("gwibber/microblog/plugins/digg/gtk/digg/*.*")),
    ('share/gwibber/plugins/digg/ui', glob("gwibber/microblog/plugins/digg/ui/*.*")),
    ('share/gwibber/plugins/friendfeed', glob("gwibber/microblog/plugins/friendfeed/*.*")),
    ('share/gwibber/plugins/friendfeed/gtk', glob("gwibber/microblog/plugins/friendfeed/gtk/*.*")),
    ('share/gwibber/plugins/friendfeed/gtk/friendfeed', glob("gwibber/microblog/plugins/friendfeed/gtk/friendfeed/*.*")),
    ('share/gwibber/plugins/friendfeed/ui', glob("gwibber/microblog/plugins/friendfeed/ui/*.*")),
    ('share/gwibber/plugins/pingfm', glob("gwibber/microblog/plugins/pingfm/*.*")),
    ('share/gwibber/plugins/pingfm/gtk', glob("gwibber/microblog/plugins/pingfm/gtk/*.*")),
    ('share/gwibber/plugins/pingfm/gtk/pingfm', glob("gwibber/microblog/plugins/pingfm/gtk/pingfm/*.*")),
    ('share/gwibber/plugins/pingfm/ui', glob("gwibber/microblog/plugins/pingfm/ui/*.*")),
    ('share/gwibber/plugins/qaiku', glob("gwibber/microblog/plugins/qaiku/*.*")),
    ('share/gwibber/plugins/qaiku/gtk', glob("gwibber/microblog/plugins/qaiku/gtk/*.*")),
    ('share/gwibber/plugins/qaiku/gtk/qaiku', glob("gwibber/microblog/plugins/qaiku/gtk/qaiku/*.*")),
    ('share/gwibber/plugins/qaiku/ui', glob("gwibber/microblog/plugins/qaiku/ui/*.*")),
    ('share/gwibber/plugins/foursquare', glob("gwibber/microblog/plugins/foursquare/*.*")),
    ('share/gwibber/plugins/foursquare/gtk', glob("gwibber/microblog/plugins/foursquare/gtk/*.*")),
    ('share/gwibber/plugins/foursquare/gtk/foursquare', glob("gwibber/microblog/plugins/foursquare/gtk/foursquare/*.*")),
    ('share/gwibber/plugins/foursquare/ui', glob("gwibber/microblog/plugins/foursquare/ui/*.*")),
    ('share/gwibber/plugins/foursquare/ui/icons/16x16', glob("gwibber/microblog/plugins/foursquare/ui/icons/16x16/*.*")),
    ('share/gwibber/plugins/foursquare/ui/icons/22x22', glob("gwibber/microblog/plugins/foursquare/ui/icons/22x22/*.*")),
    ('share/gwibber/plugins/foursquare/ui/icons/32x32', glob("gwibber/microblog/plugins/foursquare/ui/icons/32x32/*.*")),
    ('share/gwibber/plugins/foursquare/ui/icons/scalable', glob("gwibber/microblog/plugins/foursquare/ui/icons/scalable/*.*")),
    ('share/gwibber/plugins/buzz', glob("gwibber/microblog/plugins/buzz/*.*")),
    ('share/gwibber/plugins/buzz/gtk', glob("gwibber/microblog/plugins/buzz/gtk/*.*")),
    ('share/gwibber/plugins/buzz/gtk/buzz', glob("gwibber/microblog/plugins/buzz/gtk/buzz/*.*")),
    ('share/gwibber/plugins/buzz/ui', glob("gwibber/microblog/plugins/buzz/ui/*.*")),
    ('share/gwibber/plugins/buzz/ui/icons/16x16', glob("gwibber/microblog/plugins/buzz/ui/icons/16x16/*.*")),
    ('share/gwibber/plugins/buzz/ui/icons/22x22', glob("gwibber/microblog/plugins/buzz/ui/icons/22x22/*.*")),
    ('share/gwibber/plugins/buzz/ui/icons/32x32', glob("gwibber/microblog/plugins/buzz/ui/icons/32x32/*.*")),
    ('share/gwibber/plugins/buzz/ui/icons/scalable', glob("gwibber/microblog/plugins/buzz/ui/icons/scalable/*.*")),
    ('share/gwibber/ui', glob("ui/*.ui")),
    ('share/gwibber/ui', glob("ui/*.png")),
    ('share/gwibber/ui/templates', glob("ui/templates/*.mako")),
    ('share/gwibber/ui/templates', glob("ui/templates/*.js")),
    ('share/gwibber/ui/themes/compact', glob("ui/themes/compact/*")),
    ('share/gwibber/ui/themes/gwilouche', glob("ui/themes/gwilouche/*")),
    ('share/gwibber/ui/themes/default', glob("ui/themes/default/*")),
    ('share/gwibber/ui/themes/simple', glob("ui/themes/simple/*")),
    ('share/gwibber/ui/themes/flat', glob("ui/themes/flat/*")),
    ('share/gwibber/ui/themes/ubuntu', glob("ui/themes/ubuntu/*.*")),
    ('share/gwibber/ui/themes/ubuntu/images', glob("ui/themes/ubuntu/images/*")),
    ('share/gwibber/ui', ['ui/progress.gif']),
    ('share/gwibber/ui', ['ui/gwibber.svg']),
    ('share/pixmaps', ['ui/gwibber.svg']),
    ('share/dbus-1/services', glob("com.Gwibber.*.service")),
    ('share/dbus-1/services', ['com.GwibberClient.service']),
    ('share/gwibber/ui/icons/breakdance', glob("ui/icons/breakdance/*.png")),
    ('share/gwibber/ui/icons/breakdance', glob("ui/icons/breakdance/*.svg")),
    ('share/gwibber/ui/icons/breakdance/16x16', glob("ui/icons/breakdance/16x16/*.png")),
    ('share/gwibber/ui/icons/breakdance/16x16', glob("ui/icons/breakdance/16x16/*.svg")),
    ('share/gwibber/ui/icons/breakdance/22x22', glob("ui/icons/breakdance/22x22/*.png")),
    ('share/gwibber/ui/icons/breakdance/22x22', glob("ui/icons/breakdance/22x22/*.svg")),
    ('share/gwibber/ui/icons/breakdance/scalable', glob("ui/icons/breakdance/scalable/*.png")),
    ('share/gwibber/ui/icons/breakdance/scalable', glob("ui/icons/breakdance/scalable/*.svg")),
    ('share/gwibber/ui/icons/streams', glob("ui/icons/streams/*.png")),
    ('share/gwibber/ui/icons/streams', glob("ui/icons/streams/*.svg")),
    ('share/gwibber/ui/icons/streams/16x16', glob("ui/icons/streams/16x16/*.png")),
    ('share/gwibber/ui/icons/streams/16x16', glob("ui/icons/streams/16x16/*.svg")),
    ('share/gwibber/ui/icons/streams/24x24', glob("ui/icons/streams/24x24/*.png")),
    ('share/gwibber/ui/icons/streams/24x24', glob("ui/icons/streams/24x24/*.svg")),
    ('share/gwibber/ui/icons/streams/scalable', glob("ui/icons/streams/scalable/*.png")),
    ('share/gwibber/ui/icons/streams/scalable', glob("ui/icons/streams/scalable/*.svg")),
    ('/usr/share/indicators/messages/applications', ['indicator/gwibber']),
    ],
      scripts=['bin/gwibber', 'bin/gwibber-service', 'bin/gwibber-poster', 'bin/gwibber-accounts', 'bin/gwibber-preferences'],
      cmdclass = { "build" :  build_extra.build_extra,
                   "build_i18n" :  build_i18n.build_i18n,
                   "build_help" :  build_help.build_help,
                   "build_icons" :  build_icons.build_icons
                 }
)
