/*
 * Copyright (C) 1994-98 Free Software Foundation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you can either send email to this
 * program's author (see below) or write to:
 *
 *              The Free Software Foundation, Inc.
 *              675 Mass Ave.
 *              Cambridge, MA 02139, USA. 
 *
 * Please send bug reports, etc. to zappo@gnu.org
 *
 * The structures in this program are almost identical to those found
 * in the BSD include file protocol/talkd.h.  This is to provide
 * compatibility with older talk protocols.  Please see the comment
 * after this one from talk.h (included with this distribution) to see
 * thier copyright information.
 *
 * gtalk.h
 *
 * Purpose:
 *   These definitions will be my replacement for ntalk and otalk
 * internally.  The conversion from otalk and ntalk ctrl structures
 * will ease the conflicts when passing all the gobbldy gook about.
 * Someday this structure will define some form of gtalk daemon
 * structure which will have greater flexibility. 
 *
 *   The purpose of some fields, when going to V2 may change when/if I
 * get around to writing my talk daemon.
 *
 * $Log: gtalk.h,v $
 * Revision 1.14  1998/10/17 22:16:46  zappo
 * Added remote address to the ringer structure.
 *
 * Revision 1.13  1998/05/01 16:43:05  zappo
 * Added extension data types and constants.
 *
 * Revision 1.12  1997/12/02 22:56:06  zappo
 * Added new response for users who are filtered.
 *
 * Revision 1.11  1997/10/25 01:52:18  zappo
 * Added ifdef to get the id_num the correct size per architecture.
 *
 * Revision 1.10  1996/01/06 02:28:39  zappo
 * Added _MAX defines to specify the maximum values for control/response
 * message "answer" and "type" fields.
 *
 * Revision 1.9  1995/09/29  09:10:55  zappo
 * Removed traces of ringer response message
 *
 * Revision 1.8  1995/04/01  16:53:20  zappo
 * Removed array with no elts and simply forced a protocol onto the way
 * extensions are sent.
 *
 * Revision 1.7  1995/03/25  04:19:24  zappo
 * Updated copyright
 *
 * Revision 1.6  1995/03/23  03:00:11  zappo
 * Removed some useless features that I had once planned.
 *
 * Revision 1.5  1995/03/03  02:51:17  zappo
 * Added extension empty sized array at end of message for convenience in
 * reading in variable sized messages.
 *
 * Revision 1.4  1995/02/11  17:20:00  zappo
 * Added new error message response value TRY_HERE
 *
 * Revision 1.3  1995/02/01  03:46:46  zappo
 * Added lots of new features into the header file
 *
 * Revision 1.2  1994/11/19  17:05:47  zappo
 * Added ctl_msg(response) to end, and modified gtalk protocol from ntalk
 * version
 *
 * Revision 1.1  1994/08/29  23:44:20  zappo
 * Initial revision
 *
 */

#ifndef _GTALK_H
#define _GTALK_H

#define GNAME_SIZE 12
#define GTTY_SIZE 16
#define OPEN_NAME_LEN 40
#define RINGER_MESSAGE_LEN 80

/* The following comment is the copyright pertaining to Berkeley's    
 * format for the talk daemon.  This is in reference to the structure 
 * of the messages ONLY, (which match those found in talk.h included  
 * with this file.
 */
/*
 * Copyright (c) 1983 Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are permitted
 * provided that the above copyright notice and this paragraph are
 * duplicated in all such forms and that any documentation,
 * advertising materials, and other materials related to such
 * distribution and use acknowledge that the software was developed
 * by the University of California, Berkeley.  The name of the
 * University may not be used to endorse or promote products derived
 * from this software without specific prior written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

/* How to use the "extended" field:
 * To use, allocate a UDP packet buffer the size of this message +
 * the size of the extension you wish to send.  Then, assign that
 * size to the "extended" field.  Max value is 256 extra characters.
 */
typedef struct GNU_control_message {
  u_char          vers;		       /* talk protocol version    */
  u_char          type;		       /* request type             */
  u_char          answer;	       /*  */
  u_char          extended;	       /* !0 if additional parts   */
#if SIZEOF_LONG == 4
  u_long          id_num;	       /* message id number (dels) */
#else
  u_int           id_num;
#endif /* sizeof_long == 4 */
  struct sockaddr addr;		       /* target address           */
  struct sockaddr ctl_addr;	       /* reply to address         */
#if SIZEOF_LONG == 4
  u_long          pid;		       /* caller's process id      */
#else
  u_int           pid;		       /* caller's process id      */
#endif
  char            l_name[GNAME_SIZE];  /* caller's name            */
  char            r_name[GNAME_SIZE];  /* callee's name            */
  char            r_tty[GTTY_SIZE];    /* callee's tty             */
} CTL_MSG_GNU;

typedef struct GNU_response_message {
  u_char           vers;	       /* protocol version         */
  u_char           type;	       /* type of request message  */
  u_char           answer;	       /* response to request      */
  u_char           rvers;	       /* Version of answering vers*/
#if SIZEOF_LONG == 4
  u_long           id_num;	       /* message id number        */
#else
  u_int            id_num;
#endif
  struct  sockaddr addr;	       /* address for connection   */
  /* This is at the end to compatiblize this with NTALK version.   */
  char             r_name[GNAME_SIZE]; /* callee's name            */
} CTL_RESPONSE_GNU;

#define TALK_VERSION_GNU 2	       /* GNU protocol version number */

/* additional message type values, others from talk.h                   */
#define REPLY_QUERY    4	       /* request reply data from local */
				       /* daemon                        */
#define MAX_CONTROL_TYPE 4	       /* Make sure this is updated     */

/* additional answer values                                                  */
#define NO_CALLER         9	       /* no-one calling answer from REPLY   */
#define TRY_HERE          10	       /* Not on this machine, try this      */
#define SELECTIVE_REFUSAL 11	       /* User Filter refusal.               */
#define MAX_RESPONSE_TYPE 11           /* Make sure this is updated          */

/*
 * The following structures all define how the extension data is defined.
 * Most structures a re "open ended" with an undetermined size.  This lets
 * us pack random-length data into the smallest possible space, and skip
 * elements that are not being used.
 */
typedef struct GNU_control_extension {
  u_char           element_num;	       /* Number of elements in extension */
  u_char           pad[3];	       /* expansion room                  */
  u_char           data[256 - 4];      /* where the data is stored        */
} CTL_MSG_EXTENSION;

typedef struct GNU_control_extension_application_name {
  u_char           application_name[1];	/* the name of this application */
} CTL_MSG_EXTENSION_APPLICATION_NAME;

typedef struct GNU_control_extension_personal_name {
  u_char           personal_name[1];   /* the name of this user         */
} CTL_MSG_EXTENSION_PERSONAL_NAME;

typedef struct GNU_control_extension_element {
  u_char           type;	       /* The specific type of this data */
  u_char           length;	       /* length of this data element    */
  union {
    CTL_MSG_EXTENSION_APPLICATION_NAME  appname;
    CTL_MSG_EXTENSION_PERSONAL_NAME     personalname;
  }                data;	       /* The data of a given extension  */
} CTL_MSG_EXTENSION_ELEMENT;

/* Types of extensions */
#define EXTENSION_APPLICATION_NAME 1   /* application name data */
#define EXTENSION_PERSONAL_NAME    2   /* personal name data    */

/* additional time constants we would like to use.                           */
#define UDP_LIFE       5	       /* seconds to wait before retransmit  */
#define UDP_RETRY      2               /* Only retry X time before giving up */

/*
 * Ringer structure.  This specifies the information to be passed
 * the the read in ringer socket (~/.ringer) desribing what would be
 * useful to the application.  This is probably the LEAST stable
 * definition in here as I don't know what is terribly useful yet.
 *
 * There are not verifying reads to ringer messages because UDP write
 * failures are guaranteed on a local host
 */
typedef struct GNU_ringer_message {
  u_char           vers;	       /* protocol version          */
  u_char           type;	       /* type of ringer message    */
  u_char           pad;	               /* unused                    */
  u_char           pad2;	       /* second pad to long int    */
  struct sockaddr  addr;	       /* address for daemon        */
  char             name[GNAME_SIZE];   /* name of the user to call  */
  struct sockaddr  raddr;              /* address of remote machine */
  char             msg1[RINGER_MESSAGE_LEN];
  char             msg2[RINGER_MESSAGE_LEN];
  char             msg3[RINGER_MESSAGE_LEN];
} GNU_RING_CONTROL;

/* Define the types to "ringer requests" available.
 */
#define RINGER_CALL 0


#endif /* _GTALK_H */
