/*
 * Copyright (C) 1994, 1995, 1996, 1997, 1998, 1999 Free Software Foundation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you can either send email to this
 * program's author (see below) or write to:
 *
 *              The Free Software Foundation, Inc.
 *              675 Mass Ave.
 *              Cambridge, MA 02139, USA. 
 *
 * Please send bug reports, etc. to zappo@gnu.org.
 *
 * $Log: gtalkx.h,v $
 * Revision 1.14  1999/08/26 11:56:04  zappo
 * Added Ctxt to fix_user_windows.
 *
 * Revision 1.13  1998/10/11 11:41:22  zappo
 * Changed GTALK_VERSION to VERSION for automake.
 *
 * Revision 1.12  1998/01/04 13:32:49  zappo
 * Added a prototype from gt_display which is only used in the X functions.
 *
 * Revision 1.11  1997/12/14 19:18:15  zappo
 * Renamed package to gtalk, renamed symbols and files apropriately
 * Fixed copyright and email address.
 *
 * Revision 1.10  1997/03/21 12:13:46  zappo
 * Changed build_mainwindow prototype.
 *
 * Revision 1.9  1997/02/01 14:30:17  zappo
 * Parameter maintenace.
 *
 * Revision 1.8  1997/01/28  03:22:43  zappo
 * Prototype maintenance
 *
 * Revision 1.7  1997/01/26  15:32:33  zappo
 * Now uses GTALK_VERSION which is a string for the ETALKX_ macro
 *
 * Revision 1.6  1996/02/26  00:25:06  zappo
 * Updated prototypes
 *
 * Revision 1.5  1996/02/01  02:42:18  zappo
 * Added some more X functions
 *
 * Revision 1.4  1995/12/10  01:13:17  zappo
 * Added a new prototype
 *
 * Revision 1.3  1995/11/21  04:03:34  zappo
 * Added standard C prototypes
 *
 * Revision 1.2  1995/09/22  13:51:43  zappo
 * Added new prototypes
 *
 * Revision 1.1  1995/09/20  23:15:26  zappo
 * Initial revision
 *
 */

#ifndef GTALKX_
#define GTALKX_ "GNU Talk " VERSION

/* Undefine success for when we include X */
#undef Success

/* Basic X headers */
#include <X11/Xutil.h>
#include <X11/Xresource.h>

/* Basic toolkit stuff */
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>

/* Get Back our value of Success */
#undef Success
#define Success 1

/* Structures */
struct Xcontext {
  struct TalkContext *Ctxt;		/* talk context              */
  struct InputDevice *X;		/* X input device            */
  Display            *display;		/* our display variable      */
  XtAppContext        app_context;	/* our application context   */
  GC                  gc;		/* graphic context to use    */
  Widget              topLevel;		/* out toplevel shell widget */
};

struct MenuItemConstructor {
  char           *button_name;
  char           *describe;
  XtCallbackProc  callback;
  XtPointer       data;
};

/* Define the size of a text buffer for widgets */
#define MAX_BUFFER_SIZE 100000

#ifdef PROTOTYPES
/* gt_athena.c */
extern void XW_build_mainwindow(struct Xcontext *XCtxt);
extern void XW_set_echo_label(char *str, int showcursor);
extern void XW_setlabel(void *win, char *label);
extern void XW_fix_user_windows(struct TalkContext *Ctxt, struct WindowList *list);
extern Widget XW_popup(struct Xcontext *XCtxt, int width, int height);
extern void XW_add_text(Widget w, char *text, int   len);
extern void XW_popup_text(char *text, int   len);
extern void XW_kill_popup(struct Xcontext *XCtxt);
extern void XW_build_menu(Widget parent, char *name, struct MenuItemConstructor *items, int numitems);
extern void XW_clearwin(void *window);
extern int XW_winwidth(void *window);
extern int XW_fillcolumn(void *window);
extern void XW_delchar(void *window);
extern void XW_delline(void *window);
extern void XW_delword(void *window);


/* These are specific to X apps only, not all etalk functions. */
/* gt_x.c */
extern void X_delwin(void *win);
extern void X_xread(struct TalkContext *Ctxt, struct InputDevice *dev);
extern void X_make_menus(Widget parent);
extern void simulate_key_callback();

/* This is only used by the X functions, so put it here */
/* gt_display.c */
extern void DISP_local_string(struct TalkContext *Ctxt, char *text, int size);


#else
/* gt_athena.c */
extern void XW_build_mainwindow();
extern void XW_set_echo_label();
extern void XW_setlabel();
extern void XW_fix_user_windows();
extern Widget XW_popup();
extern void XW_add_text();
extern void XW_popup_text();
extern void XW_kill_popup();
extern void XW_build_menu();
extern void XW_clearwin();
extern int XW_fillcolumn();
extern int XW_winwidth();
extern void XW_delchar();
extern void XW_delline();
extern void XW_delword();

/* These are specific to X apps only, not all etalk functions. */
/* gt_x.c */
extern void X_delwin();
extern void X_xread();
extern void X_make_menus();
extern void simulate_key_callback();

/* This is only used by the X functions, so put it here */
/* gt_display.c */
extern void DISP_local_string();

#endif /* PROTOTYPES */

#endif
