//*****************************************************************************
//                                PrcGSchem.cpp                               *
//                               ---------------                              *
//  Started     : 18/02/2008                                                  *
//  Last Update : 29/02/2008                                                  *
//  Copyright   : (C) 2004 by MSWaters                                        *
//  Email       : M.Waters@bom.gov.au                                         *
//*****************************************************************************

//*****************************************************************************
//                                                                            *
//    This program is free software; you can redistribute it and/or modify    *
//    it under the terms of the GNU General Public License as published by    *
//    the Free Software Foundation; either version 2 of the License, or       *
//    (at your option) any later version.                                     *
//                                                                            *
//*****************************************************************************

#include "process/PrcGSchem.hpp"

//*****************************************************************************
// Constructor.

PrcGSchem::PrcGSchem( void ) : PrcBase( wxPROCESS_REDIRECT )
{
  // Initialize the object attributes
  m_oafnSchems.Clear( );
  m_ofnLog    .Clear( );

  // Attempt to set and find the appropriate binary
  bSetBinary( wxT("gschem") );
}

//*****************************************************************************
// Destructor.

PrcGSchem::~PrcGSchem( )
{
}

//*****************************************************************************
// Set the schematic file name/s.
//
// Argument List:
//   rosFileNames - A string containing the full path and file name/s
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  PrcGSchem::bSetSchems( const wxString & rosFileNames )
{
  wxStringTokenizer  ostk1;
  wxArrayString      oas1;

  ostk1.SetString( rosFileNames );
  while( ostk1.HasMoreTokens( ) )
    oas1.Add( ostk1.GetNextToken( ) );

  return( bSetSchems( oas1 ) );
}

//*****************************************************************************
// Set the schematic file name/s.
//
// Argument List:
//   roasFileNames - A string array containing the full path and file name/s
//
// Return Values:
//   TRUE  - Success
//   FALSE - Failure

bool  PrcGSchem::bSetSchems( const wxArrayString & roasFileNames )
{
  wxFileName  ofn1;
  size_t      szt1;

  // Clear the current list of schematic files
  m_oafnSchems.Clear( );

  // Check the argument is empty
  if( roasFileNames.IsEmpty( ) )                              return( TRUE );

  // Add the new schematic file name/s to the list
  for( szt1=0; szt1<roasFileNames.GetCount( ); szt1++ )
  {
    ofn1 = roasFileNames.Item( szt1 );
    if( ofn1.GetPath( ).IsEmpty( ) ) ofn1.SetPath( wxT(".") );

    if( ! ofn1.IsOk( )       ) continue;
    if( ! ofn1.FileExists( ) ) continue;

    m_oafnSchems.Add( ofn1 );
  }

  // Check that at least one schematic file name was accepted
  if( m_oafnSchems.IsEmpty( ) )                               return( FALSE );

  // Set the log file path
  ofn1 = rofnGetLogFile( );
  ofn1.SetPath( m_oafnSchems.Item( 0 ).GetPath( ) );
  bSetLogFile( ofn1.GetFullPath( ) );

  // Check if any of the schematic files were invalid
  if( m_oafnSchems.GetCount( ) != roasFileNames.GetCount( ) ) return( FALSE );

  return( TRUE );
}

//*****************************************************************************
// Get a schematic file from the list of schematic files.
//
// Return Values:
//   Success - The procedure name
//   Failure - An empty file name

const wxString & PrcGSchem::rosGetSchems( void )
{
  static  wxString  osSchems;
  size_t  sz1;

  osSchems.Empty( );

  for( sz1=0; sz1<m_oafnSchems.GetCount( ); sz1++ )
  {
    if( ! osSchems.IsEmpty( ) ) osSchems << wxT(' ');
    osSchems << m_oafnSchems.Item( sz1 ).GetFullPath( );
  }

  return( osSchems );
}

//*****************************************************************************
// Edit the schematic file/s.
// (Eg. using the following : gschem ../sch/test-amp1.sch)
//
// Return Values :
//   TRUE  - Success
//   FALSE - Failure

bool  PrcGSchem::bExec( void )
{
  // Test file names needed by this function
  if( ! bBinExists( ) )                 return( FALSE );
  if( rosGetSchems( ).IsEmpty( ) )
  {
    m_osErrMsg << wxT("The schematic file/s have not been set.");
    return( FALSE );
  }

  // Append input file name to argument list
  if( ! bSetArgLst( rosGetSchems( ) ) ) return( FALSE );

  // Execute the process
  if( ! PrcBase::bExec( ) )             return( FALSE );

  return( TRUE );
}

//*****************************************************************************
