/* -*-objc-*-
 *
 * Grr - Guenther's RSS Reader
 * Copyright (C) 2004-2006 Guenther Noack
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation;
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#import <AppKit/AppKit.h>
#import "FilterManager.h"
#import "FeedSelection.h"

id filterManagerSingleton = nil;

@implementation FilterManager

+ (id) filterManager
{
  if (filterManagerSingleton==nil)
    {
      filterManagerSingleton = [[FilterManager alloc] init];
    }
  
  return filterManagerSingleton;
}

- (id) init
{
  [super init];
  filterManagerSingleton = self;
  return self;
}

- (void) refilter: (id)sender
{
  #ifdef DEBUG
  NSLog(@"refilter:");
  #endif
  [getFeedList() setArticleListDirty: YES];
  [getMainController() refreshMainTable];
}

- (BOOL) allowsArticle: (RSSArticle*) anArticle
{
  NSString* searchString;
  
  // Fetch search string
  searchString = [searchTextField stringValue];
  
  // Check if main search string is empty.
  if ([searchString length] == 0)
    return YES;
  
  // Check if it matches headline.
  if ([[anArticle headline]
	rangeOfString: searchString
	options: NSCaseInsensitiveSearch].location != NSNotFound)
    {
      return YES;
    }
  
  if ([[anArticle description]
	rangeOfString: searchString
	options: NSCaseInsensitiveSearch].location != NSNotFound)
    {
      return YES;
    }
  
  return NO;
}

- (BOOL) allowsFeed: (RSSFeed*) aFeed
{
  if ([showOnlySelectedFeeds state] == NSOffState ||
      [RSSFeed selectedFeed] == nil)
    return YES;
  
  return [aFeed isSelected];
}

@end
