/*
 * 
 *                This source code is part of
 * 
 *                 G   R   O   M   A   C   S
 * 
 *          GROningen MAchine for Chemical Simulations
 * 
 *                        VERSION 3.2.0
 * Written by David van der Spoel, Erik Lindahl, Berk Hess, and others.
 * Copyright (c) 1991-2000, University of Groningen, The Netherlands.
 * Copyright (c) 2001-2004, The GROMACS development team,
 * check out http://www.gromacs.org for more information.

 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * If you want to redistribute modifications, please consider that
 * scientific software is very special. Version control is crucial -
 * bugs must be traceable. We will be happy to consider code for
 * inclusion in the official distribution, but derived work must not
 * be called official GROMACS. Details are found in the README & COPYING
 * files - if they are missing, get the official version at www.gromacs.org.
 * 
 * To help us fund GROMACS development, we humbly ask that you cite
 * the papers on the package - you can find them in the top README file.
 * 
 * For more info, check our website at http://www.gromacs.org
 * 
 * And Hey:
 * GROningen Mixture of Alchemy and Childrens' Stories
 */
/* This file is completely threadsafe - keep it that way! */
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


struct gmx_invsqrtdata 
{
  unsigned int    exptab[256];    /*!< Exponential lookup table */
  unsigned int    fracttab[4096]; /*!< Mantissa lookup table    */
};

#ifndef F77_FUNC
/*! \brief Macro for Fortran name-mangling
 *
 * Use Fortran name mangling from autoconf macros if defined, 
 * or lowercase+underscore by default. Since there is no easy way to convert
 * between lower and upper case in macros, you should call fortran routines
 * as F77_FUNC(routine,ROUTINE)(param1,param2,...)
 */
#define F77_FUNC(name,NAME) name ## _
#endif



struct gmx_invsqrtdata 
F77_FUNC(gmxinvsqrtdata,GMXINVSQRTDATA) = 
{ 
    /* data for exponent table - 256 floats */
    { 
        0x5f000000,0x5e800000,0x5e800000,0x5e000000,
        0x5e000000,0x5d800000,0x5d800000,0x5d000000,
        0x5d000000,0x5c800000,0x5c800000,0x5c000000,
        0x5c000000,0x5b800000,0x5b800000,0x5b000000,
        0x5b000000,0x5a800000,0x5a800000,0x5a000000,
        0x5a000000,0x59800000,0x59800000,0x59000000,
        0x59000000,0x58800000,0x58800000,0x58000000,
        0x58000000,0x57800000,0x57800000,0x57000000,
        0x57000000,0x56800000,0x56800000,0x56000000,
        0x56000000,0x55800000,0x55800000,0x55000000,
        0x55000000,0x54800000,0x54800000,0x54000000,
        0x54000000,0x53800000,0x53800000,0x53000000,
        0x53000000,0x52800000,0x52800000,0x52000000,
        0x52000000,0x51800000,0x51800000,0x51000000,
        0x51000000,0x50800000,0x50800000,0x50000000,
        0x50000000,0x4f800000,0x4f800000,0x4f000000,
        0x4f000000,0x4e800000,0x4e800000,0x4e000000,
        0x4e000000,0x4d800000,0x4d800000,0x4d000000,
        0x4d000000,0x4c800000,0x4c800000,0x4c000000,
        0x4c000000,0x4b800000,0x4b800000,0x4b000000,
        0x4b000000,0x4a800000,0x4a800000,0x4a000000,
        0x4a000000,0x49800000,0x49800000,0x49000000,
        0x49000000,0x48800000,0x48800000,0x48000000,
        0x48000000,0x47800000,0x47800000,0x47000000,
        0x47000000,0x46800000,0x46800000,0x46000000,
        0x46000000,0x45800000,0x45800000,0x45000000,
        0x45000000,0x44800000,0x44800000,0x44000000,
        0x44000000,0x43800000,0x43800000,0x43000000,
        0x43000000,0x42800000,0x42800000,0x42000000,
        0x42000000,0x41800000,0x41800000,0x41000000,
        0x41000000,0x40800000,0x40800000,0x40000000,
        0x40000000,0x3f800000,0x3f800000,0x3f000000,
        0x3f000000,0x3e800000,0x3e800000,0x3e000000,
        0x3e000000,0x3d800000,0x3d800000,0x3d000000,
        0x3d000000,0x3c800000,0x3c800000,0x3c000000,
        0x3c000000,0x3b800000,0x3b800000,0x3b000000,
        0x3b000000,0x3a800000,0x3a800000,0x3a000000,
        0x3a000000,0x39800000,0x39800000,0x39000000,
        0x39000000,0x38800000,0x38800000,0x38000000,
        0x38000000,0x37800000,0x37800000,0x37000000,
        0x37000000,0x36800000,0x36800000,0x36000000,
        0x36000000,0x35800000,0x35800000,0x35000000,
        0x35000000,0x34800000,0x34800000,0x34000000,
        0x34000000,0x33800000,0x33800000,0x33000000,
        0x33000000,0x32800000,0x32800000,0x32000000,
        0x32000000,0x31800000,0x31800000,0x31000000,
        0x31000000,0x30800000,0x30800000,0x30000000,
        0x30000000,0x2f800000,0x2f800000,0x2f000000,
        0x2f000000,0x2e800000,0x2e800000,0x2e000000,
        0x2e000000,0x2d800000,0x2d800000,0x2d000000,
        0x2d000000,0x2c800000,0x2c800000,0x2c000000,
        0x2c000000,0x2b800000,0x2b800000,0x2b000000,
        0x2b000000,0x2a800000,0x2a800000,0x2a000000,
        0x2a000000,0x29800000,0x29800000,0x29000000,
        0x29000000,0x28800000,0x28800000,0x28000000,
        0x28000000,0x27800000,0x27800000,0x27000000,
        0x27000000,0x26800000,0x26800000,0x26000000,
        0x26000000,0x25800000,0x25800000,0x25000000,
        0x25000000,0x24800000,0x24800000,0x24000000,
        0x24000000,0x23800000,0x23800000,0x23000000,
        0x23000000,0x22800000,0x22800000,0x22000000,
        0x22000000,0x21800000,0x21800000,0x21000000,
        0x21000000,0x20800000,0x20800000,0x20000000,
        0x20000000,0x1f800000,0x1f800000,0x1f000000 
    } ,
    /* data for fraction table - 4096 floats */
    {
        0x3504f3,0x34f9a4,0x34ee57,0x34e30c,0x34d7c3,0x34cc7c,0x34c137,0x34b5f5,
        0x34aab4,0x349f76,0x34943a,0x348900,0x347dc7,0x347291,0x34675e,0x345c2c,
        0x3450fc,0x3445ce,0x343aa3,0x342f79,0x342452,0x34192c,0x340e09,0x3402e8,
        0x33f7c9,0x33ecac,0x33e191,0x33d678,0x33cb61,0x33c04c,0x33b539,0x33aa28,
        0x339f19,0x33940d,0x338902,0x337df9,0x3372f3,0x3367ee,0x335cec,0x3351eb,
        0x3346ed,0x333bf0,0x3330f6,0x3325fd,0x331b07,0x331013,0x330520,0x32fa30,
        0x32ef41,0x32e455,0x32d96b,0x32ce82,0x32c39c,0x32b8b7,0x32add5,0x32a2f5,
        0x329816,0x328d3a,0x32825f,0x327787,0x326cb0,0x3261dc,0x325709,0x324c38,
        0x32416a,0x32369d,0x322bd2,0x32210a,0x321643,0x320b7e,0x3200bb,0x31f5fa,
        0x31eb3b,0x31e07e,0x31d5c3,0x31cb0a,0x31c053,0x31b59d,0x31aaea,0x31a038,
        0x319589,0x318adb,0x318030,0x317586,0x316ade,0x316038,0x315594,0x314af2,
        0x314052,0x3135b4,0x312b18,0x31207d,0x3115e5,0x310b4e,0x3100b9,0x30f627,
        0x30eb96,0x30e107,0x30d67a,0x30cbee,0x30c165,0x30b6dd,0x30ac58,0x30a1d4,
        0x309752,0x308cd2,0x308254,0x3077d8,0x306d5e,0x3062e5,0x30586e,0x304dfa,
        0x304387,0x303916,0x302ea7,0x302439,0x3019ce,0x300f64,0x3004fc,0x2ffa96,
        0x2ff032,0x2fe5d0,0x2fdb6f,0x2fd111,0x2fc6b4,0x2fbc59,0x2fb200,0x2fa7a9,
        0x2f9d53,0x2f9300,0x2f88ae,0x2f7e5e,0x2f7410,0x2f69c3,0x2f5f79,0x2f5530,
        0x2f4ae9,0x2f40a4,0x2f3661,0x2f2c1f,0x2f21df,0x2f17a1,0x2f0d65,0x2f032b,
        0x2ef8f2,0x2eeebc,0x2ee487,0x2eda53,0x2ed022,0x2ec5f2,0x2ebbc5,0x2eb199,
        0x2ea76e,0x2e9d46,0x2e931f,0x2e88fa,0x2e7ed7,0x2e74b5,0x2e6a96,0x2e6078,
        0x2e565c,0x2e4c41,0x2e4229,0x2e3812,0x2e2dfd,0x2e23e9,0x2e19d8,0x2e0fc8,
        0x2e05ba,0x2dfbad,0x2df1a3,0x2de79a,0x2ddd93,0x2dd38d,0x2dc989,0x2dbf87,
        0x2db587,0x2dab89,0x2da18c,0x2d9791,0x2d8d97,0x2d83a0,0x2d79aa,0x2d6fb6,
        0x2d65c3,0x2d5bd2,0x2d51e3,0x2d47f6,0x2d3e0a,0x2d3420,0x2d2a38,0x2d2051,
        0x2d166c,0x2d0c89,0x2d02a8,0x2cf8c8,0x2ceeea,0x2ce50d,0x2cdb33,0x2cd15a,
        0x2cc782,0x2cbdad,0x2cb3d9,0x2caa06,0x2ca036,0x2c9667,0x2c8c99,0x2c82ce,
        0x2c7904,0x2c6f3b,0x2c6575,0x2c5bb0,0x2c51ed,0x2c482b,0x2c3e6b,0x2c34ad,
        0x2c2af0,0x2c2135,0x2c177b,0x2c0dc4,0x2c040e,0x2bfa59,0x2bf0a6,0x2be6f5,
        0x2bdd46,0x2bd398,0x2bc9eb,0x2bc041,0x2bb698,0x2bacf0,0x2ba34b,0x2b99a6,
        0x2b9004,0x2b8663,0x2b7cc4,0x2b7326,0x2b698a,0x2b5ff0,0x2b5657,0x2b4cc0,
        0x2b432a,0x2b3996,0x2b3004,0x2b2673,0x2b1ce4,0x2b1357,0x2b09cb,0x2b0040,
        0x2af6b7,0x2aed30,0x2ae3ab,0x2ada27,0x2ad0a4,0x2ac724,0x2abda4,0x2ab427,
        0x2aaaab,0x2aa130,0x2a97b7,0x2a8e40,0x2a84ca,0x2a7b56,0x2a71e3,0x2a6872,
        0x2a5f03,0x2a5595,0x2a4c29,0x2a42be,0x2a3955,0x2a2fed,0x2a2687,0x2a1d23,
        0x2a13c0,0x2a0a5e,0x2a00fe,0x29f7a0,0x29ee43,0x29e4e8,0x29db8e,0x29d236,
        0x29c8e0,0x29bf8b,0x29b637,0x29ace5,0x29a395,0x299a46,0x2990f8,0x2987ad,
        0x297e62,0x297519,0x296bd2,0x29628c,0x295948,0x295005,0x2946c4,0x293d85,
        0x293446,0x292b0a,0x2921cf,0x291895,0x290f5d,0x290626,0x28fcf1,0x28f3be,
        0x28ea8c,0x28e15b,0x28d82c,0x28cefe,0x28c5d2,0x28bca8,0x28b37f,0x28aa57,
        0x28a131,0x28980c,0x288ee9,0x2885c7,0x287ca7,0x287389,0x286a6b,0x286150,
        0x285835,0x284f1c,0x284605,0x283cef,0x2833db,0x282ac8,0x2821b7,0x2818a7,
        0x280f98,0x28068b,0x27fd80,0x27f475,0x27eb6d,0x27e266,0x27d960,0x27d05c,
        0x27c759,0x27be57,0x27b557,0x27ac59,0x27a35c,0x279a60,0x279166,0x27886d,
        0x277f76,0x277680,0x276d8c,0x276499,0x275ba7,0x2752b7,0x2749c9,0x2740db,
        0x2737f0,0x272f05,0x27261c,0x271d35,0x27144f,0x270b6a,0x270287,0x26f9a5,
        0x26f0c4,0x26e7e5,0x26df08,0x26d62c,0x26cd51,0x26c477,0x26bba0,0x26b2c9,
        0x26a9f4,0x26a120,0x26984e,0x268f7d,0x2686ad,0x267ddf,0x267512,0x266c47,
        0x26637d,0x265ab4,0x2651ed,0x264927,0x264063,0x2637a0,0x262ede,0x26261e,
        0x261d5f,0x2614a2,0x260be6,0x26032b,0x25fa72,0x25f1ba,0x25e903,0x25e04e,
        0x25d79a,0x25cee7,0x25c636,0x25bd87,0x25b4d8,0x25ac2b,0x25a37f,0x259ad5,
        0x25922c,0x258985,0x2580de,0x257839,0x256f96,0x2566f4,0x255e53,0x2555b3,
        0x254d15,0x254479,0x253bdd,0x253343,0x252aaa,0x252213,0x25197d,0x2510e8,
        0x250855,0x24ffc3,0x24f732,0x24eea3,0x24e615,0x24dd88,0x24d4fc,0x24cc72,
        0x24c3ea,0x24bb62,0x24b2dc,0x24aa57,0x24a1d4,0x249952,0x2490d1,0x248852,
        0x247fd3,0x247756,0x246edb,0x246661,0x245de8,0x245570,0x244cfa,0x244485,
        0x243c11,0x24339f,0x242b2e,0x2422be,0x241a4f,0x2411e2,0x240976,0x24010c,
        0x23f8a2,0x23f03a,0x23e7d4,0x23df6e,0x23d70a,0x23cea7,0x23c646,0x23bde6,
        0x23b587,0x23ad29,0x23a4cc,0x239c71,0x239417,0x238bbf,0x238368,0x237b12,
        0x2372bd,0x236a69,0x236217,0x2359c6,0x235177,0x234928,0x2340db,0x23388f,
        0x233045,0x2327fb,0x231fb3,0x23176c,0x230f27,0x2306e2,0x22fe9f,0x22f65e,
        0x22ee1d,0x22e5de,0x22dda0,0x22d563,0x22cd28,0x22c4ed,0x22bcb4,0x22b47c,
        0x22ac46,0x22a411,0x229bdd,0x2293aa,0x228b78,0x228348,0x227b19,0x2272eb,
        0x226abe,0x226293,0x225a69,0x225240,0x224a18,0x2241f2,0x2239cc,0x2231a8,
        0x222985,0x222164,0x221944,0x221124,0x220907,0x2200ea,0x21f8ce,0x21f0b4,
        0x21e89b,0x21e083,0x21d86d,0x21d057,0x21c843,0x21c030,0x21b81e,0x21b00e,
        0x21a7fe,0x219ff0,0x2197e3,0x218fd8,0x2187cd,0x217fc4,0x2177bc,0x216fb5,
        0x2167af,0x215faa,0x2157a7,0x214fa5,0x2147a4,0x213fa4,0x2137a5,0x212fa8,
        0x2127ac,0x211fb1,0x2117b7,0x210fbe,0x2107c7,0x20ffd0,0x20f7db,0x20efe7,
        0x20e7f5,0x20e003,0x20d813,0x20d023,0x20c835,0x20c048,0x20b85d,0x20b072,
        0x20a889,0x20a0a1,0x2098ba,0x2090d4,0x2088ef,0x20810b,0x207929,0x207148,
        0x206968,0x206189,0x2059ab,0x2051cf,0x2049f3,0x204219,0x203a40,0x203268,
        0x202a91,0x2022bb,0x201ae7,0x201313,0x200b41,0x200370,0x1ffba0,0x1ff3d1,
        0x1fec04,0x1fe437,0x1fdc6c,0x1fd4a2,0x1fccd9,0x1fc511,0x1fbd4a,0x1fb584,
        0x1fadc0,0x1fa5fc,0x1f9e3a,0x1f9679,0x1f8eb9,0x1f86fa,0x1f7f3c,0x1f777f,
        0x1f6fc4,0x1f680a,0x1f6050,0x1f5898,0x1f50e1,0x1f492b,0x1f4176,0x1f39c3,
        0x1f3210,0x1f2a5f,0x1f22af,0x1f1aff,0x1f1351,0x1f0ba4,0x1f03f8,0x1efc4e,
        0x1ef4a4,0x1eecfb,0x1ee554,0x1eddae,0x1ed608,0x1ece64,0x1ec6c1,0x1ebf1f,
        0x1eb77f,0x1eafdf,0x1ea840,0x1ea0a3,0x1e9906,0x1e916b,0x1e89d1,0x1e8238,
        0x1e7aa0,0x1e7309,0x1e6b73,0x1e63de,0x1e5c4a,0x1e54b8,0x1e4d26,0x1e4596,
        0x1e3e06,0x1e3678,0x1e2eeb,0x1e275f,0x1e1fd4,0x1e184a,0x1e10c1,0x1e0939,
        0x1e01b3,0x1dfa2d,0x1df2a8,0x1deb25,0x1de3a2,0x1ddc21,0x1dd4a1,0x1dcd22,
        0x1dc5a3,0x1dbe26,0x1db6aa,0x1daf2f,0x1da7b6,0x1da03d,0x1d98c5,0x1d914e,
        0x1d89d9,0x1d8264,0x1d7af1,0x1d737e,0x1d6c0d,0x1d649c,0x1d5d2d,0x1d55bf,
        0x1d4e52,0x1d46e5,0x1d3f7a,0x1d3810,0x1d30a7,0x1d293f,0x1d21d8,0x1d1a73,
        0x1d130e,0x1d0baa,0x1d0447,0x1cfce6,0x1cf585,0x1cee25,0x1ce6c7,0x1cdf69,
        0x1cd80d,0x1cd0b1,0x1cc957,0x1cc1fe,0x1cbaa5,0x1cb34e,0x1cabf8,0x1ca4a2,
        0x1c9d4e,0x1c95fb,0x1c8ea9,0x1c8758,0x1c8008,0x1c78b8,0x1c716a,0x1c6a1d,
        0x1c62d1,0x1c5b86,0x1c543c,0x1c4cf3,0x1c45ab,0x1c3e65,0x1c371f,0x1c2fda,
        0x1c2896,0x1c2153,0x1c1a11,0x1c12d0,0x1c0b90,0x1c0452,0x1bfd14,0x1bf5d7,
        0x1bee9b,0x1be760,0x1be027,0x1bd8ee,0x1bd1b6,0x1bca7f,0x1bc349,0x1bbc15,
        0x1bb4e1,0x1badae,0x1ba67c,0x1b9f4c,0x1b981c,0x1b90ed,0x1b89bf,0x1b8292,
        0x1b7b67,0x1b743c,0x1b6d12,0x1b65e9,0x1b5ec1,0x1b579a,0x1b5074,0x1b4950,
        0x1b422c,0x1b3b09,0x1b33e7,0x1b2cc6,0x1b25a6,0x1b1e87,0x1b1769,0x1b104c,
        0x1b0930,0x1b0215,0x1afafb,0x1af3e2,0x1aecc9,0x1ae5b2,0x1ade9c,0x1ad787,
        0x1ad073,0x1ac95f,0x1ac24d,0x1abb3c,0x1ab42b,0x1aad1c,0x1aa60d,0x1a9f00,
        0x1a97f3,0x1a90e8,0x1a89dd,0x1a82d4,0x1a7bcb,0x1a74c3,0x1a6dbd,0x1a66b7,
        0x1a5fb2,0x1a58ae,0x1a51ab,0x1a4aa9,0x1a43a8,0x1a3ca8,0x1a35a9,0x1a2eab,
        0x1a27ae,0x1a20b1,0x1a19b6,0x1a12bc,0x1a0bc2,0x1a04ca,0x19fdd2,0x19f6dc,
        0x19efe6,0x19e8f2,0x19e1fe,0x19db0b,0x19d419,0x19cd28,0x19c638,0x19bf49,
        0x19b85b,0x19b16e,0x19aa82,0x19a396,0x199cac,0x1995c3,0x198eda,0x1987f3,
        0x19810c,0x197a26,0x197342,0x196c5e,0x19657b,0x195e99,0x1957b8,0x1950d8,
        0x1949f8,0x19431a,0x193c3d,0x193560,0x192e85,0x1927aa,0x1920d1,0x1919f8,
        0x191320,0x190c49,0x190573,0x18fe9e,0x18f7ca,0x18f0f7,0x18ea24,0x18e353,
        0x18dc82,0x18d5b3,0x18cee4,0x18c816,0x18c149,0x18ba7d,0x18b3b2,0x18ace8,
        0x18a61f,0x189f56,0x18988f,0x1891c8,0x188b03,0x18843e,0x187d7a,0x1876b7,
        0x186ff5,0x186934,0x186274,0x185bb4,0x1854f6,0x184e38,0x18477c,0x1840c0,
        0x183a05,0x18334b,0x182c92,0x1825da,0x181f23,0x18186c,0x1811b7,0x180b02,
        0x18044e,0x17fd9b,0x17f6e9,0x17f038,0x17e988,0x17e2d9,0x17dc2a,0x17d57d,
        0x17ced0,0x17c824,0x17c179,0x17bacf,0x17b426,0x17ad7e,0x17a6d6,0x17a030,
        0x17998a,0x1792e5,0x178c41,0x17859e,0x177efc,0x17785b,0x1771ba,0x176b1b,
        0x17647c,0x175dde,0x175741,0x1750a5,0x174a0a,0x17436f,0x173cd6,0x17363d,
        0x172fa5,0x17290f,0x172278,0x171be3,0x17154f,0x170ebb,0x170829,0x170197,
        0x16fb06,0x16f476,0x16ede7,0x16e759,0x16e0cb,0x16da3e,0x16d3b3,0x16cd28,
        0x16c69e,0x16c014,0x16b98c,0x16b305,0x16ac7e,0x16a5f8,0x169f73,0x1698ef,
        0x16926c,0x168be9,0x168568,0x167ee7,0x167867,0x1671e8,0x166b6a,0x1664ec,
        0x165e70,0x1657f4,0x165179,0x164aff,0x164486,0x163e0d,0x163796,0x16311f,
        0x162aa9,0x162434,0x161dc0,0x16174d,0x1610da,0x160a68,0x1603f8,0x15fd88,
        0x15f718,0x15f0aa,0x15ea3c,0x15e3d0,0x15dd64,0x15d6f9,0x15d08e,0x15ca25,
        0x15c3bc,0x15bd55,0x15b6ee,0x15b087,0x15aa22,0x15a3be,0x159d5a,0x1596f7,
        0x159095,0x158a34,0x1583d3,0x157d74,0x157715,0x1570b7,0x156a5a,0x1563fd,
        0x155da2,0x155747,0x1550ed,0x154a94,0x15443c,0x153de4,0x15378e,0x153138,
        0x152ae3,0x15248e,0x151e3b,0x1517e8,0x151197,0x150b45,0x1504f5,0x14fea6,
        0x14f857,0x14f209,0x14ebbc,0x14e570,0x14df25,0x14d8da,0x14d290,0x14cc47,
        0x14c5ff,0x14bfb7,0x14b971,0x14b32b,0x14ace6,0x14a6a1,0x14a05e,0x149a1b,
        0x1493d9,0x148d98,0x148758,0x148118,0x147ada,0x14749c,0x146e5f,0x146822,
        0x1461e7,0x145bac,0x145572,0x144f38,0x144900,0x1442c8,0x143c91,0x14365b,
        0x143026,0x1429f1,0x1423be,0x141d8b,0x141758,0x141127,0x140af6,0x1404c6,
        0x13fe97,0x13f869,0x13f23b,0x13ec0f,0x13e5e3,0x13dfb7,0x13d98d,0x13d363,
        0x13cd3a,0x13c712,0x13c0eb,0x13bac4,0x13b49e,0x13ae79,0x13a855,0x13a231,
        0x139c0e,0x1395ec,0x138fcb,0x1389ab,0x13838b,0x137d6c,0x13774e,0x137130,
        0x136b13,0x1364f8,0x135edc,0x1358c2,0x1352a8,0x134c8f,0x134677,0x134060,
        0x133a49,0x133433,0x132e1e,0x13280a,0x1321f6,0x131be3,0x1315d1,0x130fc0,
        0x1309af,0x13039f,0x12fd90,0x12f782,0x12f174,0x12eb67,0x12e55b,0x12df50,
        0x12d945,0x12d33b,0x12cd32,0x12c72a,0x12c122,0x12bb1b,0x12b515,0x12af10,
        0x12a90b,0x12a307,0x129d04,0x129702,0x129100,0x128aff,0x1284ff,0x127eff,
        0x127900,0x127302,0x126d05,0x126708,0x12610d,0x125b11,0x125517,0x124f1d,
        0x124925,0x12432c,0x123d35,0x12373e,0x123148,0x122b53,0x12255e,0x121f6b,
        0x121978,0x121385,0x120d94,0x1207a3,0x1201b3,0x11fbc3,0x11f5d4,0x11efe6,
        0x11e9f9,0x11e40d,0x11de21,0x11d836,0x11d24b,0x11cc62,0x11c679,0x11c090,
        0x11baa9,0x11b4c2,0x11aedc,0x11a8f7,0x11a312,0x119d2e,0x11974b,0x119168,
        0x118b87,0x1185a6,0x117fc5,0x1179e5,0x117407,0x116e28,0x11684b,0x11626e,
        0x115c92,0x1156b6,0x1150dc,0x114b02,0x114529,0x113f50,0x113978,0x1133a1,
        0x112dca,0x1127f5,0x112220,0x111c4b,0x111678,0x1110a5,0x110ad3,0x110501,
        0x10ff30,0x10f960,0x10f391,0x10edc2,0x10e7f4,0x10e226,0x10dc5a,0x10d68e,
        0x10d0c3,0x10caf8,0x10c52e,0x10bf65,0x10b99c,0x10b3d5,0x10ae0e,0x10a847,
        0x10a281,0x109cbc,0x1096f8,0x109134,0x108b72,0x1085af,0x107fee,0x107a2d,
        0x10746d,0x106ead,0x1068ee,0x106330,0x105d73,0x1057b6,0x1051fa,0x104c3e,
        0x104684,0x1040ca,0x103b10,0x103558,0x102fa0,0x1029e8,0x102432,0x101e7c,
        0x1018c6,0x101312,0x100d5e,0x1007ab,0x1001f8,0xffc46,0xff695,0xff0e4,
        0xfeb35,0xfe585,0xfdfd7,0xfda29,0xfd47c,0xfcecf,0xfc923,0xfc378,
        0xfbdce,0xfb824,0xfb27b,0xfacd2,0xfa72a,0xfa183,0xf9bdd,0xf9637,
        0xf9092,0xf8aed,0xf854a,0xf7fa6,0xf7a04,0xf7462,0xf6ec1,0xf6920,
        0xf6381,0xf5de1,0xf5843,0xf52a5,0xf4d08,0xf476b,0xf41cf,0xf3c34,
        0xf369a,0xf3100,0xf2b66,0xf25ce,0xf2036,0xf1a9f,0xf1508,0xf0f72,
        0xf09dd,0xf0448,0xefeb4,0xef921,0xef38e,0xeedfc,0xee86b,0xee2da,
        0xedd4a,0xed7ba,0xed22b,0xecc9d,0xec710,0xec183,0xebbf7,0xeb66b,
        0xeb0e0,0xeab56,0xea5cc,0xea043,0xe9abb,0xe9533,0xe8fac,0xe8a26,
        0xe84a0,0xe7f1b,0xe7996,0xe7413,0xe6e8f,0xe690d,0xe638b,0xe5e0a,
        0xe5889,0xe5309,0xe4d8a,0xe480b,0xe428d,0xe3d0f,0xe3792,0xe3216,
        0xe2c9b,0xe2720,0xe21a5,0xe1c2c,0xe16b3,0xe113a,0xe0bc3,0xe064c,
        0xe00d5,0xdfb5f,0xdf5ea,0xdf075,0xdeb01,0xde58e,0xde01b,0xddaa9,
        0xdd538,0xdcfc7,0xdca57,0xdc4e7,0xdbf78,0xdba0a,0xdb49c,0xdaf2f,
        0xda9c2,0xda457,0xd9eeb,0xd9981,0xd9417,0xd8ead,0xd8945,0xd83dc,
        0xd7e75,0xd790e,0xd73a8,0xd6e42,0xd68dd,0xd6379,0xd5e15,0xd58b2,
        0xd534f,0xd4ded,0xd488c,0xd432b,0xd3dcb,0xd386c,0xd330d,0xd2dae,
        0xd2851,0xd22f4,0xd1d97,0xd183b,0xd12e0,0xd0d86,0xd082c,0xd02d2,
        0xcfd79,0xcf821,0xcf2ca,0xced73,0xce81c,0xce2c7,0xcdd72,0xcd81d,
        0xcd2c9,0xccd76,0xcc823,0xcc2d1,0xcbd7f,0xcb82f,0xcb2de,0xcad8f,
        0xca83f,0xca2f1,0xc9da3,0xc9856,0xc9309,0xc8dbd,0xc8871,0xc8326,
        0xc7ddc,0xc7892,0xc7349,0xc6e01,0xc68b9,0xc6372,0xc5e2b,0xc58e5,
        0xc539f,0xc4e5a,0xc4916,0xc43d2,0xc3e8f,0xc394c,0xc340a,0xc2ec9,
        0xc2988,0xc2448,0xc1f08,0xc19c9,0xc148b,0xc0f4d,0xc0a10,0xc04d3,
        0xbff97,0xbfa5b,0xbf521,0xbefe6,0xbeaad,0xbe573,0xbe03b,0xbdb03,
        0xbd5cb,0xbd095,0xbcb5e,0xbc629,0xbc0f4,0xbbbbf,0xbb68b,0xbb158,
        0xbac25,0xba6f3,0xba1c1,0xb9c90,0xb9760,0xb9230,0xb8d01,0xb87d2,
        0xb82a4,0xb7d76,0xb7849,0xb731d,0xb6df1,0xb68c6,0xb639b,0xb5e71,
        0xb5948,0xb541f,0xb4ef6,0xb49cf,0xb44a7,0xb3f81,0xb3a5b,0xb3535,
        0xb3010,0xb2aec,0xb25c8,0xb20a5,0xb1b82,0xb1660,0xb113e,0xb0c1d,
        0xb06fd,0xb01dd,0xafcbe,0xaf79f,0xaf281,0xaed64,0xae847,0xae32a,
        0xade0e,0xad8f3,0xad3d8,0xacebe,0xac9a4,0xac48b,0xabf73,0xaba5b,
        0xab544,0xab02d,0xaab17,0xaa601,0xaa0ec,0xa9bd7,0xa96c3,0xa91b0,
        0xa8c9d,0xa878a,0xa8279,0xa7d67,0xa7857,0xa7347,0xa6e37,0xa6928,
        0xa641a,0xa5f0c,0xa59fe,0xa54f2,0xa4fe5,0xa4ada,0xa45ce,0xa40c4,
        0xa3bba,0xa36b0,0xa31a7,0xa2c9f,0xa2797,0xa2290,0xa1d89,0xa1883,
        0xa137d,0xa0e78,0xa0974,0xa0470,0x9ff6c,0x9fa69,0x9f567,0x9f065,
        0x9eb64,0x9e663,0x9e163,0x9dc63,0x9d764,0x9d266,0x9cd68,0x9c86a,
        0x9c36d,0x9be71,0x9b975,0x9b47a,0x9af7f,0x9aa85,0x9a58b,0x9a092,
        0x99b9a,0x996a1,0x991aa,0x98cb3,0x987bd,0x982c7,0x97dd1,0x978dc,
        0x973e8,0x96ef4,0x96a01,0x9650e,0x9601c,0x95b2b,0x9563a,0x95149,
        0x94c59,0x94769,0x9427a,0x93d8c,0x9389e,0x933b1,0x92ec4,0x929d8,
        0x924ec,0x92001,0x91b16,0x9162c,0x91142,0x90c59,0x90770,0x90288,
        0x8fda1,0x8f8ba,0x8f3d3,0x8eeed,0x8ea08,0x8e523,0x8e03e,0x8db5b,
        0x8d677,0x8d194,0x8ccb2,0x8c7d0,0x8c2ef,0x8be0e,0x8b92e,0x8b44e,
        0x8af6f,0x8aa91,0x8a5b2,0x8a0d5,0x89bf8,0x8971b,0x8923f,0x88d64,
        0x88889,0x883ae,0x87ed4,0x879fb,0x87522,0x87049,0x86b71,0x8669a,
        0x861c3,0x85ced,0x85817,0x85341,0x84e6d,0x84998,0x844c5,0x83ff1,
        0x83b1e,0x8364c,0x8317a,0x82ca9,0x827d8,0x82308,0x81e39,0x81969,
        0x8149b,0x80fcd,0x80aff,0x80632,0x80165,0x7fc99,0x7f7cd,0x7f302,
        0x7ee37,0x7e96d,0x7e4a4,0x7dfdb,0x7db12,0x7d64a,0x7d182,0x7ccbb,
        0x7c7f5,0x7c32f,0x7be69,0x7b9a4,0x7b4df,0x7b01b,0x7ab58,0x7a695,
        0x7a1d2,0x79d10,0x7984f,0x7938e,0x78ecd,0x78a0d,0x7854d,0x7808e,
        0x77bd0,0x77712,0x77254,0x76d97,0x768da,0x7641e,0x75f63,0x75aa8,
        0x755ed,0x75133,0x74c79,0x747c0,0x74308,0x73e50,0x73998,0x734e1,
        0x7302a,0x72b74,0x726be,0x72209,0x71d55,0x718a0,0x713ed,0x70f3a,
        0x70a87,0x705d5,0x70123,0x6fc72,0x6f7c1,0x6f311,0x6ee61,0x6e9b2,
        0x6e503,0x6e055,0x6dba7,0x6d6f9,0x6d24d,0x6cda0,0x6c8f4,0x6c449,
        0x6bf9e,0x6baf4,0x6b64a,0x6b1a0,0x6acf7,0x6a84f,0x6a3a7,0x69eff,
        0x69a58,0x695b2,0x6910c,0x68c66,0x687c1,0x6831d,0x67e78,0x679d5,
        0x67532,0x6708f,0x66bed,0x6674b,0x662aa,0x65e09,0x65969,0x654c9,
        0x65029,0x64b8a,0x646ec,0x6424e,0x63db1,0x63914,0x63477,0x62fdb,
        0x62b40,0x626a5,0x6220a,0x61d70,0x618d6,0x6143d,0x60fa4,0x60b0c,
        0x60674,0x601dd,0x5fd46,0x5f8b0,0x5f41a,0x5ef85,0x5eaf0,0x5e65b,
        0x5e1c7,0x5dd34,0x5d8a1,0x5d40e,0x5cf7c,0x5caea,0x5c659,0x5c1c9,
        0x5bd38,0x5b8a9,0x5b419,0x5af8a,0x5aafc,0x5a66e,0x5a1e1,0x59d54,
        0x598c7,0x5943b,0x58fb0,0x58b24,0x5869a,0x58210,0x57d86,0x578fd,
        0x57474,0x56feb,0x56b64,0x566dc,0x56255,0x55dcf,0x55949,0x554c3,
        0x5503e,0x54bb9,0x54735,0x542b1,0x53e2e,0x539ab,0x53529,0x530a7,
        0x52c25,0x527a4,0x52324,0x51ea4,0x51a24,0x515a5,0x51126,0x50ca8,
        0x5082a,0x503ad,0x4ff30,0x4fab4,0x4f638,0x4f1bc,0x4ed41,0x4e8c6,
        0x4e44c,0x4dfd3,0x4db59,0x4d6e0,0x4d268,0x4cdf0,0x4c979,0x4c502,
        0x4c08b,0x4bc15,0x4b79f,0x4b32a,0x4aeb5,0x4aa41,0x4a5cd,0x4a15a,
        0x49ce7,0x49874,0x49402,0x48f91,0x48b1f,0x486af,0x4823e,0x47dce,
        0x4795f,0x474f0,0x47082,0x46c14,0x467a6,0x46339,0x45ecc,0x45a60,
        0x455f4,0x45189,0x44d1e,0x448b3,0x44449,0x43fdf,0x43b76,0x4370d,
        0x432a5,0x42e3d,0x429d6,0x4256f,0x42108,0x41ca2,0x4183c,0x413d7,
        0x40f72,0x40b0e,0x406aa,0x40247,0x3fde4,0x3f981,0x3f51f,0x3f0bd,
        0x3ec5c,0x3e7fb,0x3e39b,0x3df3b,0x3dadb,0x3d67c,0x3d21d,0x3cdbf,
        0x3c961,0x3c504,0x3c0a7,0x3bc4a,0x3b7ee,0x3b393,0x3af37,0x3aadd,
        0x3a682,0x3a228,0x39dcf,0x39976,0x3951d,0x390c5,0x38c6d,0x38816,
        0x383bf,0x37f69,0x37b13,0x376bd,0x37268,0x36e13,0x369bf,0x3656b,
        0x36117,0x35cc4,0x35872,0x3541f,0x34fce,0x34b7c,0x3472b,0x342db,
        0x33e8b,0x33a3b,0x335ec,0x3319d,0x32d4f,0x32901,0x324b3,0x32066,
        0x31c1a,0x317cd,0x31381,0x30f36,0x30aeb,0x306a1,0x30256,0x2fe0d,
        0x2f9c3,0x2f57a,0x2f132,0x2ecea,0x2e8a2,0x2e45b,0x2e014,0x2dbce,
        0x2d788,0x2d343,0x2cefd,0x2cab9,0x2c675,0x2c231,0x2bded,0x2b9aa,
        0x2b568,0x2b125,0x2ace4,0x2a8a2,0x2a461,0x2a021,0x29be1,0x297a1,
        0x29362,0x28f23,0x28ae4,0x286a6,0x28269,0x27e2c,0x279ef,0x275b2,
        0x27176,0x26d3b,0x26900,0x264c5,0x2608b,0x25c51,0x25817,0x253de,
        0x24fa6,0x24b6d,0x24735,0x242fe,0x23ec7,0x23a90,0x2365a,0x23224,
        0x22def,0x229ba,0x22585,0x22151,0x21d1d,0x218ea,0x214b7,0x21084,
        0x20c52,0x20821,0x203ef,0x1ffbe,0x1fb8e,0x1f75e,0x1f32e,0x1eeff,
        0x1ead0,0x1e6a1,0x1e273,0x1de45,0x1da18,0x1d5eb,0x1d1bf,0x1cd93,
        0x1c967,0x1c53c,0x1c111,0x1bce6,0x1b8bc,0x1b493,0x1b069,0x1ac40,
        0x1a818,0x1a3f0,0x19fc8,0x19ba1,0x1977a,0x19354,0x18f2d,0x18b08,
        0x186e2,0x182be,0x17e99,0x17a75,0x17651,0x1722e,0x16e0b,0x169e9,
        0x165c6,0x161a5,0x15d83,0x15963,0x15542,0x15122,0x14d02,0x148e3,
        0x144c4,0x140a5,0x13c87,0x13869,0x1344c,0x1302f,0x12c12,0x127f6,
        0x123da,0x11fbf,0x11ba4,0x11789,0x1136f,0x10f55,0x10b3c,0x10723,
        0x1030a,0xfef2,0xfada,0xf6c2,0xf2ab,0xee95,0xea7e,0xe668,
        0xe253,0xde3e,0xda29,0xd614,0xd200,0xcded,0xc9da,0xc5c7,
        0xc1b4,0xbda2,0xb990,0xb57f,0xb16e,0xad5e,0xa94e,0xa53e,
        0xa12e,0x9d1f,0x9911,0x9503,0x90f5,0x8ce7,0x88da,0x84ce,
        0x80c1,0x7cb5,0x78aa,0x749f,0x7094,0x6c89,0x687f,0x6476,
        0x606d,0x5c64,0x585b,0x5453,0x504b,0x4c44,0x483d,0x4436,
        0x4030,0x3c2a,0x3825,0x3420,0x301b,0x2c17,0x2813,0x240f,
        0x200c,0x1c09,0x1807,0x1405,0x1003,0xc02,0x801,0x400,
        0x7fffff,0x7ff001,0x7fe006,0x7fd00d,0x7fc018,0x7fb025,0x7fa036,0x7f9049,
        0x7f8060,0x7f7079,0x7f6095,0x7f50b5,0x7f40d7,0x7f30fc,0x7f2124,0x7f114f,
        0x7f017e,0x7ef1af,0x7ee1e2,0x7ed219,0x7ec253,0x7eb290,0x7ea2d0,0x7e9312,
        0x7e8358,0x7e73a0,0x7e63eb,0x7e543a,0x7e448b,0x7e34df,0x7e2536,0x7e1590,
        0x7e05ec,0x7df64c,0x7de6ae,0x7dd714,0x7dc77c,0x7db7e7,0x7da855,0x7d98c6,
        0x7d893a,0x7d79b0,0x7d6a2a,0x7d5aa6,0x7d4b25,0x7d3ba7,0x7d2c2c,0x7d1cb3,
        0x7d0d3e,0x7cfdcb,0x7cee5b,0x7cdeee,0x7ccf84,0x7cc01d,0x7cb0b8,0x7ca156,
        0x7c91f7,0x7c829b,0x7c7342,0x7c63eb,0x7c5497,0x7c4546,0x7c35f8,0x7c26ad,
        0x7c1764,0x7c081e,0x7bf8db,0x7be99b,0x7bda5d,0x7bcb23,0x7bbbeb,0x7bacb5,
        0x7b9d83,0x7b8e53,0x7b7f26,0x7b6ffc,0x7b60d4,0x7b51b0,0x7b428e,0x7b336e,
        0x7b2452,0x7b1538,0x7b0621,0x7af70c,0x7ae7fb,0x7ad8ec,0x7ac9e0,0x7abad6,
        0x7aabcf,0x7a9ccb,0x7a8dca,0x7a7ecb,0x7a6fcf,0x7a60d5,0x7a51df,0x7a42eb,
        0x7a33f9,0x7a250b,0x7a161f,0x7a0735,0x79f84f,0x79e96b,0x79da89,0x79cbab,
        0x79bccf,0x79adf5,0x799f1f,0x79904a,0x798179,0x7972aa,0x7963de,0x795515,
        0x79464e,0x793789,0x7928c8,0x791a09,0x790b4c,0x78fc92,0x78eddb,0x78df27,
        0x78d075,0x78c1c5,0x78b319,0x78a46e,0x7895c7,0x788722,0x78787f,0x7869e0,
        0x785b42,0x784ca8,0x783e10,0x782f7a,0x7820e7,0x781257,0x7803c9,0x77f53e,
        0x77e6b5,0x77d82f,0x77c9ab,0x77bb2a,0x77acac,0x779e30,0x778fb6,0x77813f,
        0x7772cb,0x776459,0x7755ea,0x77477d,0x773913,0x772aab,0x771c46,0x770de3,
        0x76ff83,0x76f125,0x76e2ca,0x76d472,0x76c61b,0x76b7c8,0x76a977,0x769b28,
        0x768cdc,0x767e92,0x76704b,0x766206,0x7653c4,0x764584,0x763747,0x76290c,
        0x761ad3,0x760c9d,0x75fe6a,0x75f039,0x75e20a,0x75d3de,0x75c5b5,0x75b78e,
        0x75a969,0x759b46,0x758d27,0x757f09,0x7570ee,0x7562d6,0x7554bf,0x7546ac,
        0x75389a,0x752a8c,0x751c7f,0x750e75,0x75006d,0x74f268,0x74e465,0x74d665,
        0x74c867,0x74ba6b,0x74ac72,0x749e7b,0x749087,0x748295,0x7474a5,0x7466b8,
        0x7458cd,0x744ae4,0x743cfe,0x742f1a,0x742139,0x74135a,0x74057d,0x73f7a3,
        0x73e9cb,0x73dbf5,0x73ce22,0x73c051,0x73b282,0x73a4b6,0x7396ec,0x738925,
        0x737b60,0x736d9d,0x735fdc,0x73521e,0x734462,0x7336a9,0x7328f1,0x731b3c,
        0x730d8a,0x72ffd9,0x72f22c,0x72e480,0x72d6d7,0x72c92f,0x72bb8b,0x72ade8,
        0x72a048,0x7292aa,0x72850f,0x727775,0x7269de,0x725c4a,0x724eb7,0x724127,
        0x723399,0x72260e,0x721884,0x720afd,0x71fd79,0x71eff6,0x71e276,0x71d4f8,
        0x71c77c,0x71ba02,0x71ac8b,0x719f16,0x7191a3,0x718433,0x7176c5,0x716959,
        0x715bef,0x714e87,0x714122,0x7133bf,0x71265e,0x711900,0x710ba3,0x70fe49,
        0x70f0f1,0x70e39b,0x70d648,0x70c8f6,0x70bba7,0x70ae5a,0x70a110,0x7093c7,
        0x708681,0x70793d,0x706bfb,0x705ebb,0x70517d,0x704442,0x703709,0x7029d2,
        0x701c9d,0x700f6a,0x70023a,0x6ff50c,0x6fe7e0,0x6fdab6,0x6fcd8e,0x6fc068,
        0x6fb345,0x6fa624,0x6f9904,0x6f8be7,0x6f7ecd,0x6f71b4,0x6f649d,0x6f5789,
        0x6f4a77,0x6f3d67,0x6f3059,0x6f234d,0x6f1643,0x6f093c,0x6efc36,0x6eef33,
        0x6ee232,0x6ed533,0x6ec836,0x6ebb3b,0x6eae42,0x6ea14c,0x6e9457,0x6e8765,
        0x6e7a74,0x6e6d86,0x6e609a,0x6e53b0,0x6e46c8,0x6e39e3,0x6e2cff,0x6e201d,
        0x6e133e,0x6e0661,0x6df985,0x6decac,0x6ddfd5,0x6dd300,0x6dc62d,0x6db95c,
        0x6dac8d,0x6d9fc0,0x6d92f5,0x6d862d,0x6d7966,0x6d6ca2,0x6d5fdf,0x6d531f,
        0x6d4660,0x6d39a4,0x6d2cea,0x6d2032,0x6d137c,0x6d06c7,0x6cfa15,0x6ced65,
        0x6ce0b7,0x6cd40b,0x6cc761,0x6cbab9,0x6cae14,0x6ca170,0x6c94ce,0x6c882e,
        0x6c7b90,0x6c6ef5,0x6c625b,0x6c55c3,0x6c492d,0x6c3c9a,0x6c3008,0x6c2378,
        0x6c16ea,0x6c0a5f,0x6bfdd5,0x6bf14d,0x6be4c8,0x6bd844,0x6bcbc2,0x6bbf42,
        0x6bb2c5,0x6ba649,0x6b99cf,0x6b8d57,0x6b80e2,0x6b746e,0x6b67fc,0x6b5b8c,
        0x6b4f1e,0x6b42b2,0x6b3648,0x6b29e0,0x6b1d7a,0x6b1116,0x6b04b4,0x6af854,
        0x6aebf5,0x6adf99,0x6ad33f,0x6ac6e6,0x6aba90,0x6aae3b,0x6aa1e9,0x6a9598,
        0x6a8949,0x6a7cfd,0x6a70b2,0x6a6469,0x6a5822,0x6a4bdd,0x6a3f9a,0x6a3359,
        0x6a271a,0x6a1adc,0x6a0ea1,0x6a0267,0x69f630,0x69e9fa,0x69ddc6,0x69d195,
        0x69c565,0x69b937,0x69ad0b,0x69a0e0,0x6994b8,0x698892,0x697c6d,0x69704a,
        0x69642a,0x69580b,0x694bee,0x693fd3,0x6933ba,0x6927a2,0x691b8d,0x690f79,
        0x690368,0x68f758,0x68eb4a,0x68df3e,0x68d334,0x68c72b,0x68bb25,0x68af20,
        0x68a31d,0x68971d,0x688b1d,0x687f20,0x687325,0x68672c,0x685b34,0x684f3e,
        0x68434a,0x683758,0x682b68,0x681f7a,0x68138d,0x6807a2,0x67fbb9,0x67efd2,
        0x67e3ed,0x67d80a,0x67cc28,0x67c048,0x67b46a,0x67a88e,0x679cb4,0x6790dc,
        0x678505,0x677930,0x676d5d,0x67618c,0x6755bd,0x6749ef,0x673e23,0x673259,
        0x672691,0x671acb,0x670f06,0x670343,0x66f782,0x66ebc3,0x66e006,0x66d44a,
        0x66c891,0x66bcd8,0x66b122,0x66a56e,0x6699bb,0x668e0a,0x66825b,0x6676ae,
        0x666b02,0x665f58,0x6653b0,0x66480a,0x663c66,0x6630c3,0x662522,0x661983,
        0x660de5,0x66024a,0x65f6b0,0x65eb17,0x65df81,0x65d3ec,0x65c859,0x65bcc8,
        0x65b139,0x65a5ab,0x659a1f,0x658e95,0x65830d,0x657786,0x656c01,0x65607e,
        0x6554fc,0x65497c,0x653dfe,0x653282,0x652707,0x651b8e,0x651017,0x6504a2,
        0x64f92e,0x64edbc,0x64e24c,0x64d6dd,0x64cb70,0x64c005,0x64b49c,0x64a934,
        0x649dce,0x64926a,0x648707,0x647ba6,0x647047,0x6464ea,0x64598e,0x644e34,
        0x6442db,0x643784,0x642c2f,0x6420dc,0x64158a,0x640a3a,0x63feec,0x63f39f,
        0x63e854,0x63dd0b,0x63d1c3,0x63c67d,0x63bb39,0x63aff7,0x63a4b6,0x639976,
        0x638e39,0x6382fd,0x6377c3,0x636c8a,0x636153,0x63561e,0x634aea,0x633fb8,
        0x633488,0x632959,0x631e2c,0x631301,0x6307d7,0x62fcaf,0x62f189,0x62e664,
        0x62db41,0x62d01f,0x62c500,0x62b9e1,0x62aec5,0x62a3aa,0x629890,0x628d79,
        0x628263,0x62774e,0x626c3b,0x62612a,0x62561b,0x624b0d,0x624000,0x6234f6,
        0x6229ed,0x621ee5,0x6213df,0x6208db,0x61fdd8,0x61f2d7,0x61e7d8,0x61dcda,
        0x61d1de,0x61c6e3,0x61bbea,0x61b0f3,0x61a5fd,0x619b09,0x619016,0x618525,
        0x617a36,0x616f48,0x61645b,0x615971,0x614e88,0x6143a0,0x6138ba,0x612dd6,
        0x6122f3,0x611812,0x610d32,0x610254,0x60f778,0x60ec9d,0x60e1c4,0x60d6ec,
        0x60cc16,0x60c141,0x60b66e,0x60ab9c,0x60a0cc,0x6095fe,0x608b31,0x608066,
        0x60759c,0x606ad4,0x60600e,0x605549,0x604a85,0x603fc3,0x603503,0x602a44,
        0x601f87,0x6014cb,0x600a11,0x5fff58,0x5ff4a1,0x5fe9eb,0x5fdf37,0x5fd485,
        0x5fc9d4,0x5fbf24,0x5fb476,0x5fa9ca,0x5f9f1f,0x5f9476,0x5f89ce,0x5f7f28,
        0x5f7483,0x5f69df,0x5f5f3e,0x5f549d,0x5f49ff,0x5f3f62,0x5f34c6,0x5f2a2c,
        0x5f1f93,0x5f14fc,0x5f0a66,0x5effd2,0x5ef53f,0x5eeaae,0x5ee01f,0x5ed591,
        0x5ecb04,0x5ec079,0x5eb5ef,0x5eab67,0x5ea0e0,0x5e965b,0x5e8bd8,0x5e8155,
        0x5e76d5,0x5e6c55,0x5e61d8,0x5e575c,0x5e4ce1,0x5e4268,0x5e37f0,0x5e2d79,
        0x5e2305,0x5e1891,0x5e0e1f,0x5e03af,0x5df940,0x5deed3,0x5de467,0x5dd9fc,
        0x5dcf93,0x5dc52b,0x5dbac5,0x5db061,0x5da5fd,0x5d9b9c,0x5d913b,0x5d86dc,
        0x5d7c7f,0x5d7223,0x5d67c9,0x5d5d70,0x5d5318,0x5d48c2,0x5d3e6d,0x5d341a,
        0x5d29c8,0x5d1f78,0x5d1529,0x5d0adc,0x5d0090,0x5cf645,0x5cebfc,0x5ce1b4,
        0x5cd76e,0x5ccd29,0x5cc2e6,0x5cb8a4,0x5cae63,0x5ca424,0x5c99e6,0x5c8faa,
        0x5c856f,0x5c7b36,0x5c70fe,0x5c66c7,0x5c5c92,0x5c525e,0x5c482c,0x5c3dfb,
        0x5c33cc,0x5c299d,0x5c1f71,0x5c1546,0x5c0b1c,0x5c00f3,0x5bf6cc,0x5beca7,
        0x5be282,0x5bd85f,0x5bce3e,0x5bc41e,0x5bb9ff,0x5bafe2,0x5ba5c6,0x5b9bac,
        0x5b9193,0x5b877b,0x5b7d65,0x5b7350,0x5b693d,0x5b5f2a,0x5b551a,0x5b4b0a,
        0x5b40fd,0x5b36f0,0x5b2ce5,0x5b22db,0x5b18d3,0x5b0ecc,0x5b04c6,0x5afac2,
        0x5af0bf,0x5ae6bd,0x5adcbd,0x5ad2be,0x5ac8c1,0x5abec5,0x5ab4ca,0x5aaad1,
        0x5aa0d9,0x5a96e2,0x5a8ced,0x5a82f9,0x5a7906,0x5a6f15,0x5a6525,0x5a5b37,
        0x5a514a,0x5a475e,0x5a3d74,0x5a338b,0x5a29a3,0x5a1fbd,0x5a15d8,0x5a0bf4,
        0x5a0212,0x59f831,0x59ee51,0x59e473,0x59da96,0x59d0ba,0x59c6e0,0x59bd07,
        0x59b330,0x59a959,0x599f84,0x5995b1,0x598bde,0x59820e,0x59783e,0x596e70,
        0x5964a3,0x595ad7,0x59510d,0x594744,0x593d7c,0x5933b6,0x5929f1,0x59202d,
        0x59166b,0x590caa,0x5902ea,0x58f92b,0x58ef6e,0x58e5b3,0x58dbf8,0x58d23f,
        0x58c887,0x58bed0,0x58b51b,0x58ab67,0x58a1b4,0x589803,0x588e53,0x5884a4,
        0x587af7,0x58714b,0x5867a0,0x585df6,0x58544e,0x584aa7,0x584101,0x58375d,
        0x582dba,0x582418,0x581a77,0x5810d8,0x58073a,0x57fd9d,0x57f402,0x57ea68,
        0x57e0cf,0x57d737,0x57cda1,0x57c40c,0x57ba78,0x57b0e6,0x57a754,0x579dc5,
        0x579436,0x578aa9,0x57811c,0x577792,0x576e08,0x576480,0x575af9,0x575173,
        0x5747ee,0x573e6b,0x5734e9,0x572b68,0x5721e9,0x57186b,0x570eee,0x570572,
        0x56fbf8,0x56f27e,0x56e906,0x56df90,0x56d61a,0x56cca6,0x56c333,0x56b9c1,
        0x56b051,0x56a6e2,0x569d74,0x569407,0x568a9b,0x568131,0x5677c8,0x566e60,
        0x5664fa,0x565b95,0x565231,0x5648ce,0x563f6c,0x56360c,0x562cad,0x56234f,
        0x5619f2,0x561097,0x56073c,0x55fde3,0x55f48c,0x55eb35,0x55e1e0,0x55d88c,
        0x55cf39,0x55c5e7,0x55bc97,0x55b347,0x55a9f9,0x55a0ad,0x559761,0x558e17,
        0x5584cd,0x557b86,0x55723f,0x5568f9,0x555fb5,0x555672,0x554d30,0x5543ef,
        0x553ab0,0x553171,0x552834,0x551ef8,0x5515be,0x550c84,0x55034c,0x54fa15,
        0x54f0df,0x54e7aa,0x54de77,0x54d544,0x54cc13,0x54c2e3,0x54b9b4,0x54b087,
        0x54a75a,0x549e2f,0x549505,0x548bdc,0x5482b5,0x54798e,0x547069,0x546745,
        0x545e22,0x545500,0x544be0,0x5442c0,0x5439a2,0x543085,0x542769,0x541e4f,
        0x541535,0x540c1d,0x540306,0x53f9f0,0x53f0db,0x53e7c7,0x53deb5,0x53d5a3,
        0x53cc93,0x53c384,0x53ba76,0x53b169,0x53a85e,0x539f54,0x53964a,0x538d42,
        0x53843b,0x537b36,0x537231,0x53692e,0x53602b,0x53572a,0x534e2a,0x53452b,
        0x533c2e,0x533331,0x532a36,0x53213b,0x531842,0x530f4a,0x530654,0x52fd5e,
        0x52f469,0x52eb76,0x52e284,0x52d993,0x52d0a3,0x52c7b4,0x52bec6,0x52b5d9,
        0x52acee,0x52a404,0x529b1b,0x529233,0x52894c,0x528066,0x527781,0x526e9e,
        0x5265bb,0x525cda,0x5253fa,0x524b1b,0x52423d,0x523960,0x523084,0x5227aa,
        0x521ed0,0x5215f8,0x520d21,0x52044b,0x51fb76,0x51f2a2,0x51e9cf,0x51e0fe,
        0x51d82d,0x51cf5e,0x51c68f,0x51bdc2,0x51b4f6,0x51ac2b,0x51a361,0x519a98,
        0x5191d1,0x51890a,0x518045,0x517780,0x516ebd,0x5165fb,0x515d3a,0x51547a,
        0x514bbb,0x5142fd,0x513a41,0x513185,0x5128cb,0x512011,0x511759,0x510ea2,
        0x5105ec,0x50fd36,0x50f483,0x50ebd0,0x50e31e,0x50da6d,0x50d1be,0x50c90f,
        0x50c062,0x50b7b5,0x50af0a,0x50a660,0x509db7,0x50950f,0x508c68,0x5083c2,
        0x507b1d,0x507279,0x5069d7,0x506135,0x505894,0x504ff5,0x504757,0x503eb9,
        0x50361d,0x502d82,0x5024e8,0x501c4f,0x5013b7,0x500b20,0x50028a,0x4ff9f5,
        0x4ff162,0x4fe8cf,0x4fe03d,0x4fd7ad,0x4fcf1d,0x4fc68f,0x4fbe01,0x4fb575,
        0x4facea,0x4fa460,0x4f9bd7,0x4f934e,0x4f8ac7,0x4f8241,0x4f79bc,0x4f7139,
        0x4f68b6,0x4f6034,0x4f57b3,0x4f4f33,0x4f46b5,0x4f3e37,0x4f35bb,0x4f2d3f,
        0x4f24c5,0x4f1c4b,0x4f13d3,0x4f0b5b,0x4f02e5,0x4efa70,0x4ef1fb,0x4ee988,
        0x4ee116,0x4ed8a5,0x4ed035,0x4ec7c6,0x4ebf58,0x4eb6ea,0x4eae7e,0x4ea613,
        0x4e9daa,0x4e9541,0x4e8cd9,0x4e8472,0x4e7c0c,0x4e73a7,0x4e6b43,0x4e62e1,
        0x4e5a7f,0x4e521e,0x4e49be,0x4e4160,0x4e3902,0x4e30a5,0x4e284a,0x4e1fef,
        0x4e1796,0x4e0f3d,0x4e06e5,0x4dfe8f,0x4df639,0x4dede5,0x4de591,0x4ddd3f,
        0x4dd4ed,0x4dcc9d,0x4dc44d,0x4dbbff,0x4db3b1,0x4dab65,0x4da319,0x4d9acf,
        0x4d9285,0x4d8a3d,0x4d81f5,0x4d79af,0x4d7169,0x4d6925,0x4d60e2,0x4d589f,
        0x4d505e,0x4d481d,0x4d3fde,0x4d379f,0x4d2f62,0x4d2725,0x4d1eea,0x4d16af,
        0x4d0e76,0x4d063d,0x4cfe05,0x4cf5cf,0x4ced99,0x4ce565,0x4cdd31,0x4cd4fe,
        0x4ccccd,0x4cc49c,0x4cbc6c,0x4cb43e,0x4cac10,0x4ca3e3,0x4c9bb8,0x4c938d,
        0x4c8b63,0x4c833a,0x4c7b12,0x4c72eb,0x4c6ac6,0x4c62a1,0x4c5a7d,0x4c525a,
        0x4c4a38,0x4c4217,0x4c39f7,0x4c31d7,0x4c29b9,0x4c219c,0x4c1980,0x4c1165,
        0x4c094b,0x4c0131,0x4bf919,0x4bf102,0x4be8eb,0x4be0d6,0x4bd8c1,0x4bd0ae,
        0x4bc89b,0x4bc089,0x4bb879,0x4bb069,0x4ba85a,0x4ba04d,0x4b9840,0x4b9034,
        0x4b8829,0x4b801f,0x4b7816,0x4b700e,0x4b6807,0x4b6001,0x4b57fc,0x4b4ff7,
        0x4b47f4,0x4b3ff2,0x4b37f0,0x4b2ff0,0x4b27f0,0x4b1ff2,0x4b17f4,0x4b0ff7,
        0x4b07fc,0x4b0001,0x4af807,0x4af00e,0x4ae816,0x4ae01f,0x4ad829,0x4ad034,
        0x4ac83f,0x4ac04c,0x4ab85a,0x4ab068,0x4aa878,0x4aa088,0x4a989a,0x4a90ac,
        0x4a88bf,0x4a80d3,0x4a78e8,0x4a70fe,0x4a6915,0x4a612d,0x4a5946,0x4a5160,
        0x4a497a,0x4a4196,0x4a39b2,0x4a31d0,0x4a29ee,0x4a220d,0x4a1a2d,0x4a124f,
        0x4a0a71,0x4a0294,0x49fab7,0x49f2dc,0x49eb02,0x49e328,0x49db50,0x49d378,
        0x49cba2,0x49c3cc,0x49bbf7,0x49b423,0x49ac50,0x49a47e,0x499cad,0x4994dd,
        0x498d0d,0x49853f,0x497d71,0x4975a5,0x496dd9,0x49660e,0x495e44,0x49567b,
        0x494eb3,0x4946ec,0x493f25,0x493760,0x492f9b,0x4927d8,0x492015,0x491853,
        0x491092,0x4908d2,0x490113,0x48f955,0x48f198,0x48e9db,0x48e21f,0x48da65,
        0x48d2ab,0x48caf2,0x48c33a,0x48bb83,0x48b3cd,0x48ac18,0x48a463,0x489cb0,
        0x4894fd,0x488d4b,0x48859a,0x487dea,0x48763b,0x486e8d,0x4866df,0x485f33,
        0x485787,0x484fdd,0x484833,0x48408a,0x4838e2,0x48313b,0x482994,0x4821ef,
        0x481a4a,0x4812a6,0x480b04,0x480362,0x47fbc1,0x47f420,0x47ec81,0x47e4e3,
        0x47dd45,0x47d5a8,0x47ce0c,0x47c672,0x47bed7,0x47b73e,0x47afa6,0x47a80e,
        0x47a078,0x4798e2,0x47914d,0x4789b9,0x478226,0x477a93,0x477302,0x476b71,
        0x4763e2,0x475c53,0x4754c5,0x474d37,0x4745ab,0x473e20,0x473695,0x472f0b,
        0x472783,0x471ffa,0x471873,0x4710ed,0x470968,0x4701e3,0x46fa5f,0x46f2dc,
        0x46eb5a,0x46e3d9,0x46dc59,0x46d4d9,0x46cd5a,0x46c5dd,0x46be60,0x46b6e4,
        0x46af68,0x46a7ee,0x46a074,0x4698fb,0x469184,0x468a0c,0x468296,0x467b21,
        0x4673ac,0x466c39,0x4664c6,0x465d54,0x4655e3,0x464e72,0x464703,0x463f94,
        0x463826,0x4630b9,0x46294d,0x4621e2,0x461a77,0x46130e,0x460ba5,0x46043d,
        0x45fcd6,0x45f56f,0x45ee0a,0x45e6a5,0x45df41,0x45d7de,0x45d07c,0x45c91a,
        0x45c1ba,0x45ba5a,0x45b2fb,0x45ab9d,0x45a440,0x459ce4,0x459588,0x458e2d,
        0x4586d3,0x457f7a,0x457822,0x4570ca,0x456974,0x45621e,0x455ac9,0x455374,
        0x454c21,0x4544ce,0x453d7d,0x45362c,0x452edb,0x45278c,0x45203e,0x4518f0,
        0x4511a3,0x450a57,0x45030c,0x44fbc1,0x44f477,0x44ed2e,0x44e5e6,0x44de9f,
        0x44d759,0x44d013,0x44c8ce,0x44c18a,0x44ba47,0x44b305,0x44abc3,0x44a482,
        0x449d42,0x449603,0x448ec5,0x448787,0x44804a,0x44790e,0x4471d3,0x446a99,
        0x44635f,0x445c26,0x4454ee,0x444db7,0x444681,0x443f4b,0x443816,0x4430e2,
        0x4429af,0x44227c,0x441b4b,0x44141a,0x440cea,0x4405ba,0x43fe8c,0x43f75e,
        0x43f031,0x43e905,0x43e1da,0x43daaf,0x43d385,0x43cc5c,0x43c534,0x43be0d,
        0x43b6e6,0x43afc0,0x43a89b,0x43a177,0x439a54,0x439331,0x438c0f,0x4384ee,
        0x437dcd,0x4376ae,0x436f8f,0x436871,0x436154,0x435a37,0x43531b,0x434c00,
        0x4344e6,0x433dcd,0x4336b4,0x432f9c,0x432885,0x43216f,0x431a5a,0x431345,
        0x430c31,0x43051e,0x42fe0b,0x42f6f9,0x42efe9,0x42e8d8,0x42e1c9,0x42daba,
        0x42d3ad,0x42cca0,0x42c593,0x42be88,0x42b77d,0x42b073,0x42a96a,0x42a261,
        0x429b59,0x429452,0x428d4c,0x428647,0x427f42,0x42783e,0x42713b,0x426a39,
        0x426337,0x425c36,0x425536,0x424e37,0x424738,0x42403a,0x42393d,0x423241,
        0x422b45,0x42244a,0x421d50,0x421657,0x420f5e,0x420866,0x42016f,0x41fa79,
        0x41f383,0x41ec8e,0x41e59a,0x41dea7,0x41d7b4,0x41d0c2,0x41c9d1,0x41c2e1,
        0x41bbf1,0x41b503,0x41ae14,0x41a727,0x41a03a,0x41994e,0x419263,0x418b79,
        0x41848f,0x417da6,0x4176be,0x416fd7,0x4168f0,0x41620a,0x415b25,0x415440,
        0x414d5c,0x414679,0x413f97,0x4138b6,0x4131d5,0x412af5,0x412415,0x411d37,
        0x411659,0x410f7c,0x41089f,0x4101c3,0x40fae9,0x40f40e,0x40ed35,0x40e65c,
        0x40df84,0x40d8ad,0x40d1d6,0x40cb00,0x40c42b,0x40bd57,0x40b683,0x40afb0,
        0x40a8de,0x40a20c,0x409b3b,0x40946b,0x408d9c,0x4086cd,0x408000,0x407932,
        0x407266,0x406b9a,0x4064cf,0x405e05,0x40573b,0x405072,0x4049aa,0x4042e3,
        0x403c1c,0x403556,0x402e91,0x4027cc,0x402109,0x401a45,0x401383,0x400cc1,
        0x400600,0x3fff40,0x3ff880,0x3ff1c2,0x3feb03,0x3fe446,0x3fdd89,0x3fd6cd,
        0x3fd012,0x3fc957,0x3fc29d,0x3fbbe4,0x3fb52c,0x3fae74,0x3fa7bd,0x3fa107,
        0x3f9a51,0x3f939c,0x3f8ce8,0x3f8634,0x3f7f81,0x3f78cf,0x3f721e,0x3f6b6d,
        0x3f64bd,0x3f5e0e,0x3f575f,0x3f50b1,0x3f4a04,0x3f4357,0x3f3cac,0x3f3601,
        0x3f2f56,0x3f28ac,0x3f2203,0x3f1b5b,0x3f14b3,0x3f0e0c,0x3f0766,0x3f00c1,
        0x3efa1c,0x3ef377,0x3eecd4,0x3ee631,0x3edf8f,0x3ed8ee,0x3ed24d,0x3ecbad,
        0x3ec50e,0x3ebe6f,0x3eb7d1,0x3eb134,0x3eaa97,0x3ea3fb,0x3e9d60,0x3e96c6,
        0x3e902c,0x3e8993,0x3e82fa,0x3e7c62,0x3e75cb,0x3e6f35,0x3e689f,0x3e620a,
        0x3e5b76,0x3e54e2,0x3e4e4f,0x3e47bd,0x3e412b,0x3e3a9a,0x3e340a,0x3e2d7a,
        0x3e26eb,0x3e205d,0x3e19cf,0x3e1342,0x3e0cb6,0x3e062b,0x3dffa0,0x3df916,
        0x3df28c,0x3dec03,0x3de57b,0x3ddef4,0x3dd86d,0x3dd1e7,0x3dcb61,0x3dc4dc,
        0x3dbe58,0x3db7d5,0x3db152,0x3daad0,0x3da44f,0x3d9dce,0x3d974e,0x3d90ce,
        0x3d8a4f,0x3d83d1,0x3d7d54,0x3d76d7,0x3d705b,0x3d69e0,0x3d6365,0x3d5ceb,
        0x3d5671,0x3d4ff9,0x3d4980,0x3d4309,0x3d3c92,0x3d361c,0x3d2fa7,0x3d2932,
        0x3d22be,0x3d1c4a,0x3d15d7,0x3d0f65,0x3d08f4,0x3d0283,0x3cfc13,0x3cf5a3,
        0x3cef34,0x3ce8c6,0x3ce259,0x3cdbec,0x3cd57f,0x3ccf14,0x3cc8a9,0x3cc23f,
        0x3cbbd5,0x3cb56c,0x3caf04,0x3ca89c,0x3ca235,0x3c9bcf,0x3c9569,0x3c8f04,
        0x3c889f,0x3c823c,0x3c7bd8,0x3c7576,0x3c6f14,0x3c68b3,0x3c6253,0x3c5bf3,
        0x3c5593,0x3c4f35,0x3c48d7,0x3c427a,0x3c3c1d,0x3c35c1,0x3c2f66,0x3c290b,
        0x3c22b1,0x3c1c57,0x3c15ff,0x3c0fa7,0x3c094f,0x3c02f8,0x3bfca2,0x3bf64c,
        0x3beff7,0x3be9a3,0x3be34f,0x3bdcfc,0x3bd6aa,0x3bd058,0x3bca07,0x3bc3b7,
        0x3bbd67,0x3bb718,0x3bb0c9,0x3baa7b,0x3ba42e,0x3b9de1,0x3b9795,0x3b914a,
        0x3b8aff,0x3b84b5,0x3b7e6c,0x3b7823,0x3b71db,0x3b6b93,0x3b654c,0x3b5f06,
        0x3b58c0,0x3b527b,0x3b4c36,0x3b45f3,0x3b3faf,0x3b396d,0x3b332b,0x3b2cea,
        0x3b26a9,0x3b2069,0x3b1a2a,0x3b13eb,0x3b0dad,0x3b076f,0x3b0132,0x3afaf6,
        0x3af4ba,0x3aee7f,0x3ae845,0x3ae20b,0x3adbd2,0x3ad599,0x3acf61,0x3ac92a,
        0x3ac2f3,0x3abcbd,0x3ab688,0x3ab053,0x3aaa1f,0x3aa3eb,0x3a9db8,0x3a9786,
        0x3a9154,0x3a8b23,0x3a84f2,0x3a7ec2,0x3a7893,0x3a7264,0x3a6c36,0x3a6609,
        0x3a5fdc,0x3a59b0,0x3a5384,0x3a4d59,0x3a472f,0x3a4105,0x3a3adc,0x3a34b4,
        0x3a2e8c,0x3a2864,0x3a223e,0x3a1c18,0x3a15f2,0x3a0fcd,0x3a09a9,0x3a0385,
        0x39fd62,0x39f740,0x39f11e,0x39eafd,0x39e4dc,0x39debc,0x39d89d,0x39d27e,
        0x39cc60,0x39c642,0x39c025,0x39ba09,0x39b3ed,0x39add2,0x39a7b7,0x39a19d,
        0x399b84,0x39956b,0x398f53,0x39893b,0x398324,0x397d0e,0x3976f8,0x3970e3,
        0x396ace,0x3964ba,0x395ea7,0x395894,0x395282,0x394c70,0x39465f,0x39404f,
        0x393a3f,0x393430,0x392e21,0x392813,0x392206,0x391bf9,0x3915ed,0x390fe1,
        0x3909d6,0x3903cb,0x38fdc1,0x38f7b8,0x38f1af,0x38eba7,0x38e5a0,0x38df99,
        0x38d993,0x38d38d,0x38cd88,0x38c783,0x38c17f,0x38bb7c,0x38b579,0x38af77,
        0x38a975,0x38a374,0x389d73,0x389774,0x389174,0x388b76,0x388577,0x387f7a,
        0x38797d,0x387381,0x386d85,0x38678a,0x38618f,0x385b95,0x38559b,0x384fa2,
        0x3849aa,0x3843b2,0x383dbb,0x3837c5,0x3831cf,0x382bd9,0x3825e4,0x381ff0,
        0x3819fd,0x381409,0x380e17,0x380825,0x380234,0x37fc43,0x37f653,0x37f063,
        0x37ea74,0x37e485,0x37de97,0x37d8aa,0x37d2bd,0x37ccd1,0x37c6e5,0x37c0fa,
        0x37bb10,0x37b526,0x37af3d,0x37a954,0x37a36c,0x379d84,0x37979d,0x3791b6,
        0x378bd0,0x3785eb,0x378006,0x377a22,0x37743e,0x376e5b,0x376879,0x376297,
        0x375cb5,0x3756d5,0x3750f4,0x374b15,0x374535,0x373f57,0x373979,0x37339b,
        0x372dbf,0x3727e2,0x372206,0x371c2b,0x371651,0x371077,0x370a9d,0x3704c4,
        0x36feec,0x36f914,0x36f33d,0x36ed66,0x36e790,0x36e1ba,0x36dbe5,0x36d611,
        0x36d03d,0x36ca69,0x36c497,0x36bec4,0x36b8f3,0x36b321,0x36ad51,0x36a781,
        0x36a1b1,0x369be2,0x369614,0x369046,0x368a79,0x3684ac,0x367ee0,0x367915,
        0x36734a,0x366d7f,0x3667b5,0x3661ec,0x365c23,0x36565b,0x365093,0x364acc,
        0x364505,0x363f3f,0x363979,0x3633b4,0x362df0,0x36282c,0x362269,0x361ca6,
        0x3616e4,0x361122,0x360b61,0x3605a0,0x35ffe0,0x35fa20,0x35f461,0x35eea3,
        0x35e8e5,0x35e328,0x35dd6b,0x35d7af,0x35d1f3,0x35cc38,0x35c67d,0x35c0c3,
        0x35bb09,0x35b550,0x35af98,0x35a9e0,0x35a429,0x359e72,0x3598bb,0x359306,
        0x358d50,0x35879c,0x3581e8,0x357c34,0x357681,0x3570ce,0x356b1c,0x35656b,
        0x355fba,0x355a09,0x355459,0x354eaa,0x3548fb,0x35434d,0x353d9f,0x3537f2,
        0x353245,0x352c99,0x3526ee,0x352143,0x351b98,0x3515ee,0x351045,0x350a9c  
    }
};



/* Shortcuts so we dont have to bother with the structure in C */

/* Pointer to exponential table */
const unsigned int *
gmx_invsqrt_exptab   = F77_FUNC(gmxinvsqrtdata,GMXINVSQRTDATA).exptab;

/* Pointer to fraction table */
const unsigned int *
gmx_invsqrt_fracttab = F77_FUNC(gmxinvsqrtdata,GMXINVSQRTDATA).fracttab;

