#!/bin/sh -
input=$1;
kind=$2
xmethod=$3
ymethod=$4

# usage
# ../tools/scatter.sh validation-proof+null-null+pd-null.scat proven null+null ev+null

base=`basename $input .scat`
output="$base.eps"
every="";
if [ $kind = "disproven" ]; then
  every="every 2";
fi

title="$kind positions"
xlabel_uniq="unique nodes ($xmethod)"
ylabel_uniq="unique nodes ($ymethod)"
xlabel_cycles="cycles ($xmethod)"
ylabel_cycles="cycles ($ymethod)"
gnuplot <<EOF
set key left top
set term postscript eps 22
set out 'uniq-$output'
set logscale xy
set xlabel '$xlabel_uniq'
set ylabel '$ylabel_uniq'
plot '$input' $every using 1:2 t '$title', x t 'y=x'
set out 'cycles-$output'
set xlabel '$xlabel_cycles'
set ylabel '$ylabel_cycles'
plot '$input' $every using 5:6 t '$title', x t 'y=x'
EOF
