/* analyze_check_result.h
 */
#ifndef _ANALYZE_CHECK_RESULT_H
#define _ANALYZE_CHECK_RESULT_H

#include "osl/checkmate/checkHashRecord.h"
#include <iostream>
#include <iomanip>
namespace osl
{
  namespace checkmate
  {
    enum ResultType { PROOF=0, DISPROOF=1, UNKNOWN=2, INVALID=3 };
    void output_property(int proof, int disproof, std::ostream& os) 
    {
      os << std::setw(7) << proof << " "  << std::setw(7) << disproof
	 << "  ";
    }
    void output_invalid(std::ostream& os) 
    {
      output_property(-1, -1, os);
    }
    void analyze_check_result(bool is_checkmate, const CheckHashRecord *record,
			      const PathEncoding& path,
			      const TwinTable& table,
			      unsigned int node_limit, std::ostream& os)
    {
      if (is_checkmate)
      {
	output_property(1, node_limit, os);
      }
      else
      {
	if (record->proofDisproof().isCheckmateFail() 
	    || record->findLoop(path, table))
	{
	  output_property(node_limit, 1, os);
	}
	else
	{
	  output_property(std::min(node_limit, record->proof()), 
			  std::min(node_limit, record->disproof()), 
			  os);
	}
      }
    }
  } // namespace checkmate
} // namespace osl

#endif /* _ANALYZE_CHECK_RESULT_H */
// ;;; Local Variables:
// ;;; mode:c++
// ;;; c-basic-offset:2
// ;;; End:
