/* $Id: linuxprocfs.h,v 1.7 2000/09/29 10:15:37 bergo Exp $ */

/* Process/CPU/Memory/etc. polling via Linux's /proc fs */

#include "transient.h"

#ifdef HAVELINUXPROCFS

#ifndef LINUXPROCFS_H
#define LINUXPROCFS_H

#include "polling.h"
#include "tstring.h"

/// helper class for Linux /proc poller. should be struct. no methods.
class dpair {
 public:
  gint number;
  char name[64];
};

/// process list polling via Linux /proc.
class LinuxProcFsProcessListPoller : public ProcessListPoller {
 public:
  /// trivial constructor
  LinuxProcFsProcessListPoller();
  /// destructor
  ~LinuxProcFsProcessListPoller();
  /// actual polling done here
  void poll();
 private:
  TString *t;
};

/// process details via Linux /proc.
class LinuxProcFsProcessDetailsPoller : public ProcessDetailsPoller {
 public:
  /// trivial constructor
  LinuxProcFsProcessDetailsPoller();
  /// actual polling done here
  void poll(int whichpid);

 private:
  void init_device_list();
  void get_tty_name(int ttycode,char *dest);
  void parse_process_flags(unsigned long flags,char *dest);
  gint sigindex(gint val);
  char *get_signal_string(unsigned long sigs);

  GList *sdevs;
};

/// system information via Linux /proc.
class LinuxProcFsSystemInfoProvider : public SystemInfoProvider {
 public:
  /// trivial constructor.
  LinuxProcFsSystemInfoProvider();

  /// actual gathering done here.
  void update();

 private:
  void countCpus();

  void update_cpu();
  void update_memory();
  long last_busy,last_idle;

  // same thing, SMP
  long lbusy[64],lidle[64];
};

/* these lines copied from /usr/include/linux/sched.h of kernel 2.2.3 */

#define PF_ALIGNWARN    0x00000001     /* Print alignment warning msgs */
                                       /* Not implemented yet, only for 486*/
#define PF_STARTING     0x00000002     /* being created */
#define PF_EXITING      0x00000004     /* getting shut down */
#define PF_PTRACED      0x00000010     /* set if ptrace (0) has been called */
#define PF_TRACESYS     0x00000020     /* tracing system calls */
#define PF_FORKNOEXEC   0x00000040     /* forked but didn't exec */
#define PF_SUPERPRIV    0x00000100     /* used super-user privileges */
#define PF_DUMPCORE     0x00000200     /* dumped core */
#define PF_SIGNALED     0x00000400     /* killed by a signal */
#define PF_MEMALLOC     0x00000800     /* Allocating memory */
#define PF_VFORK        0x00001000     /* Wake up parent in mm_release */

#define PF_USEDFPU      0x00100000     /* task used FPU this quantum (SMP) */
#define PF_DTRACE       0x00200000     /* delayed trace (used on m68k, i386) */

/* end inclusion */

#endif

#endif /* HAVELINUXPROCFS */
