/* -*- Mode: C; tab-width: 4; indent-tabs-mode: t; c-basic-offset: 4 -*- */
/*
    Gpredict: Real-time satellite tracking and orbit prediction program

    Copyright (C)  2001-2006  Alexandru Csete, OZ9AEC.

    Authors: Alexandru Csete <csete@users.sourceforge.net>

    Comments, questions and bugreports should be submitted via
    http://sourceforge.net/projects/groundstation/
    More details can be found at the project home page:

            http://groundstation.sourceforge.net/
 
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
  
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
  
    You should have received a copy of the GNU General Public License
    along with this program; if not, visit http://www.fsf.org/
*/
#include <gtk/gtk.h>
#include <glib/gi18n.h>
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include "sat-log.h"
#include "sat-cfg.h"
#include "sat-pref-help.h"
#include "gpredict-help.h"


extern sat_help_t sat_help[]; /* in sat-pref-help.c */
extern GtkWidget *app;


static gint config_help (void);


/** \brief Launch help system.
 *
 */
void
gpredict_help_launch (gpredict_help_type_t type)
{
	browser_type_t idx;
	gint           resp;


	idx = sat_cfg_get_int (SAT_CFG_INT_WEB_BROWSER_TYPE);

	/* some sanity check before accessing the arrays ;-) */
	if ((idx < BROWSER_TYPE_NONE) || (idx >= BROWSER_TYPE_NUM)) {
		idx = BROWSER_TYPE_NONE;
	}

	if (idx == BROWSER_TYPE_NONE) {
		sat_log_log (SAT_LOG_LEVEL_MSG,
			     _("%s: Help browser is not set up yet."),
			     __FUNCTION__);

		resp = config_help ();

		if (resp == GTK_RESPONSE_CANCEL) {
			sat_log_log (SAT_LOG_LEVEL_MSG,
				     _("%s: Configure help browser cancelled."),
				     __FUNCTION__);

			return;
		}

		/* else try again */
		idx = sat_cfg_get_int (SAT_CFG_INT_WEB_BROWSER_TYPE);		
	}

	if ((idx <= BROWSER_TYPE_NONE) || (idx >= BROWSER_TYPE_NUM)) {
		return;
	}

	/* launch help browser */
	sat_log_log (SAT_LOG_LEVEL_DEBUG,
		     _("%s: Launching help browser %s."),
		     __FUNCTION__, sat_help[idx].type);

	g_print ("FIXME: FINSH IMPELMTATION\n");
}



/** \brief Configure help system.
 *  \return GTK_RESPONSE_OK if the help browser has been set up or
 *          GTK_RESPONSE_CANCEL if the user has cancelled the action.
 *
 * This function is called if the user wants to see the online
 * help but has not yet configured a help browser. The function
 * will create a dialog containing the same cfg widget as in sat-pref-help
 * and allow the user to configure the html browser.
 */
static gint
config_help (void)
{
	GtkWidget *dialog;
	GtkWidget *label;
	gint resp;


	dialog = gtk_dialog_new_with_buttons (_("Configure Help Browser"),
					      GTK_WINDOW (app),
					      GTK_DIALOG_MODAL |
					      GTK_DIALOG_DESTROY_WITH_PARENT,
					      GTK_STOCK_CANCEL,
					      GTK_RESPONSE_CANCEL,
					      GTK_STOCK_OK,
					      GTK_RESPONSE_OK,
					      NULL);

	label = gtk_label_new (_("Please select a HTML browser to be used to view the help."));
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox), label, FALSE, TRUE, 0);
	gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog)->vbox),
			    sat_pref_help_create (), TRUE, FALSE, 0);

	gtk_widget_show_all (GTK_DIALOG (dialog)->vbox);

	resp = gtk_dialog_run (GTK_DIALOG (dialog));

	switch (resp) {

		/* save browser settings */
	case GTK_RESPONSE_OK:
		sat_pref_help_ok ();
		break;
		
	default:
		sat_pref_help_cancel ();
		break;
	}

	gtk_widget_destroy (dialog);

	return resp;
}
