/* 3ds.c generated by valac 0.12.0, the Vala compiler
 * generated from 3ds.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <GL/gl.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define TYPE_TDS_MODEL (tds_model_get_type ())
#define TDS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TDS_MODEL, TDSModel))
#define TDS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TDS_MODEL, TDSModelClass))
#define IS_TDS_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TDS_MODEL))
#define IS_TDS_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TDS_MODEL))
#define TDS_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TDS_MODEL, TDSModelClass))

typedef struct _TDSModel TDSModel;
typedef struct _TDSModelClass TDSModelClass;
typedef struct _TDSModelPrivate TDSModelPrivate;
#define _tds_model_unref0(var) ((var == NULL) ? NULL : (var = (tds_model_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _ParamSpecTDSModel ParamSpecTDSModel;

struct _TDSModel {
	GTypeInstance parent_instance;
	volatile int ref_count;
	TDSModelPrivate * priv;
};

struct _TDSModelClass {
	GTypeClass parent_class;
	void (*finalize) (TDSModel *self);
};

struct _TDSModelPrivate {
	GLfloat min_height;
	GLfloat max_height;
	GLfloat* vertices;
	gint vertices_length1;
	gint _vertices_size_;
	GLushort* triangles;
	gint triangles_length1;
	gint _triangles_size_;
	GLfloat* normals;
	gint normals_length1;
	gint _normals_size_;
	GLfloat* texture_coords;
	gint texture_coords_length1;
	gint _texture_coords_size_;
};

struct _ParamSpecTDSModel {
	GParamSpec parent_instance;
};


static gpointer tds_model_parent_class = NULL;

gpointer tds_model_ref (gpointer instance);
void tds_model_unref (gpointer instance);
GParamSpec* param_spec_tds_model (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_tds_model (GValue* value, gpointer v_object);
void value_take_tds_model (GValue* value, gpointer v_object);
gpointer value_get_tds_model (const GValue* value);
GType tds_model_get_type (void) G_GNUC_CONST;
#define TDS_MODEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TDS_MODEL, TDSModelPrivate))
enum  {
	TDS_MODEL_DUMMY_PROPERTY
};
TDSModel* tds_model_new (GFile* file, GError** error);
TDSModel* tds_model_construct (GType object_type, GFile* file, GError** error);
static void tds_model_parse_block (TDSModel* self, GFileInputStream* stream, gint64 length, GError** error);
static guint16 tds_model_read_uint16 (TDSModel* self, GInputStream* stream, GError** error);
static guint32 tds_model_read_uint32 (TDSModel* self, GInputStream* stream, GError** error);
static gchar* tds_model_read_string (TDSModel* self, GInputStream* stream, GError** error);
static gfloat tds_model_read_float (TDSModel* self, GInputStream* stream, GError** error);
static guint8 tds_model_read_uint8 (TDSModel* self, GInputStream* stream, GError** error);
void tds_model_render (TDSModel* self);
static gfloat* _vala_array_dup1 (gfloat* self, int length);
static void tds_model_finalize (TDSModel* obj);


TDSModel* tds_model_construct (GType object_type, GFile* file, GError** error) {
	TDSModel* self = NULL;
	GFileInputStream* _tmp0_ = NULL;
	GFileInputStream* stream;
	GFileInfo* _tmp1_ = NULL;
	GFileInfo* _tmp2_;
	gint64 _tmp3_;
	GLfloat* _tmp4_ = NULL;
	GLfloat* _tmp9_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (file != NULL, NULL);
	self = (TDSModel*) g_type_create_instance (object_type);
	_tmp0_ = g_file_read (file, NULL, &_inner_error_);
	stream = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_tds_model_unref0 (self);
		return NULL;
	}
	_tmp1_ = g_file_input_stream_query_info (stream, G_FILE_ATTRIBUTE_STANDARD_SIZE, NULL, &_inner_error_);
	_tmp2_ = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (stream);
		_tds_model_unref0 (self);
		return NULL;
	}
	_tmp3_ = g_file_info_get_size (_tmp2_);
	tds_model_parse_block (self, stream, _tmp3_, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (stream);
		_tds_model_unref0 (self);
		return NULL;
	}
	_tmp4_ = g_new0 (GLfloat, self->priv->vertices_length1);
	self->priv->normals = (g_free (self->priv->normals), NULL);
	self->priv->normals = _tmp4_;
	self->priv->normals_length1 = self->priv->vertices_length1;
	self->priv->_normals_size_ = self->priv->vertices_length1;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp5_;
			_tmp5_ = TRUE;
			while (TRUE) {
				if (!_tmp5_) {
					i++;
				}
				_tmp5_ = FALSE;
				if (!(i < self->priv->normals_length1)) {
					break;
				}
				self->priv->normals[i] = (GLfloat) 0.f;
			}
		}
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp6_;
			_tmp6_ = TRUE;
			while (TRUE) {
				gint v0;
				gint v1;
				gint v2;
				GLfloat a[3] = {0};
				GLfloat b[3] = {0};
				GLfloat normal[3] = {0};
				if (!_tmp6_) {
					i = i + 3;
				}
				_tmp6_ = FALSE;
				if (!(i < self->priv->triangles_length1)) {
					break;
				}
				v0 = self->priv->triangles[i] * 3;
				v1 = self->priv->triangles[i + 1] * 3;
				v2 = self->priv->triangles[i + 2] * 3;
				a[0] = self->priv->vertices[v1] - self->priv->vertices[v0];
				a[1] = self->priv->vertices[v1 + 1] - self->priv->vertices[v0 + 1];
				a[2] = self->priv->vertices[v1 + 2] - self->priv->vertices[v0 + 2];
				b[0] = self->priv->vertices[v2] - self->priv->vertices[v0];
				b[1] = self->priv->vertices[v2 + 1] - self->priv->vertices[v0 + 1];
				b[2] = self->priv->vertices[v2 + 2] - self->priv->vertices[v0 + 2];
				normal[0] = (a[1] * b[2]) - (a[2] * b[1]);
				normal[1] = (a[2] * b[0]) - (a[0] * b[2]);
				normal[2] = (a[0] * b[1]) - (a[1] * b[0]);
				self->priv->normals[v0] += normal[0];
				self->priv->normals[v0 + 1] += normal[1];
				self->priv->normals[v0 + 2] += normal[2];
				self->priv->normals[v1] += normal[0];
				self->priv->normals[v1 + 1] += normal[1];
				self->priv->normals[v1 + 2] += normal[2];
				self->priv->normals[v2] += normal[0];
				self->priv->normals[v2 + 1] += normal[1];
				self->priv->normals[v2 + 2] += normal[2];
			}
		}
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp7_;
			_tmp7_ = TRUE;
			while (TRUE) {
				gdouble _tmp8_;
				GLfloat length;
				if (!_tmp7_) {
					i = i + 3;
				}
				_tmp7_ = FALSE;
				if (!(i < self->priv->normals_length1)) {
					break;
				}
				_tmp8_ = sqrt ((gdouble) (((self->priv->normals[i] * self->priv->normals[i]) + (self->priv->normals[i + 1] * self->priv->normals[i + 1])) + (self->priv->normals[i + 2] * self->priv->normals[i + 2])));
				length = (GLfloat) _tmp8_;
				self->priv->normals[i] /= length;
				self->priv->normals[i + 1] /= length;
				self->priv->normals[i + 2] /= length;
			}
		}
	}
	_tmp9_ = g_new0 (GLfloat, (self->priv->vertices_length1 / 3) * 2);
	self->priv->texture_coords = (g_free (self->priv->texture_coords), NULL);
	self->priv->texture_coords = _tmp9_;
	self->priv->texture_coords_length1 = (self->priv->vertices_length1 / 3) * 2;
	self->priv->_texture_coords_size_ = (self->priv->vertices_length1 / 3) * 2;
	{
		gint i;
		gint j;
		i = 0;
		j = 0;
		{
			gboolean _tmp10_;
			_tmp10_ = TRUE;
			while (TRUE) {
				GLfloat u;
				GLfloat v;
				gdouble _tmp11_;
				GLfloat r;
				gfloat h;
				if (!_tmp10_) {
					i = i + 3;
					j = j + 2;
				}
				_tmp10_ = FALSE;
				if (!(i < self->priv->vertices_length1)) {
					break;
				}
				u = self->priv->vertices[i];
				v = self->priv->vertices[i + 2];
				_tmp11_ = sqrt ((gdouble) ((u * u) + (v * v)));
				r = (GLfloat) _tmp11_;
				if (r != 0) {
					u = u / r;
					v = v / r;
				}
				h = 1.0f - (self->priv->vertices[i + 1] / self->priv->max_height);
				self->priv->texture_coords[j] = (GLfloat) (0.5f + ((0.5f * h) * u));
				self->priv->texture_coords[j + 1] = (GLfloat) (0.5f + ((0.5f * h) * v));
			}
		}
	}
	_g_object_unref0 (stream);
	return self;
}


TDSModel* tds_model_new (GFile* file, GError** error) {
	return tds_model_construct (TYPE_TDS_MODEL, file, error);
}


static void tds_model_parse_block (TDSModel* self, GFileInputStream* stream, gint64 length, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (stream != NULL);
	while (TRUE) {
		guint16 _tmp0_;
		guint16 id;
		guint32 _tmp1_;
		gint64 block_length;
		if (!(length > 6)) {
			break;
		}
		_tmp0_ = tds_model_read_uint16 (self, (GInputStream*) stream, &_inner_error_);
		id = _tmp0_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		_tmp1_ = tds_model_read_uint32 (self, (GInputStream*) stream, &_inner_error_);
		block_length = (gint64) _tmp1_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		if (block_length < 6) {
			return;
		}
		if (block_length > length) {
			fprintf (stderr, "Overflow, need %lli octets for %04X, but only have %lli\n", block_length, (gint) id, length);
			return;
		}
		switch (id) {
			case 0x4D4D:
			{
				tds_model_parse_block (self, stream, block_length - 6, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					return;
				}
				break;
			}
			case 0x3D3D:
			{
				tds_model_parse_block (self, stream, block_length - 6, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					return;
				}
				break;
			}
			case 0x4000:
			{
				gchar* _tmp2_ = NULL;
				gchar* name;
				gint _tmp3_;
				_tmp2_ = tds_model_read_string (self, (GInputStream*) stream, &_inner_error_);
				name = _tmp2_;
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					return;
				}
				_tmp3_ = strlen (name);
				tds_model_parse_block (self, stream, (block_length - 6) - (_tmp3_ + 1), &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (name);
					return;
				}
				_g_free0 (name);
				break;
			}
			case 0x4100:
			{
				tds_model_parse_block (self, stream, block_length - 6, &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					return;
				}
				break;
			}
			case 0x4110:
			{
				guint16 _tmp4_;
				guint16 n;
				GLfloat* _tmp5_ = NULL;
				_tmp4_ = tds_model_read_uint16 (self, (GInputStream*) stream, &_inner_error_);
				n = _tmp4_;
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					return;
				}
				_tmp5_ = g_new0 (GLfloat, n * 3);
				self->priv->vertices = (g_free (self->priv->vertices), NULL);
				self->priv->vertices = _tmp5_;
				self->priv->vertices_length1 = n * 3;
				self->priv->_vertices_size_ = n * 3;
				{
					gint i;
					i = 0;
					{
						gboolean _tmp6_;
						_tmp6_ = TRUE;
						while (TRUE) {
							gfloat _tmp7_;
							gfloat x;
							gfloat _tmp8_;
							gfloat y;
							gfloat _tmp9_;
							gfloat z;
							gfloat scale;
							gfloat h;
							if (!_tmp6_) {
								i++;
							}
							_tmp6_ = FALSE;
							if (!(i < n)) {
								break;
							}
							_tmp7_ = tds_model_read_float (self, (GInputStream*) stream, &_inner_error_);
							x = _tmp7_;
							if (_inner_error_ != NULL) {
								g_propagate_error (error, _inner_error_);
								return;
							}
							_tmp8_ = tds_model_read_float (self, (GInputStream*) stream, &_inner_error_);
							y = _tmp8_;
							if (_inner_error_ != NULL) {
								g_propagate_error (error, _inner_error_);
								return;
							}
							_tmp9_ = tds_model_read_float (self, (GInputStream*) stream, &_inner_error_);
							z = _tmp9_;
							if (_inner_error_ != NULL) {
								g_propagate_error (error, _inner_error_);
								return;
							}
							scale = 3.5f;
							self->priv->vertices[i * 3] = (GLfloat) (scale * x);
							self->priv->vertices[(i * 3) + 1] = (GLfloat) (scale * z);
							self->priv->vertices[(i * 3) + 2] = (GLfloat) (scale * y);
							h = scale * z;
							if (h < self->priv->min_height) {
								self->priv->min_height = (GLfloat) h;
							}
							if (h > self->priv->max_height) {
								self->priv->max_height = (GLfloat) h;
							}
						}
					}
				}
				break;
			}
			case 0x4120:
			{
				guint16 _tmp10_;
				guint16 n;
				GLushort* _tmp11_ = NULL;
				if (block_length < 2) {
					return;
				}
				_tmp10_ = tds_model_read_uint16 (self, (GInputStream*) stream, &_inner_error_);
				n = _tmp10_;
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					return;
				}
				_tmp11_ = g_new0 (GLushort, n * 3);
				self->priv->triangles = (g_free (self->priv->triangles), NULL);
				self->priv->triangles = _tmp11_;
				self->priv->triangles_length1 = n * 3;
				self->priv->_triangles_size_ = n * 3;
				if (block_length < (2 + (n * 8))) {
					fprintf (stderr, "Invalid face data, need %u, have %lli\n", (guint) (2 + (n * 8)), block_length);
					return;
				}
				{
					gint i;
					i = 0;
					{
						gboolean _tmp12_;
						_tmp12_ = TRUE;
						while (TRUE) {
							guint16 _tmp13_;
							guint16 a;
							guint16 _tmp14_;
							guint16 b;
							guint16 _tmp15_;
							guint16 c;
							if (!_tmp12_) {
								i++;
							}
							_tmp12_ = FALSE;
							if (!(i < n)) {
								break;
							}
							_tmp13_ = tds_model_read_uint16 (self, (GInputStream*) stream, &_inner_error_);
							a = _tmp13_;
							if (_inner_error_ != NULL) {
								g_propagate_error (error, _inner_error_);
								return;
							}
							_tmp14_ = tds_model_read_uint16 (self, (GInputStream*) stream, &_inner_error_);
							b = _tmp14_;
							if (_inner_error_ != NULL) {
								g_propagate_error (error, _inner_error_);
								return;
							}
							_tmp15_ = tds_model_read_uint16 (self, (GInputStream*) stream, &_inner_error_);
							c = _tmp15_;
							if (_inner_error_ != NULL) {
								g_propagate_error (error, _inner_error_);
								return;
							}
							tds_model_read_uint16 (self, (GInputStream*) stream, &_inner_error_);
							if (_inner_error_ != NULL) {
								g_propagate_error (error, _inner_error_);
								return;
							}
							self->priv->triangles[i * 3] = (GLushort) a;
							self->priv->triangles[(i * 3) + 1] = (GLushort) c;
							self->priv->triangles[(i * 3) + 2] = (GLushort) b;
						}
					}
				}
				tds_model_parse_block (self, stream, block_length - (2 + (n * 8)), &_inner_error_);
				if (_inner_error_ != NULL) {
					g_propagate_error (error, _inner_error_);
					return;
				}
				break;
			}
			default:
			{
				{
					gint i;
					i = 0;
					{
						gboolean _tmp16_;
						_tmp16_ = TRUE;
						while (TRUE) {
							if (!_tmp16_) {
								i++;
							}
							_tmp16_ = FALSE;
							if (!(i < (block_length - 6))) {
								break;
							}
							tds_model_read_uint8 (self, (GInputStream*) stream, &_inner_error_);
							if (_inner_error_ != NULL) {
								g_propagate_error (error, _inner_error_);
								return;
							}
						}
					}
				}
				break;
			}
		}
		length = length - block_length;
	}
	if (length != 0) {
		return;
	}
}


void tds_model_render (TDSModel* self) {
	g_return_if_fail (self != NULL);
	glEnable (GL_CULL_FACE);
	glEnableClientState (GL_VERTEX_ARRAY);
	glEnableClientState (GL_NORMAL_ARRAY);
	glEnableClientState (GL_TEXTURE_COORD_ARRAY);
	glVertexPointer ((GLint) 3, GL_FLOAT, (GLsizei) 0, self->priv->vertices);
	glNormalPointer (GL_FLOAT, (GLsizei) 0, self->priv->normals);
	glTexCoordPointer ((GLint) 2, GL_FLOAT, (GLsizei) 0, self->priv->texture_coords);
	glDrawElements (GL_TRIANGLES, (GLsizei) self->priv->triangles_length1, GL_UNSIGNED_SHORT, self->priv->triangles);
	glDisableClientState (GL_VERTEX_ARRAY);
	glDisableClientState (GL_NORMAL_ARRAY);
	glDisableClientState (GL_TEXTURE_COORD_ARRAY);
}


static guint8 tds_model_read_uint8 (TDSModel* self, GInputStream* stream, GError** error) {
	guint8 result = 0U;
	guchar buffer[1] = {0};
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (stream != NULL, 0U);
	g_input_stream_read_all (stream, buffer, (gsize) 1, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return 0U;
	}
	result = (guint8) buffer[0];
	return result;
}


static guint16 tds_model_read_uint16 (TDSModel* self, GInputStream* stream, GError** error) {
	guint16 result = 0U;
	guchar buffer[2] = {0};
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (stream != NULL, 0U);
	g_input_stream_read_all (stream, buffer, (gsize) 2, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return 0U;
	}
	result = (guint16) ((buffer[1] << 8) | buffer[0]);
	return result;
}


static guint32 tds_model_read_uint32 (TDSModel* self, GInputStream* stream, GError** error) {
	guint32 result = 0U;
	guchar buffer[4] = {0};
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (stream != NULL, 0U);
	g_input_stream_read_all (stream, buffer, (gsize) 4, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return 0U;
	}
	result = (guint32) ((((buffer[3] << 24) | (buffer[2] << 16)) | (buffer[1] << 8)) | buffer[0]);
	return result;
}


static gfloat* _vala_array_dup1 (gfloat* self, int length) {
	return g_memdup (self, length * sizeof (gfloat));
}


static gfloat tds_model_read_float (TDSModel* self, GInputStream* stream, GError** error) {
	gfloat result = 0.0F;
	guint8 buffer[4] = {0};
	gfloat* _tmp0_;
	gfloat* _tmp1_;
	gfloat* fbuffer;
	gint fbuffer_length1;
	gint _fbuffer_size_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0.0F);
	g_return_val_if_fail (stream != NULL, 0.0F);
	g_input_stream_read_all (stream, buffer, (gsize) 4, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return 0.0F;
	}
	_tmp0_ = (_tmp1_ = (gfloat*) buffer, (_tmp1_ == NULL) ? ((gpointer) _tmp1_) : _vala_array_dup1 (_tmp1_, 4));
	fbuffer = _tmp0_;
	fbuffer_length1 = 4;
	_fbuffer_size_ = 4;
	result = fbuffer[0];
	fbuffer = (g_free (fbuffer), NULL);
	return result;
}


static gchar* tds_model_read_string (TDSModel* self, GInputStream* stream, GError** error) {
	gchar* result = NULL;
	GString* _tmp0_ = NULL;
	GString* value;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (stream != NULL, NULL);
	_tmp0_ = g_string_new ("");
	value = _tmp0_;
	while (TRUE) {
		guint8 _tmp1_;
		guint8 c;
		_tmp1_ = tds_model_read_uint8 (self, stream, &_inner_error_);
		c = _tmp1_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			_g_string_free0 (value);
			return NULL;
		}
		if (c == 0) {
			gchar* _tmp2_;
			_tmp2_ = g_strdup (value->str);
			result = _tmp2_;
			_g_string_free0 (value);
			return result;
		}
		g_string_append_c (value, (gchar) c);
	}
	_g_string_free0 (value);
}


static void value_tds_model_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_tds_model_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		tds_model_unref (value->data[0].v_pointer);
	}
}


static void value_tds_model_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = tds_model_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_tds_model_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_tds_model_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		TDSModel* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = tds_model_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_tds_model_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	TDSModel** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = tds_model_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_tds_model (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecTDSModel* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_TDS_MODEL), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_tds_model (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TDS_MODEL), NULL);
	return value->data[0].v_pointer;
}


void value_set_tds_model (GValue* value, gpointer v_object) {
	TDSModel* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TDS_MODEL));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TDS_MODEL));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		tds_model_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tds_model_unref (old);
	}
}


void value_take_tds_model (GValue* value, gpointer v_object) {
	TDSModel* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_TDS_MODEL));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_TDS_MODEL));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		tds_model_unref (old);
	}
}


static void tds_model_class_init (TDSModelClass * klass) {
	tds_model_parent_class = g_type_class_peek_parent (klass);
	TDS_MODEL_CLASS (klass)->finalize = tds_model_finalize;
	g_type_class_add_private (klass, sizeof (TDSModelPrivate));
}


static void tds_model_instance_init (TDSModel * self) {
	self->priv = TDS_MODEL_GET_PRIVATE (self);
	self->priv->min_height = (GLfloat) FLT_MAX;
	self->priv->max_height = (GLfloat) FLT_MIN;
	self->ref_count = 1;
}


static void tds_model_finalize (TDSModel* obj) {
	TDSModel * self;
	self = TDS_MODEL (obj);
	self->priv->vertices = (g_free (self->priv->vertices), NULL);
	self->priv->triangles = (g_free (self->priv->triangles), NULL);
	self->priv->normals = (g_free (self->priv->normals), NULL);
	self->priv->texture_coords = (g_free (self->priv->texture_coords), NULL);
}


GType tds_model_get_type (void) {
	static volatile gsize tds_model_type_id__volatile = 0;
	if (g_once_init_enter (&tds_model_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_tds_model_init, value_tds_model_free_value, value_tds_model_copy_value, value_tds_model_peek_pointer, "p", value_tds_model_collect_value, "p", value_tds_model_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (TDSModelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tds_model_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TDSModel), 0, (GInstanceInitFunc) tds_model_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType tds_model_type_id;
		tds_model_type_id = g_type_register_fundamental (g_type_fundamental_next (), "TDSModel", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&tds_model_type_id__volatile, tds_model_type_id);
	}
	return tds_model_type_id__volatile;
}


gpointer tds_model_ref (gpointer instance) {
	TDSModel* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void tds_model_unref (gpointer instance) {
	TDSModel* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		TDS_MODEL_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}



