;;
;; $Id: gnade.iss,v 1.19 2004/05/12 16:53:45 merdmann Exp $
;;
;;
[Setup]
AppName=GNU Ada Database Development Environment (GNADE)
AppVerName=GNADE Version 1.5.3
AppPublisher=Michael Erdmann <merdmann@sourceforge.net>
AppPublisherURL=http://gnade.sourceforge.net/
AppSupportURL=http://sourceforge.net/projects/gnade
AppUpdatesURL=http://sourceforge.net/projects/gnade
AppVersion=1.5.3
DefaultDirName={sd}\GNADE
DisableProgramGroupPage=yes
UninstallDisplayIcon={app}\GNADE.exe
AppCopyright=Copyright  2004 Michael Erdmann
SourceDir=../
WindowVisible=yes
LicenseFile=COPYING

[Components]
Name: SDK; Description: Software Development Kit; Types: full compact
Name: odbctools; Description: ODBC Database Tools; Types: full compact
Name: src; Description: GNADE Sourcecode; Types: full
Name: src/mysql; Description: Native bindings for MySQL 4; Types: full
Name: src/sqlite; Description: Native bindings for SQLite; Types: full
Name: src/postgres; Description: Native bindings for PostgreSQL; Types: full
Name: src/oracle; Description: Native bindings for Oracle; Types: full
Name: src/addon; Description: Addons (ADBC etc); Types: full
Name: mimer; Description: Mimer SQL Installation scripts; Types: full

[Dirs]
Name: {app}\win32-include
Name: {app}\win32-lib
Name: {app}\win32-bin
Name: {app}\shared
Name: {app}\var

[Registry]
Root: HKLM; Subkey: SYSTEM\CurrentControlSet\Control\Session Manager\Environment; ValueType: string; ValueName: GNADE_BASEPATH; ValueData: {app}

[Files]
Source: gnade.gpp; DestDir: {app}\shared; Attribs: readonly; Components: SDK
Source: win32-bin\gesql.exe; DestDir: {app}\win32-bin; Attribs: readonly; Components: SDK
Source: win32-include\*; DestDir: {app}\win32-include; Attribs: readonly; Components: SDK
Source: win32-lib\*; DestDir: {app}\win32-lib; Attribs: readonly; Components: SDK odbctools
Source: win32-bin\imp.exe; DestDir: {app}\win32-bin; Attribs: readonly; Components: odbctools
Source: win32-bin\exp.exe; DestDir: {app}\win32-bin; Attribs: readonly; Components: odbctools
Source: win32-bin\sql.exe; DestDir: {app}\win32-bin; Attribs: readonly; Components: odbctools
Source: win32-bin\lsodbc.exe; DestDir: {app}\win32-bin; Attribs: readonly; Components: odbctools
Source: win32\README; DestDir: {app}; DestName: README.txt; Attribs: readonly; Flags: isreadme

Source: win32-libexec\*.exe; DestDir: {app}\win32-libexec; Attribs: readonly; Components: SDK

Source: version.ads; DestDir: {app}; Attribs: readonly; Components: SDK
Source: samples\standalone\*; Destdir: {app}\standalone; Components: SDK
Source: ide\gps\*; Destdir: {app}\shared; Attribs: readonly; Components: SDK
;;
;;
Source: *; DestDir: {app}\source; Components: src
Source: win32\*; DestDir: {app}\source\win32; Components: src
Source: support\*; DestDir: {app}\source\support; Components: src
Source: cfg\*; DestDir: {app}\source\cfg; Components: src
Source: cfg\scripts-gnu\*; DestDir: {app}\source\cfg\scripts-gnu; Components: src
Source: cfg\scripts-win32\*; DestDir: {app}\source\cfg\scripts-win32; Components: src
Source: esql\*; DestDir: {app}\source\esql; Components: src
Source: dbi\*; DestDir: {app}\source\dbi; Components: src
Source: dbi\odbc\*; DestDir: {app}\source\dbi\odbc; Components: src
Source: dbi\mysql\*; DestDir: {app}\source\dbi\mysql; Components: src
Source: dbi\postgres\*; DestDir: {app}\source\dbi\postgres; Components: src
Source: dbi\sqlite\*; DestDir: {app}\source\dbi\sqlite; Components: src
Source: dbi\oci\*; DestDir: {app}\source\dbi\oci; Components: src
Source: tools\*; DestDir: {app}\source\tools; Components: src
Source: bin\*; DestDir: {app}\source\bin; Components: src
Source: doc\*; DestDir: {app}\source\doc; Components: src
Source: doc\build\*; DestDir: {app}\source\build; Components: src
Source: doc\releasenotes\*; DestDir: {app}\source\doc\releasenotes; Components: src
Source: rpm\*; DestDir: {app}\source\rpm; Components: src
Source: pkg-config\*; DestDir: {app}\source\pkg-config; Components: src
Source: etc\*; DestDir: {app}\source\etc; Components: src
Source: etc\profile.d\*; DestDir: {app}\source\etc\profile.d; Components: src
Source: autoconf\*; DestDir: {app}\source\autoconf; Components: src
Source: samples\*; DestDir: {app}\source\samples; Components: src
;;
;;
Source: dbi\adbc\*; DestDir: {app}\source\dbi\adbc; Components: src/addon
;;
;;
Source: samples\sample_db\*; DestDir: {app}\source\samples\sample_db; Components: mimer
Source: samples\mysql\*; DestDir: {app}\source\samples\mysql; Components: src/mysql
Source: samples\sqlite\*; DestDir: {app}\source\samples\sqlite; Components: src/sqlite
Source: samples\postgres\*; DestDir: {app}\source\samples\postgres; Components: src/postgres
Source: samples\oci\*; DestDir: {app}\source\samples\oci; Components: src/oracle
Source: samples\odbc\*; DestDir: {app}\source\samples\odbc; Components: src
Source: samples\esql\*; DestDir: {app}\source\samples\esql; Components: src

[Run]
Filename: {app}\win32-libexec\prep.exe; Description: Configuring GNADE project; Parameters: "DMLINKEROPT=""-L/gnat/lib/win32 -lodbc32"" NALINKEROPT="" "" BUILDARCH=""win32"" ROOT=""{app}"" {app}\shared\gnade.gpp {app}\gnade.gpr"; WorkingDir: {app}; StatusMsg: Configuring gnade.gpr

[UninstallRun]
Filename: {win}\system32\cmd.exe; Parameters: /c attrib/s -r *; WorkingDir: {app}; StatusMsg: Preparing GNADE deinstallation
Filename: {win}\system32\cmd.exe; Parameters: /c del gnade.gpr; WorkingDir: {app}; StatusMsg: Deleting GNADE project file






