/*
*
*  $Id: volumepipeline.h 3404 2011-02-23 14:07:56Z carlos $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*
*/
#pragma once
#include <list>
#include <yasper/yasper.h>
#include <vtkSmartPointer.h>
#include "ipipeline.h"

class vtkImageData;
class vtkRenderer;
class vtkImageResample;
class vtkImageData;
class vtkRenderer;
class vtkImageResample;
class vtkVolume;
class vtkSmartVolumeMapper;
class vtkColorTransferFunction;
class vtkPiecewiseFunction;
class vtkVolumeProperty;
class GinkgoInteractorStyleReconstruction;

class wxWindow;

namespace MedicalViewer {
	namespace Reconstruction {
		namespace DataSet {
			class Slice;
			class DataSet;
		}

		namespace Pipelines {
			class VolumeCommandObserver;
		}
	}
}

#define NSURF 2

namespace MedicalViewer {
	namespace Reconstruction {
		namespace Pipelines {

			class VolumePipeline : public IPipeline {

			public:

				typedef enum VolumeBlendType {
					VBT_MIP,
					VBT_CompositeRamp,
					VBT_CompositeShadeRamp,
					VBT_RGB_Composite,
					VBT_CT_Skin,
					VBT_CT_Bone,
					VBT_CT_Muscle
				} VolumeBlendType;


				typedef std::list<vtkSmartPointer<VolumeCommandObserver> >  TProgressList;

				vtkSmartPointer<vtkImageResample>         Resample;

				vtkSmartPointer<vtkVolume>                Volume;
				vtkSmartPointer<vtkSmartVolumeMapper>     Mapper;

				vtkSmartPointer<vtkColorTransferFunction> ColorTransferFunction;
				vtkSmartPointer<vtkPiecewiseFunction>     OpacityTransferFunction;
				vtkSmartPointer<vtkVolumeProperty>        VolumeProperty;

				TProgressList Progresses;

				vtkSmartPointer<GinkgoInteractorStyleReconstruction> Interactor;

				double          Window; // Temporary W/L
				double          Level;
				double          SettedWindow; // Setted W/L
				double          SettedLevel;

				VolumeBlendType CurrentBlendType;


			public:

				VolumePipeline(wxWindow* win3d);

				~VolumePipeline();

				void SetupInteractor();

				void SetInteractorStyleToDefault();
				void SetInteractorStyleToWindowLevel();

				void SetWindowLevel(double window, double level);
				void ResetWindowLevel();

				void UpdateBlending(double window, double level);

				// Blending modes

				void SetBlendingType(VolumeBlendType blendType);

				void SetBlendingToMIP();
				void SetBlendingToCompositeRamp();
				void SetBlendingToCompositeShadeRamp();
				void SetBlendingToRGBComposite();
				void SetBlendingToCTSkin();
				void SetBlendingToCTMuscle();
				void SetBlendingToCTBone();

				void SetDataSet(unsigned int volNum, double reductionFactor);

				void Enable(bool enabled);

				void SetProgressNotifier(IReconstructionNotifier* notifier);

				virtual void Update();

			};
		}
	}
}
