/*
 *  
 *  $Id: volumecommand.cpp 3387 2011-02-23 09:33:54Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#ifdef __DEPRECATED
#undef __DEPRECATED
#endif
#include <exception>
#include "volumecommand.h"
#include "voiextractioncommand.h"
#include "../pipelines/volumepipeline.h"

MedicalViewer::Reconstruction::Volume::Commands::VolumeCommandParams::VolumeCommandParams(
	const GnkPtr<TPipeline>& pipeline,
	unsigned int datasetNum,
	double reductionFactor,
	double window,
	double level,
	TBlendType blendType
	) : Pipeline(pipeline), DataSetNum(datasetNum), ReductionFactor(reductionFactor), Window(window), Level(level), BlendType(blendType)
{
}

MedicalViewer::Reconstruction::Volume::Commands::VolumeCommandParams::~VolumeCommandParams()
{
}

//====================================================================

MedicalViewer::Reconstruction::Volume::Commands::VolumeCommand::VolumeCommand(VolumeCommandParams* pParams) : GNC::GCS::IComando(pParams, "VolumeReconstruction" )
{
	m_pVolumeParams = pParams;
	SetId(IDC_VOLUME_RECONSTRUCTION);
	CancelaA(IDC_VOLUME_RECONSTRUCTION);
	EsperaA(IDC_VOI_EXTRACTION);	
}

MedicalViewer::Reconstruction::Volume::Commands::VolumeCommand::~VolumeCommand(void)
{
}

void MedicalViewer::Reconstruction::Volume::Commands::VolumeCommand::Execute()
{

	m_pVolumeParams->Pipeline->SetDataSet(m_pVolumeParams->DataSetNum, m_pVolumeParams->ReductionFactor);
	m_pVolumeParams->Pipeline->SetWindowLevel(m_pVolumeParams->Window, m_pVolumeParams->Level);
	m_pVolumeParams->Pipeline->SetBlendingType(m_pVolumeParams->BlendType);

	try {
		m_pVolumeParams->Pipeline->SetProgressNotifier(this);
		m_pVolumeParams->Pipeline->Update();
		m_pVolumeParams->Pipeline->SetProgressNotifier(NULL);
	}
	catch (...) {

	}
}

void MedicalViewer::Reconstruction::Volume::Commands::VolumeCommand::Update()
{
	
	m_pVolumeParams->Pipeline->Enable(true);
	m_pVolumeParams->Pipeline->Render();
}

void MedicalViewer::Reconstruction::Volume::Commands::VolumeCommand::OnAbort()
{
}

void MedicalViewer::Reconstruction::Volume::Commands::VolumeCommand::LiberarRecursos()
{
}

bool MedicalViewer::Reconstruction::Volume::Commands::VolumeCommand::NotifyReconstructionProgress(const std::string& text, float progress)
{
	return NotificarProgreso(progress, text);
}
