/*
 *  
 *  $Id: guiappender.h 3558 2011-03-20 20:02:22Z carlos $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 *
 */
#pragma once

#include <dcmtk/oflog/appender.h>
#include <sstream>
#include <list>
#include <api/ilock.h>
#include "logdefines.h"


namespace gnkLog4cplus {
	
	class  GUIAppender : public log4cplus::Appender {
		
	public:
		
		static GUIAppender* Instance();
		
		static void FreeInstance();
		
		// Methods
		virtual void close();
		
		void Attach(GNC::GCS::Logging::ILogger* pLogger);
		
    protected:
		
		typedef std::list<GNC::GCS::Logging::LogEvent> ListaLogs;
		
		// Ctors		  
		GUIAppender(bool logToStdErr = false, bool immediateFlush = false);
		GUIAppender(const log4cplus::helpers::Properties properties);
		GUIAppender(const GUIAppender& o);
		
		// Dtor
		~GUIAppender();
		virtual void append(const log4cplus::spi::InternalLoggingEvent& event);
		
		// Data
		bool logToStdErr;
		/**
		 * Immediate flush means that the underlying output stream
		 * will be flushed at the end of each append operation.
		 */
		bool immediateFlush;
		
		GNC::GCS::Logging::ILogger* m_pLogger;
		ListaLogs                   m_Logs;
		
		log4cplus::LogLevelManager& llmCache;
		
		
		static GUIAppender* m_pInstancia;
		
		GUIAppender& operator = (const GUIAppender& /*o*/)
		{
			throw std::exception();
		}
		
    };
}
