/*
 *
 *  $Id: dicomservice.cpp 3896 2011-06-22 07:08:49Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 */

#include <api/icontroladorlog.h>
#include <main/controllers/controladorlog.h>
#include <main/controllers/controladorcomandos.h>
#include <commands/incomingdicomassociationcommand.h>
#include "dicomservice.h"
#include "dicomnetwork.h"

#ifdef MACRO_QUE_ESTORBA
#define verify MACRO_QUE_ESTORBA
#endif

#include <dcmtk/dcmdata/dcdeftag.h>
#include <dcmtk/dcmdata/dcuid.h>     /* for dcmtk version name */
#include <dcmtk/dcmjpeg/djdecode.h>  /* for dcmjpeg decoders */
#include <dcmtk/dcmjpeg/djencode.h>  /* for dcmjpeg encoders */
#include <dcmtk/dcmjpeg/djrplol.h>   /* for DJ_RPLossless */
#include <dcmtk/dcmjpeg/djrploss.h>  /* for DJ_RPLossy */
#include <dcmtk/dcmjpeg/dipijpeg.h>  /* for dcmimage JPEG plugin */
#include <dcmtk/dcmimage/diregist.h>  /* include to support color images */
#include <dcmtk/ofstd/ofcmdln.h>
#include <dcmtk/dcmnet/diutil.h>

#include <dcmtk/dcmjpeg/djencode.h>
#include <dcmtk/dcmjpeg/djdecode.h>
#include <dcmtk/dcmjpeg/djrplol.h>
#include <dcmtk/dcmjpeg/djrploss.h>

#include "tls/tls.h"
#include "tls/gtlslayer.h"
#include <dcmtk/dcmtls/tlstrans.h>


#ifdef MACRO_QUE_ESTORBA
#define verify MACRO_QUE_ESTORBA
#endif
GIL::DICOM::Service::Service(const std::string& _ambitolog) : GNC::GCS::Thread(_ambitolog),
ambitolog(_ambitolog),
m_pNotificadorProgreso(NULL),
m_timeout(15),
m_Role(RT_Acceptor),
m_acceptorPort(1112),
m_TLS(false),
m_UseUserPass(false),
m_Validate(false)
{
	this->m_pNet = NULL;
	this->m_pTLSLayer = NULL;
	
	this->m_rcvPDUSize = 16384;
	this->m_sendPDUSize = 16384;

	this->m_rcvTimeout = 60;
	this->m_pollTimeout = 100;
	this->m_ServiceThreadId = 0;
	this->m_Stopping = false;

}

GIL::DICOM::Service::~Service() {
    // drop an existing association on shutdown	
	Stop();
	m_pNotificadorProgreso = NULL;
}

CONDITION GIL::DICOM::Service::Start() {

	#ifdef _WIN32
    WORD wVersionRequested;
    WSADATA wsaData;
	
    wVersionRequested = MAKEWORD(1, 1);
	
    WSAStartup(wVersionRequested, &wsaData);
	#endif

	CONDITION cond;
	
	switch (m_Role) {
		case RT_Acceptor:
			cond = ASC_initializeNetwork(NET_ACCEPTOR, m_acceptorPort, m_timeout, &m_pNet);
			break;
		case RT_Requestor:
			cond = ASC_initializeNetwork(NET_REQUESTOR, 0, m_timeout, &m_pNet);
			break;
		case RT_AcceptorRequestor:
			cond = ASC_initializeNetwork(NET_ACCEPTORREQUESTOR, m_acceptorPort, m_timeout, &m_pNet);
			break;
		default:
			return EC_IllegalParameter;
	}

	m_pTLSLayer = NULL;
	
    if (m_TLS)
    {
		m_pTLSLayer = new GTLSTransportLayer(DICOM_APPLICATION_REQUESTOR, NULL);
		if (m_pTLSLayer == NULL)
		{
			LOG_ERROR(ambitolog, _Std("Unable to create TLS transport layer"));
			//return 1;
			return EC_IllegalParameter;
		}
		m_pTLSLayer->setCertificateFromString(GetCliCert());
		m_pTLSLayer->setPrivateKeyFromString(GetCliKey());
		
		if (! m_pTLSLayer->checkPrivateKeyMatchesCertificate())
		{
			LOG_ERROR(ambitolog, _Std("Private key and Certificate do not match"));
			return EC_IllegalParameter;
		}
		
		m_pTLSLayer->addSystemTrustedCertificates();
		
		if (GetValidate()) {
			m_pTLSLayer->setCertificateVerification(DCV_requireCertificate);
		}
		else {
			m_pTLSLayer->setCertificateVerification(DCV_ignoreCertificate);
		}
		/*
		 if (opt_dhparam && ! (tLayer->setTempDHParameters(opt_dhparam)))
		 {
		 LOG_WARN(assoc->ambitolog, "unable to load temporary DH parameters. Ignoring");
		 }
		 */
		
		cond = ASC_setTransportLayer(m_pNet, m_pTLSLayer, 0);
		if (cond.bad())
		{
			LOG_ERROR(ambitolog, _Std("Error setting TLS layer: ") << cond.text());
			return EC_IllegalParameter;
		}
    }

	m_ServiceThreadId = GNC::GCS::ThreadController::Launch(this);

    return EC_Normal;
}

void* GIL::DICOM::Service::Task() {
	CONDITION cond = EC_Normal;
	OFString temp_str;

	while (!m_Stopping && cond.good())
	{
		cond = acceptAssociation();
	}
	
	cond = ASC_dropNetwork(&m_pNet);

	#if defined(_WINDOWS)
    WSACleanup();
	#endif
	
	if (cond.bad())
	{
		LOG_ERROR(ambitolog, DimseCondition::dump(temp_str, cond));
		return NULL;
	}

  return 0;

}

CONDITION GIL::DICOM::Service::acceptAssociation()
{
	char buf[BUFSIZ];
	T_ASC_Association *assoc;
	OFCondition cond;
	OFString sprofile;
	OFString temp_str;

	cond = ASC_receiveAssociation(m_pNet, &assoc, m_rcvPDUSize, NULL, NULL, m_TLS, DUL_NOBLOCK, 1);

	// if some kind of error occured, take care of it
	if (cond.bad())
	{
		// check what kind of error occurred. If no association was
		// received, check if certain other conditions are met
		if( cond == DUL_NOASSOCIATIONREQUEST )
		{

		}
		// If something else was wrong we might have to dump an error message.
		else
		{
			LOG_ERROR(ambitolog, _Std("Receiving Association failed: ") << DimseCondition::dump(temp_str, cond).c_str());
		}

		// no matter what kind of error occurred, we need to do a cleanup
		goto cleanup;
	}
	{
	  LOG_INFO(ambitolog, _Std("Association Received"));

	  LOG_DEBUG(ambitolog, _Std("Parameters:") << std::endl << ASC_dumpParameters(temp_str, assoc->params, ASC_ASSOC_RQ).c_str());

	  const GIL::DICOM::SOPClassMap& scps = GIL::DICOM::Conformance::GetScpSOPClasses();

	  for (GIL::DICOM::SOPClassMap::const_iterator it = scps.begin(); cond.good() && it != scps.end(); it++) {
		  const GIL::DICOM::ArrayHelper& transfersyntaxes = scps.GetSupportedTransferSyntaxUIDs((*it).first);
		  const char* scuid = (*it).second.scUID.c_str();
		  cond = ASC_acceptContextsWithPreferredTransferSyntaxes(assoc->params, &scuid, 1, transfersyntaxes.array, transfersyntaxes.size); 
	  }

	  if (cond.bad()) {
		  LOG_ERROR(ambitolog, DimseCondition::dump(temp_str, cond).c_str());
		  goto cleanup;
	  }

	  // set our app title 
	  ASC_setAPTitles(assoc->params, NULL, NULL, m_localAET.c_str());

	  // acknowledge or reject this association
	  cond = ASC_getApplicationContextName(assoc->params, buf);
	  if ((cond.bad()) || strcmp(buf, UID_StandardApplicationContext) != 0) {
		  // reject: the application context name is not supported
		  T_ASC_RejectParameters rej =
		  {
			  ASC_RESULT_REJECTEDPERMANENT,
			  ASC_SOURCE_SERVICEUSER,
			  ASC_REASON_SU_APPCONTEXTNAMENOTSUPPORTED
		  };

		  LOG_ERROR(ambitolog, _Std("Association Rejected: Bad Application Context Name: ") << buf);
		  cond = ASC_rejectAssociation(assoc, &rej);
		  if (cond.bad())
		  {
			  LOG_DEBUG(ambitolog, DimseCondition::dump(temp_str, cond).c_str());
		  }
		  goto cleanup;

	  }
	  else if (strlen(assoc->params->theirImplementationClassUID) == 0) {
		  // reject: the no implementation Class UID provided
		  T_ASC_RejectParameters rej =
		  {
			  ASC_RESULT_REJECTEDPERMANENT,
			  ASC_SOURCE_SERVICEUSER,
			  ASC_REASON_SU_NOREASON
		  };

		  LOG_ERROR(ambitolog, _Std("Association Rejected: No Implementation Class UID provided") );
		  cond = ASC_rejectAssociation(assoc, &rej);
		  if (cond.bad()) {
			  LOG_DEBUG(ambitolog, DimseCondition::dump(temp_str, cond).c_str());
		  }
		  goto cleanup;
	  }
	  else {
		  cond = ASC_acknowledgeAssociation(assoc);
		  if (cond.bad())
		  {
			  LOG_ERROR(ambitolog, DimseCondition::dump(temp_str, cond).c_str());
			  goto cleanup;
		  }
		  LOG_INFO(ambitolog, _Std("Association Acknowledged (Max Send PDV: ") << assoc->sendPDVLength << _Std(")"));
		  if (ASC_countAcceptedPresentationContexts(assoc->params) == 0) {
			  LOG_INFO(ambitolog, _Std(" but no valid presentation contexts"));
		  }
		  // dump the presentation contexts which have been accepted/refused 
		  LOG_DEBUG(ambitolog, ASC_dumpParameters(temp_str, assoc->params, ASC_ASSOC_AC).c_str());

		  std::string cmdName;
		  {
			  std::ostringstream os;
			  os << _Std("Association(dicom://") << assoc->params->DULparams.callingPresentationAddress << _Std("@") << assoc->params->DULparams.callingAPTitle << _Std(")");
			  cmdName = os.str();
		  }

		  GADAPI::PACS::IncomingDicomAssociationCommandParams* pCmdParams = new GADAPI::PACS::IncomingDicomAssociationCommandParams(assoc);
		  
		  
		  GNC::GCS::ControladorComandos::Instance()->ProcessAsync( cmdName, new GADAPI::PACS::IncomingDicomAssociationCommand(pCmdParams, cmdName), this);
		  return cond;
	  }
	}


cleanup:

	cond = ASC_dropSCPAssociation(assoc);
	if (cond.bad())
	{
		LOG_FATAL(ambitolog, DimseCondition::dump(temp_str, cond).c_str());
	}
	
	cond = ASC_destroyAssociation(&assoc);
	if (cond.bad())
	{
		LOG_FATAL(ambitolog, DimseCondition::dump(temp_str, cond).c_str());
	}

	return cond;
}


CONDITION GIL::DICOM::Service::Stop() {
	
	m_Stopping = true;

	GNC::GCS::ControladorComandos::Instance()->AbortarComandosDeOwner(this);

	if (m_ServiceThreadId != 0) {
		
		GNC::GCS::ThreadController::Stop(this->m_ServiceThreadId);
		
		this->m_ServiceThreadId = 0;
	}

	if (m_pTLSLayer != NULL) {
		delete m_pTLSLayer;
	}

	this->m_Stopping = false;
	
	return EC_Normal;
}
