/*
*  
*  $Id: handledicom.h 3698 2011-04-14 12:38:49Z carlos $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
#pragma once

#include <api/api.h>
#include <string>
#include <vector>
#include <yasper/yasper.h>
#include <api/imodelointegracion.h>

namespace GNC {
	namespace GCS {
		namespace Eventos {

			//de momento se pasan uids de series, en un futuro podriamos tratar con open sopinstances uids o study instances
			class EXTAPI EvtHandleDicom: public GNC::GCS::Eventos::IEvento
			{
			public:
				typedef enum {
					DeleteSeries,
					OpenSeries
				} TAction;

				typedef std::list<std::string> ListaUIDs;

				EvtHandleDicom():GNC::GCS::Eventos::IEvento(ginkgoEVT_Core_HandleDICOM)
				{
					m_Nombre = "EvtHandleDicom";
				}

				EvtHandleDicom(ListaUIDs lista, TAction action = OpenSeries):GNC::GCS::Eventos::IEvento(ginkgoEVT_Core_HandleDICOM)
				{
					m_listaUIDs = lista;
					m_Nombre = "EvtHandleDicom";
					m_action = action;
				}

				~EvtHandleDicom()
				{
					m_listaUIDs.clear();
				}

				void SetListaUIDs(ListaUIDs lista)
				{
					m_listaUIDs=lista;
				}

				ListaUIDs &GetListaUIDs()
				{
					return m_listaUIDs;
				}

				TAction GetAction()
				{
					return m_action;
				}

				virtual void pushInfo(std::ostream& out) const {
					out <<"Rutas = [ ";
					int i = 0;
					for (ListaUIDs::const_iterator it = m_listaUIDs.begin(); it != m_listaUIDs.end(); it++) {
						if (i != 0) {
							out << ", ";
						}
						out << (*it).c_str();
					}
					out << " ]";
				}

			protected:
				ListaUIDs          m_listaUIDs;
				TAction m_action;
			};
		}
	}
}
