/*
*  
*  $Id: comandoactualizaciones.h 3521 2011-03-16 14:54:22Z carlos $
*  Ginkgo CADx Project
*
*  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
*  http://ginkgo-cadx.com
*
*  This file is licensed under LGPL v3 license.
*  See License.txt for details
*
*/
#pragma once
#include <api/icomando.h>
#include <yasper/yasper.h>

namespace GNC {
	namespace GCS {
		class IVista;
	}
}

namespace GNC {
	class ComandoComprobarActualizaciones;

	class ComandoComprobarActualizacionesParams : public GNC::GCS::IComandoParams {
	public:
		ComandoComprobarActualizacionesParams(const std::string& url, bool informar = false) : m_URL(url), m_Informar(informar) {}

		virtual ~ComandoComprobarActualizacionesParams() {}

		std::string                     m_URL;
		bool                            m_Informar;

	};

	class ComandoComprobarActualizaciones : public GNC::GCS::IComando {
	public:

		ComandoComprobarActualizaciones(ComandoComprobarActualizacionesParams* pParams);

    protected:

		virtual void Execute();
		virtual void Update();

	protected:

		ComandoComprobarActualizacionesParams* m_pComprobarActualizacionesParams;
		std::string                            m_Error;

	private:
		std::string m_VersionStr;
		std::string m_VersionCheckStr;
		std::string m_Description;
		std::string m_URL;
		int         m_Version;
		int         m_SubVersion;
		int         m_Release;
		int         m_Build;
		std::string m_CodeName;
	};
}
