/*
 *  
 *  $Id: iherramienta.cpp 4051 2011-08-01 09:41:38Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
#include <api/globals.h>
#include "iherramienta.h"
#include <wx/aui/aui.h>
#include <wx/panel.h>
#include <wx/sizer.h>

// TODO: Devolver esto a iherramienta.h, dado que todo esto tiene que estar implementado inline.
//       Movido aqui con fines de depurado.


GNC::GCS::IHerramienta::IHerramienta(const IHerramienta::UID& uid, const IHerramienta::TFamiliasHerramientas& uidFamilia, const std::string& nombre, const int subFamilia, const int& prioridad, bool isMenu, int accelerator)
{
	m_AcceleratorCode = accelerator;
	m_pAbstractPanelHerramientaOpciones = NULL;
	m_Activa = false;
	m_Habilitada = false;
	m_Mostrada = true;
	m_ConectadaConContratos = false;
	m_ConectadaConContratoFalso = false;
	ID = uid;
	IDFamilia = uidFamilia;
	Prioridad = prioridad;
	Nombre = nombre;
	m_pSolicitadorCambioHerramientas = NULL;
	m_PanelAsociado = false;
	m_PanelOpcionesAsociado = false;
	m_IsMenu = isMenu;
	IDSubFamilia = subFamilia;
}

GNC::GCS::IHerramienta::~IHerramienta()
{
	m_pAbstractPanelHerramientaOpciones = NULL;
	m_pSolicitadorCambioHerramientas = NULL;
}

//region "Interfaz concreta de IHerramienta"
/* Metodo de adaptacion para la creacion de paneles de la herramienta */
void GNC::GCS::IHerramienta::DoCrearPaneles( wxPanel* panel , wxSizer* pSizer)
{
	CrearPaneles(panel);
	if(m_pAbstractPanelHerramientaOpciones != NULL){
		m_pAbstractPanelHerramientaOpciones->Show(false);
		pSizer->Add(m_pAbstractPanelHerramientaOpciones, 1, wxEXPAND, 0);
	}
	m_Mostrada = true;
	m_PanelAsociado = true;
	m_PanelOpcionesAsociado = true;
}

//endregion

//region "Interfaz común de IHerramienta"

/* Aviso: Este metodo debe ser invocado por el "solicitador de cambio de herramienta" para registrarse a si mismo. */
void GNC::GCS::IHerramienta::SetSolicitadorCambioHerramienta(ISolicitadorCambioHerramienta* pSolicitador)
{
	m_pSolicitadorCambioHerramientas = pSolicitador;
}

/* Este metodo debe ser invocado por las implementaciones concretas de las herramientas para que el controlador de
* herramientas las active de manera consistente con las demas */
void GNC::GCS::IHerramienta::SolicitarActivacion()
{
	if (m_pSolicitadorCambioHerramientas != NULL) {
		m_pSolicitadorCambioHerramientas->SolicitarActivacion(this);
	} else {
		std::cerr << "Aviso: Solicitud de cambio de herramienta no propagado. No se ha conectado el solicitador." << std::endl;
	}
}


/* Devuelve un puntero generico al panel de opciones de la herramienta */
AUI_NAMESPACE wxAuiToolBar* GNC::GCS::IHerramienta::GetPanelHerramientaOpciones()
{
	return m_pAbstractPanelHerramientaOpciones;
}

/* Activa/Desactiva la herramienta.
 * Aviso: Las herramientas no deben activarse o desactivarse por si mismas. Debe ser el controlador de herramientas quien lo haga por ellas */
void GNC::GCS::IHerramienta::Activar(bool activa)
{

	if (activa == m_Activa) {
		return;
	}

	m_Activa = activa;
}

/* Devuelve verdadero si la herramienta esta activada */
bool GNC::GCS::IHerramienta::Activada()
{
	return m_Activa;
}

/* Habilita/Deshabilita la herramienta.
* Aviso: Las herramientas no deben habilitarse o deshabilitarse por si mismas. Debe ser el controlador de herramientas quien lo haga por ellas */
void GNC::GCS::IHerramienta::Habilitar(bool habilitada)
{

	if (habilitada == m_Habilitada) {
		return;
	}

	m_Habilitada = habilitada;
}

/* Devuelve verdadero si la herramienta esta habilitada */
bool GNC::GCS::IHerramienta::Habilitada()
{
	return m_Habilitada;
}

/* Muestra/Oculta la herramienta
* Aviso: Las herramientas no deben mostrarse u ocultarse por si mismas. Debe ser el controlador de herramientas quien lo haga por ellas */
void GNC::GCS::IHerramienta::Mostrar(bool mostrada)
{

	if (m_Mostrada == mostrada) {
		return;
	}

	m_Mostrada = mostrada;
}

/* Devuelve verdadero si la herramienta esta mostrada */
bool GNC::GCS::IHerramienta::Mostrada()
{
	return m_Mostrada;
}

/* Conecta/desconecta los contratos o el modo dehabilitado de la herramienta de manera inteligente, dependiendo de si esta habilitada
* Aviso: Las herramientas no deben conectarse o desconectarse por si mismas. Debe ser el controlador de herramientas quien lo haga por ellas */
void GNC::GCS::IHerramienta::Conectar(bool conectar) {

	if (conectar) {
		if (!m_ConectadaConContratos && ! m_ConectadaConContratoFalso) { // Si no esta ya conectada de alguna manera
			if (m_Habilitada) {
				ConectarContratos(true);
				m_ConectadaConContratos = true;
			}
			else {
				ConectarContratoFalso(true);
				m_ConectadaConContratoFalso = true;
			}
		}
	}
	else { // Desconectar
		if (m_ConectadaConContratos) {
			ConectarContratos(false);
			m_ConectadaConContratos = false;
		}
		else if (m_ConectadaConContratoFalso) {
			ConectarContratoFalso(false);
			m_ConectadaConContratoFalso = false;
		}
	}
}

/* Devuelve verdadero si la herramienta tiene sus contratos conectados */
bool GNC::GCS::IHerramienta::Conectada()
{
	return m_ConectadaConContratos || m_ConectadaConContratoFalso;
}

//endregion

//region "Helpers"

std::string GNC::GCS::IHerramienta::GetDescripcion()
{
	return m_Descripcion;
}

wxBitmap GNC::GCS::IHerramienta::GetIcono()
{
	return m_Icono;
}


//endregion

