/*
 *  
 *  $Id: icontroladorhistorial.h 3827 2011-05-05 12:19:42Z tovar $
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
#pragma once
#include <string>
#include <vector>
#include <list>

namespace GNC {
	namespace GCS {
		class IControladorHistorial {
		public:
			typedef struct ModeloPaciente
			{
				std::string m_idPaciente;
				std::string m_nombrePaciente;
				std::string m_fechaNacimiento;
				char m_sexo;
			} ModeloPaciente;

			typedef struct ModeloEstudio
			{
				std::string m_uidEstudio;
				std::string m_fechaEstudio;
				std::string m_horaEstudio;
				std::string m_descripcionEstudio;
				std::string m_uidImportador;
				std::string m_nombreMedico;
			}ModeloEstudio;

			typedef struct ModeloDCM
			{
			public:
				std::string m_pathRelativo;
				std::string m_idPaciente;
				std::string m_nombrePaciente;
				std::string m_uidEstudio;
				std::string m_uidSerie;
				std::string m_fechaEstudio;
				std::string m_horaEstudio;
				std::string m_fechaSerie;
				std::string m_horaSerie;
				std::string m_fechaImagen;
				std::string m_horaImagen;
				std::string m_fechaNacimiento;
				std::string m_descripcionSerie;
				std::string m_descripcionImagen;
				std::string m_descripcionEstudio;
				std::string m_modalidad;
				std::string m_uidImportador;
				std::string m_uidImagen;
				std::string m_nombreMedico;
				char	m_orientacion;
				double		m_patientPosition[3];
				std::string m_contentDate;
				std::string m_contentTime;
				std::string m_width;
				std::string m_height;
				double m_sliceLocation;
				double m_instanceNumber;
				std::list<std::string> m_listaReferencias;
				std::string m_uidTransferSyntax;
				char m_sexo;
			}ModeloDCM;

			typedef struct ModeloSerie
			{
			public:
				ModeloSerie(){}
				ModeloSerie(const ModeloDCM& otro) {
					m_idPaciente = otro.m_idPaciente;
					m_nombrePaciente = otro.m_nombrePaciente;;
					m_uidEstudio = otro.m_uidEstudio;
					m_uidSerie = otro.m_uidSerie;
					m_fechaEstudio = otro.m_fechaEstudio;
					m_horaEstudio = otro.m_horaEstudio;
					m_fechaSerie = otro.m_fechaSerie;
					m_horaSerie = otro.m_horaSerie;
					m_fechaNacimiento = otro.m_fechaNacimiento;
					m_descripcionSerie = otro.m_descripcionSerie;
					m_descripcionEstudio = otro.m_descripcionEstudio;
					m_modalidad = otro.m_modalidad;
					m_uidImportador = otro.m_uidImportador;
					m_numeroSlices = 1;
					m_sexo = otro.m_sexo;
					m_uidTransferSyntax = otro.m_uidTransferSyntax;
				}

				std::string m_idPaciente;
				std::string m_nombrePaciente;
				std::string m_uidEstudio;
				std::string m_uidSerie;
				std::string m_fechaEstudio;
				std::string m_horaEstudio;
				std::string m_fechaSerie;
				std::string m_horaSerie;
				std::string m_fechaNacimiento;
				std::string m_descripcionSerie;
				std::string m_descripcionEstudio;
				std::string m_modalidad;
				std::string m_uidImportador;
				std::string m_uidTransferSyntax;
				int m_numeroSlices;
				char m_sexo;
			}ModeloSerie;			

			typedef std::list<ModeloSerie> ListaModelosSeries;
			typedef std::list<ModeloEstudio> ListaModelosEstudios;
			typedef std::list<ModeloDCM> ListaModelosDCM;
			typedef std::list<ModeloPaciente> ListaModelosPaciente;

			typedef std::list<std::string> ListaPaths;
			typedef std::list<std::string> ListaStrings;

			typedef std::vector<std::string> VectorPaths;

			/* Constructor */
			 IControladorHistorial()
			{
			}

			/* Destructor */
			virtual ~IControladorHistorial()
			{
			}

			virtual ListaModelosEstudios GetEstudiosDiagnosticosSeriePath(const std::string& pathFichero, const std::string& uidImportador = "") = 0;
			virtual ListaModelosEstudios GetEstudiosDiagnosticosEstudioPath(const std::string& pathFichero, const std::string& uidImportador = "") = 0;
			virtual ModeloDCM GetDiagnostico(const std::string& pathFicheroAbsoluto,const std::string& uidEstudio, const std::string& uidImportador="") = 0;
			virtual ModeloDCM GetDiagnosticoSerie(const std::string& uidSerie,const std::string& uidEstudio, const std::string& uidImportador="") = 0;
			virtual ModeloDCM GetDiagnosticoClave(const std::string& uidEstudio, const std::string& uidImportador) = 0;
			virtual std::string GetSopInstanceUID(const std::string& pathAbsoluto) = 0;
			virtual std::string GetPathAbsoluto(const std::string& sopInstanceUID) = 0;
			virtual VectorPaths GetPathsSerieOrdenados(const std::string& uidSerie) = 0;
			virtual void GetStudyModelsFromPatient(ListaModelosEstudios& estudyList, const std::string& patientId, const std::string& uidImporter = "") = 0;
			virtual void GetSeriesModelsFromStudy(ListaModelosSeries& seriesList, const std::string& uidStudy, const std::string& uidImporter = "") = 0;
		protected:

		};
	}
}
