/*
 *  
 *  $Id$
 *  Ginkgo CADx Project
 *
 *  Copyright 2008-10 MetaEmotion S.L. All rights reserved.
 *  http://ginkgo-cadx.com
 *
 *  This file is licensed under LGPL v3 license.
 *  See License.txt for details
 *
 */
#pragma once
#include <vector>
#include <string>
#include <iostream>
#include <exception>
#include <api/icomando.h>
#include <api/ilock.h>

#ifdef __DEPRECATED
#undef __DEPRECATED
#endif
#include <vtkSmartPointer.h>
#include <yasper/yasper.h>
namespace GIL {
	class IModeloIntegracion;
}

namespace GNC {
	namespace GCS {
		class IVista;
	}
}
class vtkImageData;
class vtkAlgorithmOutput;

namespace GNC {
	namespace GCS {

		class ControladorCargaException : public std::exception {
		public:
			ControladorCargaException(const std::string& msg, const std::string& componente="Modelo", bool fatal = true) throw()
			{
				this->cause = msg;
				this->component = componente;
				this->fatal = fatal;
			}
			~ControladorCargaException() throw()
			{
			}

			const std::string& GetComponent() const
			{
				return component;
			}

			const std::string& GetCause() const {
				return cause;
			}

			std::string GetFullCause() const {
				return *this;
			}

			bool IsFatal()  const {
				return fatal;
			}

			operator std::string () const {
				return std::string("Excepcion en componente ") + GetComponent() + std::string(": ")  + GetCause();
			}

			friend std::ostream& operator<<(std::ostream& out, const ControladorCargaException& ex)
			{
				out << (const std::string&) ex;
				return out;
			}

			friend std::ostream& operator<<(std::ostream& out, const ControladorCargaException* ex)
			{
				if (ex != NULL) {
					out << *ex;
				}
				else {
					out << "(NULL)";
				}
				return out;
			}

		protected:
			std::string cause;
			std::string component;
			bool fatal;
		};

		class IStreamingLoader;
		class IControladorCarga {
		public:
			typedef std::vector<std::string> ListaRutas;
			typedef std::list<ListaRutas> TListaDeListaDeRutas;
			
			virtual vtkSmartPointer<vtkImageData> CargarITKMultidimensional(IComando* cmd, ListaRutas& listaFicheros, int* orientacion, double* spacing = NULL) = 0;
			virtual vtkSmartPointer<vtkImageData> CargarITK(IComando* cmd, std::string& path, int* orientacion, double* spacing = NULL) = 0;
			
			virtual void CargaAsincrona(GNC::GCS::IVista* pVista, GnkPtr<GIL::IModeloIntegracion>& ModeloIntegracion, const std::string& uidEstudioDiagnostico, const bool loadFirst = true) = 0;

			//region Creacion y destruccion de componente de carga en streaming
			virtual IStreamingLoader* NewLoader() = 0;
			virtual void FreeLoader(GNC::GCS::IStreamingLoader** loader) = 0;
			//endregion

		protected:
			IControladorCarga() {}
			~IControladorCarga() {}
		};

		class IStreamingLoader : public GNC::GCS::ILockable {
		public:
			//region Constructor
			IStreamingLoader() {}

			virtual ~IStreamingLoader() {}

			virtual bool IsSignalFile() = 0;

			/** Fija un fichero de entrada y reestablece el pipeline interno de carga si es necesario **/
			virtual void SetInput(const std::string& fichero) = 0;

			/** Actualiza la imagen completa del puerto de salida **/
			virtual void Update() = 0;

			/** Actualiza la informacion del puerto de salida **/
			virtual void UpdateInformation() = 0;

			/** Devuelve el puerto de salida **/
			virtual vtkSmartPointer<vtkAlgorithmOutput> GetOutputPort() = 0;

			/** Devuelve por parametro una copia de la imagen **/
			virtual void GetOutputCopy(vtkSmartPointer<vtkImageData>& output) = 0;

			/** devuelve las dimensiones de salida **/
			virtual void GetOutputDimensions(unsigned int currentDimensions[3]) = 0;  

			virtual void GetDirection(double cosines[9]) = 0;
			
			/** Obtiene las dimensiones de la imagen de entrada **/
			virtual void GetDimensions(unsigned int dimensions[3]) = 0;
			
			/** Obtiene el origen de la imagen de entrada **/
			virtual void GetOrigin(double origin[3]) = 0;
			
			/** Obtiene el spacing de la imagen de entrada **/
			virtual void GetSpacing(double spacing[3]) = 0;

			/** establece el spacing **/
			virtual void SetOutputSpacing(double spacing[3]) = 0;

			/** establece el origen **/
			virtual void SetOutputOrigin(double origin[3]) = 0;
			
			/** Obtiene el origen de la imagen de salida **/
			virtual void GetOutputOrigin(double origin[3]) = 0;
			
			/** Obtiene el spacing de la imagen de salida **/
			virtual void GetOutputSpacing(double spacing[3]) = 0;
		};
	}
}
