// W32_PROJECT.CPP

// Copyright (C) 2006 Tommi Hassinen.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "w32_project.h"	// config.h is here -> we get ENABLE-macros here...

#include "project.h"
#include "appdefine.h"

#include "w32_command_dialog.h"

#include <ghemical/geomopt.h>
#include <ghemical/moldyn.h>

#include <ghemical/eng1_qm.h>
#include <ghemical/eng1_mm.h>
#include <ghemical/eng1_sf.h>

#include "color.h"

#include "w32_app.h"

#include "w32_oglview_wnd.h"

#include "w32_p1dview_wnd.h"
#include "w32_p2dview_wnd.h"
#include "w32_eldview_wnd.h"
#include "w32_rcpview_wnd.h"
#include "w32_gpcview_wnd.h"

#include "ogl_plane.h"
#include "ogl_surface.h"
#include "ogl_ribbon.h"

#include <windows.h>
#ifdef ENABLE_THREADS
#include <process.h>
#endif	// ENABLE_THREADS

#include <sstream>
using namespace std;

/*################################################################################################*/

w32_project::w32_project(void) :
	project()
{
#ifdef ENABLE_THREADS
	
	pd = NULL;
	
#endif	// ENABLE_THREADS
}

void w32_project::DoSafeStart(void)
{
	
// this is effectively the ctor of this class.
// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
// moved it here so that the objects can be safely constructed and the
// pointer obtained before it is actually used anywhere. 20070816 TH
	
	AddGraphicsClient(NULL, false);
	
	ostringstream str;
	str << "A new project created." << NEWLINE << ends;
	
	PrintToLog(str.str().c_str());
}

w32_project::~w32_project(void)
{
#ifdef ENABLE_THREADS
	
	if (pd != NULL) cout << "MEM-LEAK pd" << endl;
	
#endif	// ENABLE_THREADS
}

oglview_wcl * w32_project::GetClient(HWND hwnd)
{
	w32_wnd * wnd = w32_wnd::iv_Find(hwnd);
	if (wnd == NULL) cout << "w32_project::GetClient() failed!" << endl;
	else
	{
		base_wcl * wcl1 = wnd->GetClient();
		if (wcl1 == NULL) cout << "NULL wcl1" << endl;
		
		oglview_wcl * wcl2 = dynamic_cast<oglview_wcl *>(wcl1);
		if (wcl2 == NULL) cout << "NULL wcl2" << endl;
		
		return wcl2;
	}
	
	return NULL;
}

void w32_project::ThreadLock(void)
{
#ifdef ENABLE_THREADS
	
	// with GTK+ we need here a gdk_threads_enter() call.
	// in Win32 there is no need for an equivalent call...
	
	// ...BUT we still must block access to user interface!
	// we use a modal progress-dialog box to achieve this.
	
#endif	// ENABLE_THREADS
}

void w32_project::ThreadUnlock(void)
{
#ifdef ENABLE_THREADS
	
	// with GTK+ we need here a gdk_threads_leave() call.
	// in Win32 there is no need for an equivalent call...
	
#endif	// ENABLE_THREADS
}

bool w32_project::SetProgress(double progress, double * graphdata)
{
#ifdef ENABLE_THREADS
	/*
	gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(pd->progressbar_job), progress);
	
	if (graphdata != NULL)
	{
		int f = (pd->g_fill % pd->g_sz);
		for (int i = 0;i < pd->g_n;i++)
		{
			pd->g_data[i * pd->g_sz + f] = graphdata[i];
		}
		
		pd->g_fill++;
		
		gtk_widget_queue_draw_area(pd->drawingarea_job, 0, 0, pd->da_w, pd->da_h);
	}
	
	return pd->cancel;	*/
	return false;
	
#else	// ENABLE_THREADS
	
	return false;
	
#endif	// ENABLE_THREADS
}

#ifdef ENABLE_THREADS

void w32_project::CreateProgressDialog(const char * title, bool show_pbar, int graphs_n, int graphs_s)
{
//	pd = new w32_progress_dialog(title, show_pbar, graphs_n, graphs_s);
	pd = NULL;
}

void w32_project::DestroyProgressDialog(void)
{
//	gtk_widget_destroy(pd->dialog);
//	delete pd; pd = NULL;
}

#endif	// ENABLE_THREADS

void w32_project::GeomOptGetParam(geomopt_param & param)
{
//	new gtk_geomopt_dialog(& param);	// the object will call delete itself...
	param.confirm = true;	// just accept the defaults...
	
	// the above dialog is a modal one; we will return
	// from the function only after the dialog is closed.
	
	cout << "now returning from w32_project::GeomOptGetParam()." << endl;
}

void w32_project::MolDynGetParam(moldyn_param & param)
{
//	new gtk_moldyn_dialog(& param);		// the object will call delete itself...
	param.confirm = true;	// just accept the defaults...
	
	// the above dialog is a modal one; we will return
	// from the function only after the dialog is closed.
	
	cout << "now returning from w32_project::MolDynGetParam()." << endl;
}

void w32_project::start_job_GeomOpt(jobinfo_GeomOpt * ji)
{
#ifdef ENABLE_THREADS
	
	CreateProgressDialog("Geometry Optimization", true, 1, 20);
	uintptr_t t = _beginthread(process_job_GeomOpt, 0, (void *) ji);
	
	if (t == NULL)
	{
		DestroyProgressDialog();
		ErrorMessage("Thread creation failed ; GeomOpt");
	}
	
#else	// ENABLE_THREADS
	
	process_job_GeomOpt((void *) ji);
	
#endif	// ENABLE_THREADS
}

void w32_project::process_job_GeomOpt(void * p)
{
	jobinfo_GeomOpt * ji = (jobinfo_GeomOpt *) p;
	
#ifdef ENABLE_THREADS
	
	const bool updt = false;
	
#else	// ENABLE_THREADS
	
	const bool updt = true;
	
#endif	// ENABLE_THREADS
	
	ji->prj->DoGeomOpt(ji->go, updt);
	
#ifdef ENABLE_THREADS
	
	ji->prj->ThreadLock();
	ji->prj->DestroyProgressDialog();
	ji->prj->ThreadUnlock();
	
	_endthread();
	
#endif	// ENABLE_THREADS
}

void w32_project::start_job_MolDyn(jobinfo_MolDyn * ji)
{
#ifdef ENABLE_THREADS
	
	CreateProgressDialog("Molecular Dynamics", true, NOT_DEFINED, NOT_DEFINED);
	uintptr_t t = _beginthread(process_job_MolDyn, 0, (void *) ji);
	
	if (t == NULL)
	{
		DestroyProgressDialog();
		ErrorMessage("Thread creation failed ; MolDyn");
	}
	
#else	// ENABLE_THREADS
	
	process_job_MolDyn((void *) ji);
	
#endif	// ENABLE_THREADS
}

void w32_project::process_job_MolDyn(void * p)
{
	jobinfo_MolDyn * ji = (jobinfo_MolDyn *) p;
	
#ifdef ENABLE_THREADS
	
	const bool updt = false;
	
#else	// ENABLE_THREADS
	
	const bool updt = true;
	
#endif	// ENABLE_THREADS
	
	ji->prj->DoMolDyn(ji->md, updt);
	
#ifdef ENABLE_THREADS
	ji->prj->ThreadLock();
	ji->prj->DestroyProgressDialog();
	ji->prj->ThreadUnlock();
	
	_endthread();
	
#endif	// ENABLE_THREADS
}

void w32_project::start_job_RandomSearch(jobinfo_RandomSearch * ji)
{
#ifdef ENABLE_THREADS
	
	CreateProgressDialog("Random Search", true, NOT_DEFINED, NOT_DEFINED);
	uintptr_t t = _beginthread(process_job_RandomSearch, 0, (void *) ji);
	
	if (t == NULL)
	{
		DestroyProgressDialog();
		ErrorMessage("Thread creation failed : RandomSearch");
	}
	
#else	// ENABLE_THREADS
	
	process_job_RandomSearch((void *) ji);
	
#endif	// ENABLE_THREADS
}

void w32_project::process_job_RandomSearch(void * p)
{
	jobinfo_RandomSearch * ji = (jobinfo_RandomSearch *) p;
	
#ifdef ENABLE_THREADS
	
	const bool updt = false;
	
#else	// ENABLE_THREADS
	
	const bool updt = true;
	
#endif	// ENABLE_THREADS
	
	ji->prj->DoRandomSearch(ji->cycles, ji->optsteps, updt);
	
#ifdef ENABLE_THREADS
	
	ji->prj->ThreadLock();
	ji->prj->DestroyProgressDialog();
	ji->prj->ThreadUnlock();
	
	_endthread();
	
#endif	// ENABLE_THREADS
}

base_wnd * w32_project::CreateGraphicsWnd(bool detached)
{
cout << "w32_project::CreateGraphicsWnd()" << endl;
	w32_oglview_wnd * w = new w32_oglview_wnd();
	return w;
}

void w32_project::DestroyGraphicsWnd(base_wnd * wB)
{
cout << "w32_project::DestroyGraphicsWnd() " << wB << endl;
	w32_oglview_wnd * wX = dynamic_cast<w32_oglview_wnd *>(wB);
	
// this really seems to be redundant since the plotting views are destoyed the same way...
// this really seems to be redundant since the plotting views are destoyed the same way...
// this really seems to be redundant since the plotting views are destoyed the same way...
	
	if (!wX)
	{
		cout << "w32_project::DestroyGraphicsWnd() : bad cast." << endl;
		exit(EXIT_FAILURE);
	}
	else
	{
	//	if (!wX->IsDetached())
	//	{
	//		w32_app::GetAppX()->RemoveTabFromNB(wX->view_widget);
	//	}
		
		delete wB;
	}
}

base_wnd * w32_project::CreatePlot1DWnd(bool detached)
{
//cout << "w32_project::CreatePlot1DWnd()" << endl;
	w32_p1dview_wnd * w = new w32_p1dview_wnd();
	return w;
}

base_wnd * w32_project::CreatePlot2DWnd(bool detached)
{
//cout << "w32_project::CreatePlot2DWnd()" << endl;
	w32_p2dview_wnd * w = new w32_p2dview_wnd();
	return w;
}

base_wnd * w32_project::CreateEnergyLevelDiagramWnd(bool detached)
{
//cout << "w32_project::CreateEnergyLevelDiagramWnd()" << endl;
	w32_eldview_wnd * w = new w32_eldview_wnd();
	return w;
}

base_wnd * w32_project::CreateReactionCoordinatePlotWnd(bool detached)
{
//cout << "w32_project::CreateReactionCoordinatePlotWnd()" << endl;
	w32_rcpview_wnd * w = new w32_rcpview_wnd();
	return w;
}

base_wnd * w32_project::CreateGenericProteinChainWnd(bool detached)
{
//cout << "w32_project::CreateGenericProteinChainWnd()" << endl;
	w32_gpcview_wnd * w = new w32_gpcview_wnd();
	return w;
}

void w32_project::DestroyPlottingWnd(base_wnd * wB)
{
//cout << "w32_project::DestroyPlottingWnd()" << endl;
	w32_wnd * wX = dynamic_cast<w32_wnd *>(wB);
	
	if (!wX)
	{
		cout << "w32_project::DestroyPlottingWnd() : bad cast." << endl;
		exit(EXIT_FAILURE);
	}
	else
	{
	//	if (!wX->IsDetached())
	//	{
	//		w32_app::GetAppX()->RemoveTabFromNB(wX->view_widget);
	//	}
		
		delete wB;
	}
}

void w32_project::Message(const char * msg)
{
	w32_app::sMessage(msg);
}

void w32_project::WarningMessage(const char * msg)
{
	w32_app::sWarningMessage(msg);
}

void w32_project::ErrorMessage(const char * msg)
{
	w32_app::sErrorMessage(msg);
}

bool w32_project::Question(const char * msg)
{
	return w32_app::sQuestion(msg);
}

void w32_project::PrintToLog(const char * msg)
{
	w32_app::sPrintToLog(msg);
}

// the popup-menu callbacks start here ; the popup-menu callbacks start here
// the popup-menu callbacks start here ; the popup-menu callbacks start here
// the popup-menu callbacks start here ; the popup-menu callbacks start here

void w32_project::popup_FileImport(HWND hwnd)
{
	w32_project * prj = w32_app::GetPrjX();
	
	// will call delete itself...
//fixme	if (prj) new gtk_file_import_dialog(prj);
}

void w32_project::popup_FileExport(HWND hwnd)
{
	w32_project * prj = w32_app::GetPrjX();
	
	// will call delete itself...
//fixme	if (prj) new gtk_file_export_dialog(prj);
}

void w32_project::popup_FileExportGraphic(HWND hwnd)
{
	w32_project * prj = w32_app::GetPrjX();
	
	// will call delete itself...
//fixme	if (prj) new gtk_file_save_graphics_dialog(prj);
}

void w32_project::popup_FileSaveAs(HWND hwnd)
{
	w32_project * prj = w32_app::GetPrjX();
	
	// will call delete itself...
//fixme	if (prj) new gtk_file_save_dialog(prj);
}

void w32_project::popup_FileExtra1(HWND hwnd)
{
	w32_project * prj = w32_app::GetPrjX();
	
	// will call delete itself...
//fixme	if (prj) new gtk_importpdb_dialog(prj);
}

void w32_project::popup_FileExtra2(HWND hwnd)
{
	w32_project * prj = w32_app::GetPrjX();
	
	if (prj)
	{
		prj->Message("not implemented...");
	}
}

void w32_project::popup_SelectAll(HWND hwnd)
{
	w32_project * prj = w32_app::GetPrjX();
	prj->SelectAll();
}

void w32_project::popup_SelectNone(HWND hwnd)
{
	w32_project * prj = w32_app::GetPrjX();
	prj->SelectAll();	// should call the base class function to prevent the flash!!!
	prj->InvertSelection();
}

void w32_project::popup_InvertSelection(HWND hwnd)
{
	w32_project * prj = w32_app::GetPrjX();
	prj->InvertSelection();
}

void w32_project::popup_HideSelected(HWND hwnd)
{
	w32_project * prj = w32_app::GetPrjX();
	prj->HideSelected();
}

void w32_project::popup_ShowSelected(HWND hwnd)
{
	w32_project * prj = w32_app::GetPrjX();
	prj->ShowSelected();
}

void w32_project::popup_LockSelected(HWND hwnd)
{
	w32_project * prj = w32_app::GetPrjX();
	prj->LockSelected();
}

void w32_project::popup_UnlockSelected(HWND hwnd)
{
	w32_project * prj = w32_app::GetPrjX();
	prj->UnlockSelected();
}

void w32_project::popup_DeleteSelected(HWND hwnd)
{
	w32_project * prj = w32_app::GetPrjX();
	prj->DeleteSelected();
}

void w32_project::popup_SelectModeAtom(HWND hwnd)
{
	custom_app::current_select_mode = custom_app::smAtom;
cout << "selection mode = atm" << endl;
}

void w32_project::popup_SelectModeResidue(HWND hwnd)
{
	custom_app::current_select_mode = custom_app::smResidue;
cout << "selection mode = res" << endl;
}

void w32_project::popup_SelectModeChain(HWND hwnd)
{
	custom_app::current_select_mode = custom_app::smChain;
cout << "selection mode = chn" << endl;
}

void w32_project::popup_SelectModeMolecule(HWND hwnd)
{
	custom_app::current_select_mode = custom_app::smMolecule;
cout << "selection mode = mol" << endl;
}

void w32_project::popup_ViewsNewELD(HWND hwnd)
{
	w32_project * prj = w32_app::GetPrjX();
	if (prj)
	{
		prj->AddEnergyLevelDiagramClient(true);
	}
}

void w32_project::popup_ViewsNewSSC(HWND hwnd)
{
	w32_project * prj = w32_app::GetPrjX();
	if (prj)
	{
		prj->AddGenericProteinChainClient(true);
	}
}

void w32_project::popup_RModeBallStick(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	oglwcl->render = RENDER_BALL_AND_STICK;
	
	w32_app::GetPrjX()->UpdateAllGraphicsViews();
}

void w32_project::popup_RModeVanDerWaals(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	oglwcl->render = RENDER_VAN_DER_WAALS;
	
	w32_app::GetPrjX()->UpdateAllGraphicsViews();
}

void w32_project::popup_RModeCylinders(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	oglwcl->render = RENDER_CYLINDERS;
	
	w32_app::GetPrjX()->UpdateAllGraphicsViews();
}

void w32_project::popup_RModeWireframe(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	oglwcl->render = RENDER_WIREFRAME;
	
	w32_app::GetPrjX()->UpdateAllGraphicsViews();
}

void w32_project::popup_RModeNothing(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	oglwcl->render = RENDER_NOTHING;
	
	w32_app::GetPrjX()->UpdateAllGraphicsViews();
}

void w32_project::popup_CModeElement(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	oglwcl->colormode = & project::cm_element;
	
	w32_app::GetPrjX()->UpdateAllGraphicsViews();
}

void w32_project::popup_CModeSecStruct(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	oglwcl->colormode = & project::cm_secstruct;
	
	w32_app::GetPrjX()->UpdateAllGraphicsViews();
}

void w32_project::popup_CModeHydPhob(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	oglwcl->colormode = & project::cm_hydphob;
	
	w32_app::GetPrjX()->UpdateAllGraphicsViews();
}

void w32_project::popup_LModeIndex(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	oglwcl->label = LABEL_INDEX;
	
	w32_app::GetPrjX()->UpdateAllGraphicsViews();
}

void w32_project::popup_LModeElement(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	oglwcl->label = LABEL_ELEMENT;
	
	w32_app::GetPrjX()->UpdateAllGraphicsViews();
}

void w32_project::popup_LModeFCharge(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	oglwcl->label = LABEL_F_CHARGE;
	
	w32_app::GetPrjX()->UpdateAllGraphicsViews();
}

void w32_project::popup_LModePCharge(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	oglwcl->label = LABEL_P_CHARGE;
	
	w32_app::GetPrjX()->UpdateAllGraphicsViews();
}

void w32_project::popup_LModeAtomType(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	oglwcl->label = LABEL_ATOMTYPE;
	
	w32_app::GetPrjX()->UpdateAllGraphicsViews();
}

void w32_project::popup_LModeBuilderID(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	oglwcl->label = LABEL_BUILDER_ID;
	
	w32_app::GetPrjX()->UpdateAllGraphicsViews();
}

void w32_project::popup_LModeBondType(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	oglwcl->label = LABEL_BONDTYPE;
	
	w32_app::GetPrjX()->UpdateAllGraphicsViews();
}

void w32_project::popup_LModeResidue(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	oglwcl->label = LABEL_RESIDUE;
	
	w32_app::GetPrjX()->UpdateAllGraphicsViews();
}

void w32_project::popup_LModeSecStruct(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	oglwcl->label = LABEL_SEC_STRUCT;
	
	w32_app::GetPrjX()->UpdateAllGraphicsViews();
}

void w32_project::popup_LModeNothing(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	oglwcl->label = LABEL_NOTHING;
	
	w32_app::GetPrjX()->UpdateAllGraphicsViews();
}

void w32_project::popup_ObjRibbon(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	w32_project * prj = w32_app::GetPrjX();
	if (prj)
	{
		if (!prj->ref_civ) prj->UpdateChains();
		vector<chn_info> & ci_vector = (* prj->ref_civ);
		for (i32u n1 = 0;n1 < ci_vector.size();n1++)
		{
			if (ci_vector[n1].GetType() != chn_info::amino_acid) continue;
			if (ci_vector[n1].GetLength() < 3) continue;
			
			if (ci_vector[n1].GetSecStrStates() == NULL) DefineSecondaryStructure(prj);
			
			prj->AddObject(new ogl_ribbon(prj, oglwcl->colormode, n1, 4));		// min. order is 2!!!
		}
		
		prj->UpdateAllGraphicsViews();
	}
}

void w32_project::popup_ObjEPlane(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	w32_project * prj = w32_app::GetPrjX();
	if (prj)
	{
		if (!prj->GetCurrentSetup()->GetCurrentEngine())
		{
			prj->Message("Please calculate energy first!");
		}
		else
		{
			static const char command[] = "add plane esp rb1 138.0 AUTO 1.0 50 1 0.75";
			w32_command_dialog * d = new w32_command_dialog(oglwcl, command);
			delete d; d = NULL;
		}
	}
}

void w32_project::popup_ObjEVolume(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	w32_project * prj = w32_app::GetPrjX();
	if (prj)
	{
		if (!prj->GetCurrentSetup()->GetCurrentEngine())
		{
			prj->Message("Please calculate energy first!");
		}
		else
		{
			static const char command[] = "add volrend esp rb2 138.0 0.0 1.0 25 0.50";
			w32_command_dialog * d = new w32_command_dialog(oglwcl, command);
			delete d; d = NULL;
		}
	}
}

void w32_project::popup_ObjESurface(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	w32_project * prj = w32_app::GetPrjX();
	if (prj)
	{
		if (!prj->GetCurrentSetup()->GetCurrentEngine())
		{
			prj->Message("Please calculate energy first!");
		}
		else
		{
			static const char command[] = "add surf2 esp unity red blue +35.0 -35.0 1.0 0.0 2.0 50 0 0 0.50";
			w32_command_dialog * d = new w32_command_dialog(oglwcl, command);
			delete d; d = NULL;
		}
	}
}

void w32_project::popup_ObjEVDWSurface(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	w32_project * prj = w32_app::GetPrjX();
	if (prj)
	{
		if (!prj->GetCurrentSetup()->GetCurrentEngine())
		{
			prj->Message("Please calculate energy first!");
		}
		else
		{
			static const char command[] = "add surf1 vdws esp rb1 1.0 70.0 AUTO 2.0 50 1 1 0.65";
			w32_command_dialog * d = new w32_command_dialog(oglwcl, command);
			delete d; d = NULL;
		}
	}
}

void w32_project::popup_ObjEDPlane(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	w32_project * prj = w32_app::GetPrjX();
	if (prj)
	{
		if (!prj->GetCurrentSetup()->GetCurrentEngine())
		{
			prj->Message("Please calculate energy first!");
		}
		else
		{
			static const char command[] = "add plane eldens rb1 0.05 0.0 0.75 50 1 0.75";
			w32_command_dialog * d = new w32_command_dialog(oglwcl, command);
			delete d; d = NULL;
		}
	}
}

void w32_project::popup_ObjEDSurface(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	w32_project * prj = w32_app::GetPrjX();
	if (prj)
	{
		if (!prj->GetCurrentSetup()->GetCurrentEngine())
		{
			prj->Message("Please calculate energy first!");
		}
		else
		{
			static const char command[] = "add surf1 eldens unity red 0.01 1.0 0.0 1.5 50 0 0 0.65";
			w32_command_dialog * d = new w32_command_dialog(oglwcl, command);
			delete d; d = NULL;
		}
	}
}

void w32_project::popup_ObjMOPlane(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	w32_project * prj = w32_app::GetPrjX();
	if (prj)
	{
		if (!prj->GetCurrentSetup()->GetCurrentEngine())
		{
			prj->Message("Please calculate energy first!");
		}
		else
		{
			static const char command[] = "add plane mo rb1 0.05 0.0 0.75 50 1 0.75";
			w32_command_dialog * d = new w32_command_dialog(oglwcl, command);
			delete d; d = NULL;
		}
	}
}

void w32_project::popup_ObjMOVolume(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	w32_project * prj = w32_app::GetPrjX();
	if (prj)
	{
		if (!prj->GetCurrentSetup()->GetCurrentEngine())
		{
			prj->Message("Please calculate energy first!");
		}
		else
		{
			static const char command[] = "add volrend mo rb2 0.025 0.0 1.5 25 0.50";
			w32_command_dialog * d = new w32_command_dialog(oglwcl, command);
			delete d; d = NULL;
		}
	}
}

void w32_project::popup_ObjMOSurface(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	w32_project * prj = w32_app::GetPrjX();
	if (prj)
	{
		if (!prj->GetCurrentSetup()->GetCurrentEngine())
		{
			prj->Message("Please calculate energy first!");
		}
		else
		{
			static const char command[] = "add surf2 mo unity red blue +0.025 -0.025 1.0 0.0 1.5 50 0 0 0.50";
			w32_command_dialog * d = new w32_command_dialog(oglwcl, command);
			delete d; d = NULL;
		}
	}
}

void w32_project::popup_ObjMODPlane(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	w32_project * prj = w32_app::GetPrjX();
	if (prj)
	{
		if (!prj->GetCurrentSetup()->GetCurrentEngine())
		{
			prj->Message("Please calculate energy first!");
		}
		else
		{
			static const char command[] = "add plane mod rb1 0.005 0.0 0.75 50 1 0.75";
			w32_command_dialog * d = new w32_command_dialog(oglwcl, command);
			delete d; d = NULL;
		}
	}
}

void w32_project::popup_ObjMODVolume(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	w32_project * prj = w32_app::GetPrjX();
	if (prj)
	{
		if (!prj->GetCurrentSetup()->GetCurrentEngine())
		{
			prj->Message("Please calculate energy first!");
		}
		else
		{
			static const char command[] = "add volrend mod rb2 0.0025 0.0 1.5 25 0.35";
			w32_command_dialog * d = new w32_command_dialog(oglwcl, command);
			delete d; d = NULL;
		}
	}
}

void w32_project::popup_ObjMODSurface(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	w32_project * prj = w32_app::GetPrjX();
	if (prj)
	{
		if (!prj->GetCurrentSetup()->GetCurrentEngine())
		{
			prj->Message("Please calculate energy first!");
		}
		else
		{
			static const char command[] = "add surf1 mod unity red 0.0025 1.0 0.0 1.5 50 0 0 0.65";
			w32_command_dialog * d = new w32_command_dialog(oglwcl, command);
			delete d; d = NULL;
		}
	}
}

void w32_project::popup_ObjectsDeleteCurrent(HWND hwnd)
{
	w32_project * prj = w32_app::GetPrjX();
	prj->DoDeleteCurrentObject();
}

void w32_project::popup_CompSetup(HWND hwnd)
{
	w32_project * prj = w32_app::GetPrjX();
	
	// will call delete itself...
//fixme	new gtk_setup_dialog(prj);
}

void w32_project::popup_CompEnergy(HWND hwnd)
{
	w32_project * prj = w32_app::GetPrjX();
	if (prj) prj->DoEnergy();
}

void w32_project::popup_CompGeomOpt(HWND hwnd)
{
	w32_project * prj = w32_app::GetPrjX();
	if (prj)
	{
		setup * su = prj->GetCurrentSetup();
		static jobinfo_GeomOpt ji;
		
		ji.prj = prj;
		ji.go = geomopt_param(su);
		
		prj->start_job_GeomOpt(& ji);
	}
}

void w32_project::popup_CompMolDyn(HWND hwnd)
{
	w32_project * prj = w32_app::GetPrjX();
	if (prj)
	{
		setup * su = prj->GetCurrentSetup();
		static jobinfo_MolDyn ji;
		
		ji.prj = prj;
		ji.md = moldyn_param(su);
		
		prj->start_job_MolDyn(& ji);
	}
}

void w32_project::popup_CompRandomSearch(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	w32_project * prj = w32_app::GetPrjX();
	if (prj)
	{
		static const char command[] = "random_search 100 250";
		w32_command_dialog * d = new w32_command_dialog(oglwcl, command);
		delete d; d = NULL;
	}
}

void w32_project::popup_CompSystematicSearch(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	w32_project * prj = w32_app::GetPrjX();
	if (prj)
	{
		static const char command[] = "systematic_search 6 250";
		w32_command_dialog * d = new w32_command_dialog(oglwcl, command);
		delete d; d = NULL;
	}
}

void w32_project::popup_CompMonteCarloSearch(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	w32_project * prj = w32_app::GetPrjX();
	if (prj)
	{
		static const char command[] = "montecarlo_search 10 100 250";
		w32_command_dialog * d = new w32_command_dialog(oglwcl, command);
		delete d; d = NULL;
	}
}

void w32_project::popup_CompTorsionEnergyPlot1D(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	w32_project * prj = w32_app::GetPrjX();
	if (prj)
	{
prj->Message("PLEASE NOTE!\nThe command string, which is displayed in the next dialog, is incomplete.\nYou should replace the letters A-D with atom indices that define the torsion.\n\nALSO NOTE: structure refinement is always done using molecular mechanics (optsteps).");
		
		static const char command[] = "make_plot1 A B C D 36 0.0 360.0 250";
		w32_command_dialog * d = new w32_command_dialog(oglwcl, command);
		delete d; d = NULL;
	}
}

void w32_project::popup_CompTorsionEnergyPlot2D(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	w32_project * prj = w32_app::GetPrjX();
	if (prj)
	{
prj->Message("PLEASE NOTE!\nThe command string, which is displayed in the next dialog, is incomplete.\nYou should replace the letters A-D and I-L with atom indices that define the torsions.\n\nALSO NOTE: structure refinement is always done using molecular mechanics (optsteps).");
		
		static const char command[] = "make_plot2 A B C D 36 0.0 360.0 I J K L 36 0.0 360.0 250";
		w32_command_dialog * d = new w32_command_dialog(oglwcl, command);
		delete d; d = NULL;
	}
}

void w32_project::popup_CompPopAnaElectrostatic(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	w32_project * prj = w32_app::GetPrjX();
	if (prj)
	{
		static const char command[] = "population_analysis_ESP";
		w32_command_dialog * d = new w32_command_dialog(oglwcl, command);
		delete d; d = NULL;
	}
}

void w32_project::popup_CompTransitionStateSearch(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	w32_project * prj = w32_app::GetPrjX();
	if (prj)
	{
		static const char command[] = "transition_state_search 10.0 500.0";
		w32_command_dialog * d = new w32_command_dialog(oglwcl, command);
		delete d; d = NULL;
	}
}

void w32_project::popup_CompStationaryStateSearch(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	w32_project * prj = w32_app::GetPrjX();
	if (prj)
	{
		static const char command[] = "stationary_state_search 100";
		w32_command_dialog * d = new w32_command_dialog(oglwcl, command);
		delete d; d = NULL;
	}
}

void w32_project::popup_CompFormula(HWND hwnd)
{
	w32_project * prj = w32_app::GetPrjX();
	if (prj) prj->DoFormula();
}

void w32_project::popup_CompSetFormalCharge(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	w32_project * prj = w32_app::GetPrjX();
	if (prj)
	{
		static const char command[] = "set_formal_charge X +0";
		w32_command_dialog * d = new w32_command_dialog(oglwcl, command);
		delete d; d = NULL;
	}
}

void w32_project::popup_CompCreateRS(HWND hwnd)	// todo : this is only for testing?!?!?!?
{
	w32_project * prj = w32_app::GetPrjX();
	if (prj)
	{
		if (prj->GetRS() == NULL) prj->CreateRS();
	}
}

void w32_project::popup_CompCycleRS(HWND hwnd)	// todo : this is only for testing?!?!?!?
{
	w32_project * prj = w32_app::GetPrjX();
	if (prj && prj->GetRS() != NULL)
	{
	//	prj->GetRS()->CycleStructures();
		prj->UpdateAllGraphicsViews();
	}
	else cout << "ERROR" << endl;
}

void w32_project::popup_TrajView(HWND hwnd)
{
	w32_project * prj = w32_app::GetPrjX();
	if (!prj->GetTrajectoryFile())
	{
		// will call delete itself...
//fixme		if (prj) new gtk_trajfile_dialog(prj);
	}
	else prj->ErrorMessage("Trajectory already open?!?!?!");
}

void w32_project::popup_SetOrbital(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	w32_project * prj = w32_app::GetPrjX();
	if (prj)
	{
		prj->Message("PLEASE NOTE!\nThe command string, which is displayed in the next dialog, is incomplete.\nYou should replace the letter X with the orbital index that will become the current orbital.");
		
		static const char command[] = "set_current_orbital X";
		w32_command_dialog * d = new w32_command_dialog(oglwcl, command);
		delete d; d = NULL;
	}
}

void w32_project::popup_HAdd(HWND hwnd)
{
	w32_project * prj = w32_app::GetPrjX();
	if (prj)
	{
		prj->AddH();
		
		for (iter_al itA = prj->GetAtomsBegin();itA != prj->GetAtomsEnd();itA++)
		{
			prj->w32_check_for_skipped_AddAtom_calls(& (* itA));
		}
		
		prj->UpdateAllGraphicsViews();
	}
}

void w32_project::popup_HRemove(HWND hwnd)
{
	w32_project * prj = w32_app::GetPrjX();
	if (prj)
	{
		prj->RemoveH();
		prj->UpdateAllGraphicsViews();
	}
}

void w32_project::popup_SolvateBox(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	w32_project * prj = w32_app::GetPrjX();
	if (prj)
	{
		static const char command[] = "solvate_box 3.0 3.0 3.0";
		w32_command_dialog * d = new w32_command_dialog(oglwcl, command);
		delete d; d = NULL;
	}
}

void w32_project::popup_SolvateSphere(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	w32_project * prj = w32_app::GetPrjX();
	if (prj)
	{
		static const char command[] = "solvate_sphere 1.2 1.6";
		w32_command_dialog * d = new w32_command_dialog(oglwcl, command);
		delete d; d = NULL;
	}
}

void w32_project::popup_BuilderAmino(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	w32_project * prj = w32_app::GetPrjX();
	if (prj)
	{
prj->Message("PLEASE NOTE!\nThe command string, which is displayed in the next dialog, is incomplete.\nYou should replace the default sequence AAA with the sequence to be built.");
		
		static const char command[] = "build_amino AAA";
		w32_command_dialog * d = new w32_command_dialog(oglwcl, command);
		delete d; d = NULL;
	}
}

void w32_project::popup_BuilderNucleic(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	w32_project * prj = w32_app::GetPrjX();
	if (prj)
	{
prj->Message("PLEASE NOTE!\nThe command string, which is displayed in the next dialog, is incomplete.\nYou should replace the default sequence AGTCaguc with the sequence to be built.");
		
		static const char command[] = "build_nucleic AGTCaguc";
		w32_command_dialog * d = new w32_command_dialog(oglwcl, command);
		delete d; d = NULL;
	}
}

void w32_project::popup_Center(HWND hwnd)
{
	w32_project * prj = w32_app::GetPrjX();
	if (prj)
	{
		prj->CenterCRDSet(0, true);
		
		// Which is the current Coord Set?
		// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
		// usually it's 0, but it could be any/all.
		// the crdset-system is not yet in GUI...
		
		// 2001-06-18 TH: yes, this is not quite ready.
		// but i guess in the end we will move ALL crd-sets...
		
// sometimes this centering won't work, if the camera won't point to the origo.
// so, here we try to turn it there. ANY EFFECTS TO LIGHTS, ETC??????
		
		// how to get base_app::camera_vector in a reasonable way?
		// it's easy to set the focus of camera but what about lights???
		
		// -> implement this stuff in base_app????????????????????????
		
		prj->UpdateAllGraphicsViews();
	}
}

void w32_project::popup_ClearAll(HWND hwnd)
{
	w32_project * prj = w32_app::GetPrjX();
	if (prj && base_app::GetAppB()->Question("Are you sure you want to clear everything?"))
	{
		prj->ClearModel();
		prj->UpdateAllGraphicsViews();
	}
}

void w32_project::popup_EnterCommand(HWND hwnd)
{
	oglview_wcl * oglwcl = GetClient(hwnd);
	w32_project * prj = w32_app::GetPrjX();
	if (prj)
	{
		w32_command_dialog * d = new w32_command_dialog(oglwcl, NULL);
		delete d; d = NULL;
	}
}

/*################################################################################################*/

// eof
