// W32_APP.CPP

// Copyright (C) 2006 Tommi Hassinen.

// the splitter window code is adopted from the example program
// "splitter" by J. Brown.

// This program is free software; you can redistribute it and/or modify it
// under the terms of the license (GNU GPL) which comes with this package.

/*################################################################################################*/

#include "w32_app.h"

#include "w32_wnd.h"
#include "w32_project.h"

//#include "w32_simple_dialogs.h"

#include "res_w32/resource.h"

#include <ghemical/notice.h>
#include <ghemical/utility.h>

#include <string.h>

#include <windows.h>
#include <commctrl.h>

#include <strstream>
using namespace std;

#define IDC_TOOLBAR	990
#define IDC_MDICLIENT	991
#define IDC_TXTLOG	992

#define ID_1ST_CHILD	50000	// this value should be big (at least 50000).

/*################################################################################################*/

w32_app * w32_app::instance = NULL;
const char w32_app::frame_classname[] = "ghemical_frame_wnd";

HWND w32_app::frame_hwnd = NULL;

w32_tb_button * w32_app::bTLB_draw = NULL;
w32_tb_button * w32_app::bTLB_erase = NULL;
w32_tb_button * w32_app::bTLB_select = NULL;
w32_tb_button * w32_app::bTLB_zoom = NULL;
w32_tb_button * w32_app::bTLB_clipping = NULL;
w32_tb_button * w32_app::bTLB_transl_xy = NULL;
w32_tb_button * w32_app::bTLB_transl_z = NULL;
w32_tb_button * w32_app::bTLB_orbit_xy = NULL;
w32_tb_button * w32_app::bTLB_orbit_z = NULL;
w32_tb_button * w32_app::bTLB_rotate_xy = NULL;
w32_tb_button * w32_app::bTLB_rotate_z = NULL;
w32_tb_button * w32_app::bTLB_measure = NULL;

w32_tb_button * w32_app::bTLB_element = NULL;
w32_tb_button * w32_app::bTLB_bondtype = NULL;
w32_tb_button * w32_app::bTLB_setup = NULL;

HWND w32_app::clientMDI_hwnd = NULL;

HWND w32_app::clientLOG_hwnd = NULL;

float w32_app::splitter_rel_pos = 0.75;
int w32_app::splitter_abs_pos = -1;

w32_app::w32_app(HINSTANCE hInst, LPSTR szCmdLine, int nCmdShow) :
	custom_app()
{
	if (instance != NULL)		// prevent multiple instances...
	{
		ErrorMessage("Tried to create multiple instances of w32_app!");
		exit(-1);
	}
	
	instance = this;
	
	hinst = hInst;
	myCmdLine = szCmdLine;
	myCmdShow = nCmdShow;
	
	// check the command line???
	// check the command line???
	// check the command line???
	
}

void w32_app::DoSafeStart(void)
{
	bool errors = false;
	if (!w32_app::register_wnd_class(hinst)) errors = true;
	if (!w32_wnd::register_wnd_class(hinst)) errors = true;
	if (!w32_tb_button::register_wnd_class(hinst)) errors = true;
	if (errors) return;
	
	int MYargc = 1;
	char * MYargv[] = { "foo.exe", NULL };
	glutInit(& MYargc, MYargv);
	
	// create the MDI frame window.
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	
	CREATESTRUCT cs;
	ZeroMemory(& cs, sizeof(CREATESTRUCT));
	
	frame_hwnd = CreateWindowEx(
	WS_EX_LEFT,
	frame_classname,
	"Ghemical for Win32",
	WS_OVERLAPPEDWINDOW | WS_CLIPCHILDREN,
	CW_USEDEFAULT,
	CW_USEDEFAULT,
	CW_USEDEFAULT,
	CW_USEDEFAULT,
	NULL,
	NULL,	// use the menu defined in wndclass.
	w32_app::GetHINST(),
	& cs);
	
	if (frame_hwnd == NULL)
	{
		w32_app::sErrorMessage("Failed to open the MDI frame window.");
		return;
	}
	
	ShowWindow(frame_hwnd, myCmdShow);
	
//Message("Calling SetNewProject().");
	SetNewProject();
}

w32_app::~w32_app(void)
{
	w32_app::unregister_wnd_class(hinst);
	w32_wnd::unregister_wnd_class(hinst);
	w32_tb_button::unregister_wnd_class(hinst);
}

w32_app * w32_app::GetAppX(void)
{
	return instance;
}

w32_project * w32_app::GetPrjX(void)
{
	project * p = custom_app::GetPrj();
	if (!p) return NULL;
	
	w32_project * wp = dynamic_cast<w32_project *>(p);
	return wp;
}

HINSTANCE w32_app::GetHINST(void)
{
	return GetAppX()->hinst;
}

HWND w32_app::GetFrame(void)
{
	return w32_app::frame_hwnd;
}

HWND w32_app::GetClientMDI(void)
{
	return w32_app::clientMDI_hwnd;
}

void w32_app::SetNewProject(void)
{
	if (prj != NULL)
	{
		prj->ClearAll();
		delete prj; prj = NULL;
	}
	
	custom_app::SetNewProject();
	w32_project * tmpprj = new w32_project();
	
	prj = tmpprj;
	tmpprj->DoSafeStart();
}

// Print the message (no problems).
void w32_app::sMessage(const char * msg)
{
	MessageBox(NULL, msg, "Message", MB_OK | MB_TASKMODAL);
}

// Print the message (lower severity).
void w32_app::sWarningMessage(const char * msg)
{
	MessageBox(NULL, msg, "Warning", MB_OK | MB_ICONWARNING | MB_TASKMODAL);
}

// Print the message (higher severity).
void w32_app::sErrorMessage(const char * msg)
{
	MessageBox(NULL, msg, "ERROR", MB_OK | MB_ICONERROR | MB_TASKMODAL);
}

// Print the message and wait for a yes/no response.
bool w32_app::sQuestion(const char * msg)
{
	int retval = MessageBox(NULL, msg, "Question", MB_YESNO | MB_TASKMODAL);
	if (retval == IDYES) return true; else return false;
}

void w32_app::sPrintToLog(const char * msg)
{
	w32_app * appX = w32_app::GetAppX();
	
	appX->logs << msg << flush;
	
	SetWindowText(appX->clientLOG_hwnd, appX->logs.str().c_str());
	SendMessage(appX->clientLOG_hwnd, WM_VSCROLL, (WPARAM) SB_BOTTOM, 0);
}

void w32_app::Message(const char * msg)
{
	sMessage(msg);
}

void w32_app::WarningMessage(const char * msg)
{
	sWarningMessage(msg);
}

void w32_app::ErrorMessage(const char * msg)
{
	sErrorMessage(msg);
}

bool w32_app::Question(const char * msg)
{
	return sQuestion(msg);
}

void w32_app::PrintToLog(const char * msg)
{
	sPrintToLog(msg);
}

bool w32_app::register_wnd_class(HINSTANCE hinst)
{
	WNDCLASSEX wc;
	ZeroMemory(& wc, sizeof(WNDCLASSEX));
	
	wc.cbSize = sizeof(WNDCLASSEX);
	wc.style = CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc = (WNDPROC) frame_wnd_proc;
	wc.cbClsExtra = 0;
	wc.cbWndExtra = 0;
	wc.hInstance = hinst;
	wc.hIcon = 0;//LoadIcon(hinst, MAKEINTRESOURCE(IDI_CHILDICON));
	wc.hCursor = LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground = (HBRUSH) COLOR_3DSHADOW;
	wc.lpszMenuName = MAKEINTRESOURCE(IDR_MENU1);
	wc.lpszClassName = frame_classname;
	wc.hIconSm = 0;//LoadIcon(hinst, MAKEINTRESOURCE(IDI_CHILDICON));
	
	if (!RegisterClassEx(& wc))
	{
		w32_app::sErrorMessage("Window registration failed : w32_app.");
		return false;
	}
	
	return true;
}

bool w32_app::unregister_wnd_class(HINSTANCE hinst)
{
	if (!UnregisterClass(frame_classname, hinst))
	{
		w32_app::sErrorMessage("Window unregistration failed : w32_app.");
		return false;
	}
	
	return true;
}

LRESULT CALLBACK w32_app::frame_wnd_proc(HWND hwnd, UINT message, WPARAM wparam, LPARAM lparam)
{
	LRESULT retval = 0;
	
	switch (message)
	{
		case WM_LBUTTONDOWN:
		splitter_OnLButtonDown(hwnd, message, wparam, lparam);
		retval = 0;
		break;
		
		case WM_LBUTTONUP:
		splitter_OnLButtonUp(hwnd, message, wparam, lparam);
		retval = 0;
		break;
		
		case WM_MOUSEMOVE:
		splitter_OnMouseMove(hwnd, message, wparam, lparam);
		retval = 0;
		break;
		
		case WM_SIZE:
	{	splitter_abs_pos = splitter_rel_pos * HIWORD(lparam);
		splitter_SizeWindowContents(LOWORD(lparam), HIWORD(lparam));
		retval = 0;
		break;		}
		
		case WM_CREATE:
	{	
		// do the toolbar buttons.
		// ^^^^^^^^^^^^^^^^^^^^^^^
		
		bTLB_draw = new w32_tb_button(hwnd, "draw.bmp", "d", true);
		bTLB_erase = new w32_tb_button(hwnd, "erase.bmp", "e", true);
		bTLB_select = new w32_tb_button(hwnd, "select.bmp", "s", true);
		bTLB_zoom = new w32_tb_button(hwnd, "zoom.bmp", "z", true);
		bTLB_clipping = new w32_tb_button(hwnd, "clipping.bmp", "c", true);
		bTLB_transl_xy = new w32_tb_button(hwnd, "transl_xy.bmp", "tXY", true);
		bTLB_transl_z = new w32_tb_button(hwnd, "transl_z.bmp", "tZ", true);
		bTLB_orbit_xy = new w32_tb_button(hwnd, "orbit_xy.bmp", "oXY", true);
		bTLB_orbit_z = new w32_tb_button(hwnd, "orbit_z.bmp", "oZ", true);
		bTLB_rotate_xy = new w32_tb_button(hwnd, "rotate_xy.bmp", "rXY", true);
		bTLB_rotate_z = new w32_tb_button(hwnd, "rotate_z.bmp", "rZ", true);
		bTLB_measure = new w32_tb_button(hwnd, "measure.bmp", "m", true, 24);
		
		bTLB_element = new w32_tb_button(hwnd, "element.bmp", "el", false);
		bTLB_bondtype = new w32_tb_button(hwnd, "bondtype.bmp", "bt", false);
		bTLB_setup = new w32_tb_button(hwnd, "setup.bmp", "s", false);
		
		w32_tb_button::selected = bTLB_orbit_xy;
		
		// do the MDI client window.
		// ^^^^^^^^^^^^^^^^^^^^^^^^^
		
		CLIENTCREATESTRUCT ccs;
		ccs.hWindowMenu = (HMENU) GetSubMenu(GetMenu(hwnd), 2);
		ccs.idFirstChild = ID_1ST_CHILD;
		
		clientMDI_hwnd = CreateWindowEx(
		WS_EX_CLIENTEDGE,
		"MDICLIENT",
		NULL,
		WS_CHILD | WS_VISIBLE | WS_CLIPCHILDREN | WS_CLIPSIBLINGS,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		CW_USEDEFAULT,
		hwnd,
		(HMENU) IDC_MDICLIENT,
		w32_app::GetHINST(),
		(LPVOID) & ccs);
		
		ShowWindow(clientMDI_hwnd, SW_SHOW);
		
		// do the text log edit control.
		// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
		
		clientLOG_hwnd = CreateWindowEx(
		WS_EX_CLIENTEDGE,
		"EDIT",
		NULL, 
		WS_VISIBLE | WS_CHILD | WS_VSCROLL | WS_HSCROLL | ES_MULTILINE | ES_READONLY | ES_AUTOVSCROLL | ES_AUTOHSCROLL,
		0,
		0,
		0,
		0,
		hwnd,
		(HMENU) IDC_TXTLOG,
		w32_app::GetHINST(),
		NULL);
		
		// ready...
		// ^^^^^^^^
		
		retval = 0;
		break;		}
		
		case WM_CLOSE:
		handler_WM_CLOSE(hwnd);
		retval = TRUE;
		break;
		
		case WM_DESTROY:
		handler_WM_DESTROY();
		retval = TRUE;
		break;
		
		case WM_COMMAND:
	{	switch (LOWORD(wparam))
		{
			// the toolbar commands:
			// ^^^^^^^^^^^^^^^^^^^^^
			// the MDI child will process these...
			// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^
			
			// the main menu commands:
			// ^^^^^^^^^^^^^^^^^^^^^^^
			
			case ID_FILE_CLOSE:
			handler_WM_CLOSE(hwnd);
			retval = 0;
			break;
			
			case ID_HELP_ABOUT:
			sMessage("ghemical for win32\n(C) 2006 TH");
			retval = 0;
			break;
			
			case ID_WINDOW_CASCADE:
			PostMessage(clientMDI_hwnd, WM_MDICASCADE, 0, 0);
			retval = 0;
			break;
			
			case ID_WINDOW_TILEHORIZONTAL:
			PostMessage(clientMDI_hwnd, WM_MDITILE, MDITILE_HORIZONTAL, 0);
			retval = 0;
			break;
			
			case ID_WINDOW_TILEVERTICAL:
			PostMessage(clientMDI_hwnd, WM_MDITILE, MDITILE_VERTICAL, 0);
			retval = 0;
			break;
			
			case ID_WINDOW_ARRANGEICONS:
			PostMessage(clientMDI_hwnd, WM_MDIICONARRANGE, 0, 0);
			break;
			
			// other commands:
			// ^^^^^^^^^^^^^^^
			
			default:
		{	if (LOWORD(wparam) >= ID_1ST_CHILD)
			{
				// this must be something about MDI menus.
				// -> send it to DefFrameProc() for processing.
				
				retval = DefFrameProc(hwnd, clientMDI_hwnd, message, wparam, lparam);
			}
			else
			{
				// this must be something else then.
				// -> try to send it to an active MDI child for processing.
				
				HWND child = (HWND) SendMessage(clientMDI_hwnd, WM_MDIGETACTIVE, 0, 0);
				if (child != NULL) retval = SendMessage(child, WM_COMMAND, wparam, lparam);
				else retval = 0;
			}
			
			break;		}
		}
		retval = -1;
		break;		}
		
		default:
		retval = DefFrameProc(hwnd, clientMDI_hwnd, message, wparam, lparam);
	}
	
	return retval;
}

void w32_app::handler_WM_CLOSE(HWND hwnd)
{
//	sMessage("WM_CLOSE");
	
	DestroyWindow(hwnd);	// the main dialog is modeless...
}

void w32_app::handler_WM_DESTROY(void)
{
//	sMessage("WM_DESTROY");
	
	// do some cleanup work here???
	// ^^^^^^^^^^^^^^^^^^^^^^^^^^^^
	
	PostQuitMessage(0);
}

void w32_app::UpdateAllWindowTitles(void)
{
}

void w32_app::CameraAdded(custom_camera * p1)
{
}

void w32_app::CameraRemoved(custom_camera * p1)
{
}

void w32_app::LightAdded(ogl_light * p1)
{
}

void w32_app::LightRemoved(ogl_light * p1)
{
}

void w32_app::GraphicsClientAdded(oglview_wcl *)
{
	cout << "called w32_app::GraphicsClientAdded()" << endl;
}

void w32_app::GraphicsClientRemoved(oglview_wcl *)
{
	cout << "called w32_app::GraphicsClientRemoved()" << endl;
}

void w32_app::PlottingClientAdded(base_wcl *)
{
	cout << "called w32_app::PlottingClientAdded()" << endl;
}

void w32_app::PlottingClientRemoved(base_wcl *)
{
	cout << "called w32_app::PlottingClientRemoved()" << endl;
}

void w32_app::ObjectAdded(ogl_smart_object *)
{
}

void w32_app::ObjectRemoved(ogl_smart_object *)
{
}

void w32_app::BuildChainsView(void)
{
}

void w32_app::ClearChainsView(void)
{
}

void w32_app::AtomAdded(atom * p1)
{
}

void w32_app::AtomUpdateItem(atom * p1)
{
}

void w32_app::AtomRemoved(atom * p1)
{
}

void w32_app::BondAdded(bond * p1)
{
}

void w32_app::BondUpdateItem(bond * p1)
{
}

void w32_app::BondRemoved(bond * p1)
{
}

// the splitter stuff starts here ; the splitter stuff starts here
// the splitter stuff starts here ; the splitter stuff starts here
// the splitter stuff starts here ; the splitter stuff starts here

static int s_old_y = -1;

static BOOL fMoved = FALSE;
static BOOL fDragMode = FALSE;

static int s_border = 4;

void w32_app::splitter_DrawXorBar(HDC hdc, int x1, int y1, int width, int height)
{
	static WORD _dotPatternBmp[8] =
	{
		0x00aa, 0x0055, 0x00aa, 0x0055,
		0x00aa, 0x0055, 0x00aa, 0x0055
	};
	
	HBITMAP hbm = CreateBitmap(8, 8, 1, 1, _dotPatternBmp);
	HBRUSH hbr = CreatePatternBrush(hbm);
	
	SetBrushOrgEx(hdc, x1, y1, 0);
	HBRUSH hbrOLD = (HBRUSH) SelectObject(hdc, hbr);
	
	PatBlt(hdc, x1, y1, width, height, PATINVERT);
	
	SelectObject(hdc, hbrOLD);
	
	DeleteObject(hbr);
	DeleteObject(hbm);
}

void w32_app::splitter_SizeWindowContents(int w, int h)
{
	const int toolbar_height = TB_BUTTON_HEIGHT + 1;
	MoveWindow(clientMDI_hwnd, 0, toolbar_height, w, splitter_abs_pos - toolbar_height, TRUE);
	MoveWindow(clientLOG_hwnd, 0, splitter_abs_pos + s_border, w, h - splitter_abs_pos - s_border, TRUE);
	
	// the MDI client window is resized here above, but it does not
	// change the sizes or positions of the MDI client windows...
	
	// is that a problem??? one can always do cascade/tile...
}

LRESULT w32_app::splitter_OnLButtonDown(HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
	POINT pt;
	pt.x = (short)LOWORD(lParam);
	pt.y = (short)HIWORD(lParam);
	
	RECT rect;
	GetWindowRect(hwnd, & rect);
	
	// convert the mouse coordinates relative
	// to the top-left of the window
	
	ClientToScreen(hwnd, & pt);
	pt.x -= rect.left;
	pt.y -= rect.top;
	
	// same for the window coordinates;
	// make them relative to {0,0}
	
	OffsetRect(& rect, -rect.left, -rect.top);
	
	if (pt.y < 0) pt.y = 0;
	if (pt.y > rect.bottom - 4) 
	{
		pt.y = rect.bottom - 4;
	}
	
//cout << "pt.y = " << pt.y << " ; " << TOOLBAR_HEIGHT << endl;
	if (pt.y < TOOLBAR_HEIGHT) return 0;
	
	fDragMode = TRUE;
	
	SetCapture(hwnd);
	HDC hdc = GetWindowDC(hwnd);
	splitter_DrawXorBar(hdc, 1, pt.y - 2, rect.right-2, 4);
	ReleaseDC(hwnd, hdc);
	
	s_old_y = pt.y;
	
	return 0;
}

LRESULT w32_app::splitter_OnLButtonUp(HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
	if (fDragMode == FALSE) return 0;
	
	POINT pt;
	pt.x = (short)LOWORD(lParam);
	pt.y = (short)HIWORD(lParam);
	
	RECT rect;
	GetWindowRect(hwnd, & rect);
	
	ClientToScreen(hwnd, & pt);
	pt.x -= rect.left;
	pt.y -= rect.top;
	
	OffsetRect(& rect, -rect.left, -rect.top);

	if (pt.y < 0) pt.y = 0;
	if (pt.y > rect.bottom - 4) 
	{
		pt.y = rect.bottom - 4;
	}

	HDC hdc = GetWindowDC(hwnd);
	splitter_DrawXorBar(hdc, 1, s_old_y - 2, rect.right - 2, 4);			
	ReleaseDC(hwnd, hdc);
	
	s_old_y = pt.y;
	fDragMode = FALSE;

	//convert the splitter position back to screen coords.
	GetWindowRect(hwnd, & rect);
	pt.x += rect.left;
	pt.y += rect.top;

	//now convert into CLIENT coordinates
	ScreenToClient(hwnd, & pt);
	GetClientRect(hwnd, & rect);
	
	splitter_abs_pos = pt.y;
	splitter_rel_pos = (float) pt.y / (float) rect.bottom;
	
	if (splitter_rel_pos < 0.20)
	{
		splitter_rel_pos = 0.20;
		splitter_abs_pos = splitter_rel_pos * rect.bottom;
	}
	
	if (splitter_rel_pos > 0.85)
	{
		splitter_rel_pos = 0.85;
		splitter_abs_pos = splitter_rel_pos * rect.bottom;
	}
	
	//position the child controls
	splitter_SizeWindowContents(rect.right,rect.bottom);

	ReleaseCapture();

	return 0;
}

LRESULT w32_app::splitter_OnMouseMove(HWND hwnd, UINT iMsg, WPARAM wParam, LPARAM lParam)
{
	if (fDragMode == FALSE) return 0;
	
	POINT pt;
	pt.x = (short)LOWORD(lParam);
	pt.y = (short)HIWORD(lParam);
	
	RECT rect;
	GetWindowRect(hwnd, & rect);
	
	ClientToScreen(hwnd, & pt);
	pt.x -= rect.left;
	pt.y -= rect.top;
	
	OffsetRect(& rect, -rect.left, -rect.top);
	
	bool at_zone = false;
	
	if (pt.y < 0) pt.y = 0;
	else if (pt.y > rect.bottom - 4) 
	{
		pt.y = rect.bottom  -4;
	}
	else at_zone = true;
	
	if (at_zone) SetCursor(LoadCursor(NULL, IDC_SIZENS));
	else SetCursor(LoadCursor(NULL, IDC_ARROW));
	
	if (fDragMode == FALSE) return 0;
	
	if (pt.y != s_old_y && wParam & MK_LBUTTON)
	{
		HDC hdc = GetWindowDC(hwnd);
		splitter_DrawXorBar(hdc, 1, s_old_y - 2, rect.right - 2, 4);
		splitter_DrawXorBar(hdc, 1, pt.y - 2, rect.right - 2, 4);
		ReleaseDC(hwnd, hdc);
		
		s_old_y = pt.y;
	}
	
	return 0;
}

// the toolbar-button callbacks start here ; the toolbar-button callbacks start here
// the toolbar-button callbacks start here ; the toolbar-button callbacks start here
// the toolbar-button callbacks start here ; the toolbar-button callbacks start here

// the main-menu callbacks start here ; the main-menu callbacks start here
// the main-menu callbacks start here ; the main-menu callbacks start here
// the main-menu callbacks start here ; the main-menu callbacks start here

/*################################################################################################*/

// eof
