/*  GFC-Core: GTK+ Foundation Classes (Core Library)
 *  Copyright (C) 2003-2004 The GFC Development Team.
 *
 *  iochannel.inl - G::IOChannel inline functions
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

inline GIOChannel*
GFC::G::IOChannel::g_io_channel() const
{
	return channel_;
}

inline GFC::G::IOChannel::operator GIOChannel* () const
{
	return this ? channel_ : 0;
}

inline GFC::G::IOChannelError
GFC::G::IOChannel::error_from_errno(int errno_number)
{
	return (IOChannelError)g_io_channel_error_from_errno(errno_number);
}

inline size_t
GFC::G::IOChannel::get_buffer_size() const
{
	return g_io_channel_get_buffer_size(channel_);
}

inline GFC::G::IOConditionField
GFC::G::IOChannel::get_buffer_condition() const
{
	return (IOConditionField)g_io_channel_get_buffer_condition(channel_);
}

inline GFC::G::IOFlagsField
GFC::G::IOChannel::get_flags() const
{
	return (IOFlagsField)g_io_channel_get_flags(channel_);
}

inline bool
GFC::G::IOChannel::get_buffered() const
{
	return g_io_channel_get_buffered(channel_);
}

inline bool
GFC::G::IOChannel::get_close_on_unref() const
{
	return g_io_channel_get_close_on_unref(channel_);
}

inline int
GFC::G::IOChannel::get_fd() const
{
	return g_io_channel_unix_get_fd(channel_);
}

inline void
GFC::G::IOChannel::set_buffer_size(size_t size)
{
	g_io_channel_set_buffer_size(channel_, size);
}

inline void
GFC::G::IOChannel::set_buffered(bool buffered)
{
	g_io_channel_set_buffered(channel_, buffered);
}

inline void
GFC::G::IOChannel::set_close_on_unref(bool do_close)
{
	g_io_channel_set_close_on_unref(channel_, do_close);
}

