#!/bin/sh
# Common functions or definitions used by all test scripts

# Copyright (C) 2007, 2009 Michael Geng <linux@MichaelGeng.de>

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program. If not, see <http://www.gnu.org/licenses/>.

LC_ALL=C
export LC_ALL

all_languages="c cc java"

error_() { echo "$0: $@" 1>&2; exit 1; }
framework_failure() { error_ 'failure in testing framework'; }

CPPFLAGS=-I.
GNULIB_CPPFLAGS=-I$srcdir/../../gnulib/lib
GNULIB_LDFLAGS="-L../../gnulib/lib -lgnu"

# Generate a simple commad line parsing program.
# Parameters: 
# $1: genparse file
# $2: programming language
gen_code()
{
  genparse_file=$1
  language=$2

  if test $language = java; then
    GENPARSE_EXTRA_OPTS="--parsefunc parse_cl"
  else
    GENPARSE_EXTRA_OPTS=""
  fi

  genparse --language $language --outfile parse_cl $GENPARSE_EXTRA_OPTS $genparse_file >/dev/null\
    || fail=1

  case $language in
    c)    $CC $CPPFLAGS -o parse_cl parse_cl.c  $srcdir/simple.c  || fail=1 ;;
    cc)   g++ $CPPFLAGS -o parse_cl parse_cl.cc $srcdir/simple.cc || fail=1 ;;
    java) gcj -c -o parse_clInterface.o parse_clInterface.java    || fail=1
          gcj -c -o parse_clEx.o        parse_clEx.java           || fail=1
          gcj -c -o parse_cl.o          parse_cl.java             || fail=1
          gcj -c -o simple.o            $srcdir/simple.java       || fail=1
          gcj --main=simple /usr/share/java/gnu-getopt.jar parse_clInterface.o parse_clEx.o \
            parse_cl.o simple.o -o parse_cl || fail=1 ;;
    *)    fail=1 ;;
  esac

 test -f parse_cl.$language || fail=1
 test -x parse_cl || fail=1
}
