/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.

** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.

** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/*
 * Author : Alexandre Parenteau <aubonbeurre@hotmail.com> --- February 2000
 */

/*
 * 
 */

#ifndef UCVSFRAME_H
#define UCVSFRAME_H

#include "uwidget.h"
#include "UCvsCommands.h"

class UCvsFrame : public UWidget
{
	UDECLARE_DYNAMIC(UCvsFrame)
public:
	UCvsFrame();
	virtual ~UCvsFrame();

	bool AskForQuitting(void);
		// true if we can quit the application

	enum
	{
		kDirCombo = EV_COMMAND_START,	// 0
		kBrowserPopup					// 1
	};
	
protected:
	ev_msg void OnCmdUIAnytime(int cmd, UCmdUI *pCmdUI);
	ev_msg void OnCmdUIQuit(UCmdUI *pCmdUI);
	ev_msg void OnCmdUIStopcvs(UCmdUI *pCmdUI);
	ev_msg void OnCmdUICvsCmd(UCmdUI *pCmdUI);
	ev_msg void OnCmdUIMacroAdmin(int cmd, UCmdUI *pCmdUI);
	ev_msg void OnDestroy(void);
	ev_msg int OnQuit(void);
	ev_msg int OnCopyrights(void);
	ev_msg int OnCredits(void);
	ev_msg int OnAbout(void);
	ev_msg void OnComboSelDir(int pos, const char *txt);
	ev_msg int OnBrowserPopup(void);
	ev_msg int OnCmdPreferences(void);
	ev_msg int OnCmdSaveSettings(void);
	ev_msg int OnCmdRtagNew(void);
	ev_msg int OnCmdRtagDelete(void);
	ev_msg int OnCmdRtagBranch(void);
	ev_msg int OnCmdCmdline(void);
	ev_msg int OnCmdLogin(void);
	ev_msg int OnCmdLogout(void);
	ev_msg int OnCmdStopcvs(void);
	ev_msg int OnCmdInit(void);
	ev_msg int OnCmdMacroAdmin(int cmd);

	UDECLARE_MESSAGE_MAP()
};

// little class to get the cursor to wait during the existence of the object
class UWaitCursor
{
public:
	UWaitCursor()
	{
		UEventSendMessage(kUCvsFrameID, EV_CHGCURSOR, UMAKEINT(kUMainWidget, uCursWatch), 0L);
	}
	virtual ~UWaitCursor()
	{
		UEventSendMessage(kUCvsFrameID, EV_CHGCURSOR, UMAKEINT(kUMainWidget, uCursArrow), 0L);
	}
};

#endif
