#ifndef WITHGAP_H
#define WITHGAP_H

/**
 * Logiciel Gassst (Global Alignment Short Sequence Search Tool)
 * \file withgap.h
 * \brief Module Withgap, responsable de la ralisation de l'alignement avec gap
 * \author Damien Fleury
 * \author Guillaume Rizk
 * \version 6.1
 * \date 21/01/2009
 */

#include <pthread.h>
#include <iostream>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <sys/sysinfo.h>
#include <sys/time.h>

class Bank;
class Index;
class Hit;
class Alignment;
class Stat;
class Doublon;
#define LEFT 0
#define RIGHT 1

#define AL_VALID 1
#define AL_DOUBLON 2
#define AL_ERR 0

/**
 * La structure caseMatrix permet une mmorisation du chemin utilis pour dterminer
 * le meilleur alignement dans la matrice de l'algorithme
 */
typedef struct
{
	/**
	 * Le score correspondant  la case
	 */
	int score;
	/**
	 * L'origine de la valeur du score
	 */
	int path;
  	/**
	 * Le nombre de gap
	 */
  //	int ngaps;
	/**
	 * Le nombre de mismatch
	 */
  //	int nmis;
}caseMatrix;


/// Les diffrentes valeurs pour l'attribut path de la structure caseMatrix
#define APP 0
#define MES 1
#define GA1 2
#define GA2 3


/**
 * Fonction de recherche du meilleur alignement selon le modle de Wunsch et Needleman
 * \param al l'objet Alignment qui constituera le rsultat
 * \param seq1 le pointeur du tableau des caractres de la premire banque
 * \param seq2 le pointeur du tableau des caractres de la seconde banque
 * \param size le nombre de bases  parcourir
 * \param num_gaps le nombre maximal de gaps autoriss dans la partie de l'alignement
 * \param side indiquant si on fait l'alignement sur le ct gauche ou droit de la graine
 */
//void WN_alignment(Alignment* al, char* seq1, char* seq2, int size, int num_gaps, int side);
int WN_alignment(Alignment* al, char* seq1, char* seq2, int size1, int size2, int num_gaps, int side, int num_seed, int max_mis);

int WN_big_alignment(Alignment* al, char* seq1, char* seq2, int size1, int size2, int num_gaps, int side, int num_seed, int max_mis);

int WN_very_big_alignment(Alignment* al, char* seq1, char* seq2, int size1, int size2, int num_gaps, int side, int num_seed, int max_mis);

/**
 * Fonction permettant de calculer un score d'alignement obtenu entre 2 squences
 * \param al l'objet Alignment qui constituera le rsultat
 * \param seq1 le pointeur du tableau des caractres de la premire banque
 * \param seq2 le pointeur du tableau des caractres de la seconde banque
 * \param left1 le nombre de bases prsentes  gauche dans la premire squence
 * \param left2 le nombre de bases prsentes  gauche dans la seconde squence
 * \param right1 le nombre de bases prsentes  droite dans la premire squence
 * \param right2 le nombre de bases prsentes  droite dans la seconde squence
 * \param max_mis le nombre maximal de msappariement pour conserver l'alignement
 * \param num_gaps le nombre maximal de gaps autoriss dans les alignements
 * \return Le nombre de msappariements obtenus dans l'alignement
 */
int withgap_scoreHit(Alignment* al, char* seq1, char* seq2, int left1, int left2, int right1, int right2, int max_mis, int num_gaps);


/**
 * Mthode qui  partir des positions d'une graine va effectuer tous les alignements possibles avec les squences des banques
 * \param ff le fichier de sortie, o seront affichs les alignements obtenus
 * \param BK1 le pointeur de la premire banque de squences
 * \param BK2 le pointeur de la seconde banque de squences
 * \param I1 le pointeur de l'index de la premire banque de squences
 * \param start num premiere query a faire
 * \param end num derniere query a faire
 * \param idpc le pourcentage de ressemblances minimal entre les 2 squences pour qu'un alignement soit conserv
 * \param num_gaps le nombre maximal de gaps autoriss dans les alignements
 * \return le nombre d'alignements obtenus
 */
int withgap_align(FILE *ff, Bank *BK1, Bank *BK2, Index * I1, int idpc, bool rev_comp, int num_gaps, char ** tabprec, char ** tabnt, char **tabprec7, Stat * St,Doublon * Doub,int start,int end);



#endif
