#ifndef SEED_H
#define SEED_H

/**
 * Logiciel Gassst (Global Alignment Short Sequence Search Tool)
 * \file Seed.h
 * \brief Classe Seed, dfinissant une graine
 * \author Dominique Lavenier
 * \author Damien Fleury
 * \author Guillaume Rizk
 * \version 6.1
 * \date 19/12/2008
 */

/**
 * Le nombre de graines diffrentes
 */
long long  NB_DIFF_SEED;

/**
 * La taille de la graine
 */
int SIZE_SEED;

/**
 * \class Seed, Une graine correspond  une petite squence d'ADN
 * \brief Cette class dfinit une graine, c'est  dire une courte squence qui permettra la recherche des alignements
 */
class Seed{
	public:
	
	/**
	 * Numro de la squence
	 */
	int num_seq;
	/**
	 * Index de la graine dans la squence
	 */
	int off_seq;
	/**
	 *  code squence des 16 carac a gauche de la graine
	 */
	unsigned int left;

	/**
	 *  code squence des 16 carac a droite de la graine
	 */
	unsigned int right;
	
	/**
	 * Constructeur par dfaut
	 */
	Seed();
	
	/**
	 * Constructeur de Seed
	 * \param num le numro de la squence
	 * \param offset, l'index dans squence
	 */
	Seed(int num, int offset, unsigned int seqleft, unsigned int seqright);
	/**
	 * Constructeur par recopie
	 * \param s un objet Seed
	 */
	Seed(const Seed& s);
	
	/**
	 * Destructeur
	 */
	~Seed();
	
	/**
	 * Oprateur d'affectation
	 * \param s un objet Seed
	 * \return l'objet Seed affect
	 */
	Seed& operator=(const Seed& s);
};

#endif
