/******************************************************************************
 * This file is part of MPlayer Audio Visualization.                          *
 *                                                                            *
 *                                                                            *
 *  MPlayer Audio Visualization is free software; you can redistribute it     *
 *  and/or modify it under the terms of the GNU General Public License as     *
 *  published by the Free Software Foundation; either version 2 of the        *
 *  License, or (at your option) any later version.                           *
 *                                                                            *
 *  MPlayer Audio Visualization is distributed in the hope that it will be    *
 *  useful, but WITHOUT ANY WARRANTY; without even the implied warranty of    *
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General *
 *  Public License for more details.                                          *
 *                                                                            * 
 *  You should have received a copy of the GNU General Public License         *
 *  along with MPlayer Audio Visualization; if not, write to the Free         *
 *  Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA         *
 *  02111-1307  USA                                                           *
 ******************************************************************************/
#define _C_EVENT_
#include <event.h>

int event_init()
{
  if ( ( event_thread = SDL_CreateThread( (void*)__event_thread_func, NULL ) ) == NULL )
    return( -1 );

  mpav_debug( "Event thread started...\n" );

  return( 0 );
}

void event_quit()
{
  SDL_WaitThread( event_thread, NULL );
  mpav_debug( "Event thread finished!\n" );
}

void __event_thread_func()
{
  SDL_Event event;

  while ( ! the_end )
    {
      mpav_debug( "Event loop...\n" );

      while ( SDL_PollEvent( &event ) )
	{
	  mpav_debug( "Event processing...\n" );
	  switch ( event.type ) 
	    {
	    case SDL_QUIT:
	      the_end = 1;
	      break;
	
	    case SDL_KEYDOWN:
	      switch ( event.key.keysym.sym )
		{
		case EVENT_TOGGLE_FULLSCREEN:
		  screen_toggle_fullscreen();
		  break;

		case EVENT_QUIT:
		  the_end = 1;
		  break;

		case EVENT_INCREASE_RESOLUTION:
		  {
		    int v = screen_increase_resolution();
		    if ( v == -1 )
		      mpav_fmsg( stderr, "Could not increase resolution! Maximum limit reached.\n" );
		    else if ( v == -2 )
		      mpav_fmsg( stderr, "SDL Error changing resolution: %s\n", SDL_GetError() );		      
		  }
		  break;
		  
		case EVENT_DECREASE_RESOLUTION:
		  {
		    int v = screen_decrease_resolution();
		    if ( v == -1 )
		      mpav_fmsg( stderr, "Could not decrease resolution! Minimum limit reached.\n" );
		    else if ( v == -2 )
		      mpav_fmsg( stderr, "SDL Error changing resolution: %s\n", SDL_GetError() );		      
		  }
		  break;
		  
/* 		case SDLK_KP_MULTIPLY: */

/* 		  doublepix = !doublepix; */
/* 		  if ( doublepix ) */
/* 		    title = resize_win( resx, resy ); */
/* 		  else */
/* 		    title = resize_win( resx << 1, resy << 1 ); */
/* 		  break; */
		  
		case EVENT_TOGGLE_MESSAGES:
		  screen_toggle_messages();
		  break;
		  
		default:
		  //mpav_fmsg( stderr, "I don't know what this key is: %d\n", event.key.keysym.sym );
		  break;
		}
	      
	    default:
	      //mpav_fmsg( stderr, "I don't know that event\n" );	      
	      break;
	    }
	}

      usleep( CHKINTERVAL );
    }
}





