/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver.runtime.java.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import net.sourceforge.retroweaver.runtime.java.io.Closeable;

public final class Closeable_ {
    private Closeable_() {
    }

    public static void close(Object o) throws IOException {
        if (o == null) {
            throw new NullPointerException();
        }
        if (o instanceof InputStream) {
            ((InputStream)o).close();
        } else if (o instanceof OutputStream) {
            ((OutputStream)o).close();
        } else if (o instanceof Reader) {
            ((Reader)o).close();
        } else if (o instanceof Writer) {
            ((Writer)o).close();
        } else if (o instanceof Closeable) {
            ((Closeable)o).close();
        } else {
            try {
                Method method = o.getClass().getMethod("close", null);
                if (method != null) {
                    method.invoke(o, (Object[])null);
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new UnsupportedOperationException("close() call on " + o.getClass());
        }
    }
}

