/*
 * Decompiled with CFR 0.152.
 */
package fix;

import fix.ErrorWindow;
import fix.NaiveTrustManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class HttpClient {
    private Socket socket = null;
    private String fexHost = "";
    private int fexPort = 0;
    private Proxy proxy = null;
    private String proxyHost = "";
    private int proxyPort = 0;
    private String protocol = "";
    public OutputStream out = null;
    private ErrorWindow er = null;
    private static boolean error = false;
    private static SSLSocketFactory sslSocketFactory = null;
    private boolean debug = false;
    public boolean isConnected = false;
    public boolean isProxyfied = false;
    public boolean isSecureConn = false;
    private ArrayList<Map<String, String>> requestProperties = null;
    private Map<String, String> responseProperties = null;

    public HttpClient(ErrorWindow errorWindow, boolean bl) {
        this.debug = bl;
        this.er = errorWindow;
        this.requestProperties = new ArrayList();
        this.responseProperties = new HashMap<String, String>();
        System.setProperty("java.net.useSystemProxies", "true");
    }

    public void connect(String string) {
        String[] stringArray = this.parseURL(string);
        this.protocol = stringArray[0];
        this.fexHost = stringArray[1];
        this.fexPort = Integer.parseInt(stringArray[2]);
        try {
            System.out.println("1: " + string);
            List<Proxy> list = ProxySelector.getDefault().select(new URI(string));
            System.out.println("2: " + list.toString());
            if (!list.isEmpty()) {
                this.proxy = list.get(0);
                System.out.println("3: " + this.proxy.toString());
                if (this.proxy.type() == Proxy.Type.DIRECT) {
                    System.out.println("4: DIRECT");
                    this.proxy = null;
                    list.clear();
                    list = null;
                    this.isProxyfied = false;
                } else {
                    System.out.println("4: Proxy");
                    this.isProxyfied = true;
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
        }
        if (this.isProxyfied) {
            this.proxyHost = ((InetSocketAddress)this.proxy.address()).getHostName();
            this.proxyPort = ((InetSocketAddress)this.proxy.address()).getPort();
        }
        if (stringArray[0].startsWith("https")) {
            this.isSecureConn = true;
            this.httpsConnect(this.fexHost, this.fexPort);
        } else if (stringArray[0].startsWith("http")) {
            this.isSecureConn = false;
            this.httpConnect();
        } else {
            this.er.setMess("Wrong protocol: Please use HTTP or HTTPS.", null);
            return;
        }
        try {
            this.out = this.socket.getOutputStream();
        }
        catch (IOException iOException) {
            this.er.setMess("Unable to open output stream to server: " + iOException.getMessage(), iOException);
        }
    }

    public void httpConnect() {
        String string = "";
        int n = 0;
        if (!this.isProxyfied) {
            string = this.fexHost;
            n = this.fexPort;
        } else {
            string = this.proxyHost;
            n = this.proxyPort;
        }
        try {
            this.socket = new Socket();
            this.socket.connect(new InetSocketAddress(string, n));
        }
        catch (UnknownHostException unknownHostException) {
            this.er.setMess("Host-Server is unknown. " + unknownHostException.getMessage(), unknownHostException);
        }
        catch (IOException iOException) {
            this.er.setMess("Could not connect to server '" + string + ":" + n + "': " + iOException.getMessage(), iOException);
        }
        this.isConnected = true;
    }

    public void httpsConnect(String string, int n) {
        if (!this.isProxyfied) {
            try {
                this.socket = this.getSocketFactory().createSocket();
                this.socket.connect(new InetSocketAddress(string, n));
            }
            catch (UnknownHostException unknownHostException) {
                this.er.setMess("Host-Server is unknown. " + unknownHostException.getMessage(), unknownHostException);
            }
            catch (IOException iOException) {
                this.er.setMess("Could not connect to server '" + string + ":" + n + "': " + iOException.getMessage(), iOException);
            }
        } else {
            Socket socket = null;
            try {
                socket = new Socket();
                socket.connect(new InetSocketAddress(this.proxyHost, this.proxyPort));
            }
            catch (UnknownHostException unknownHostException) {
                this.er.setMess("Host-Server is unknown. " + unknownHostException.getMessage(), unknownHostException);
            }
            catch (IOException iOException) {
                this.er.setMess("Could not connect to server '" + string + ":" + n + "': " + iOException.getMessage(), iOException);
            }
            try {
                this.out = socket.getOutputStream();
            }
            catch (IOException iOException) {
                this.er.setMess("Unable to open output stream to proxy server: " + iOException.getMessage(), iOException);
            }
            String string2 = "CONNECT " + this.fexHost + ":" + this.fexPort + " HTTP/1.0\r\n";
            string2 = string2 + "User-Agent: F*IX\r\n\r\n";
            this.send(string2);
            String string3 = "";
            try {
                string3 = this.receive(new BufferedReader(new InputStreamReader(socket.getInputStream())));
            }
            catch (IOException iOException) {
                this.er.setMess("Unable to read from proxy server: " + iOException.getMessage(), iOException);
            }
            if (Pattern.compile("HTTP\\/[0-9]\\.[0-9]\\s*200\\s*.*").matcher(string3).find()) {
                try {
                    this.socket = this.getSocketFactory().createSocket(socket, this.fexHost, this.fexPort, true);
                }
                catch (IOException iOException) {
                    this.er.setMess("Couldn't create tunneling SSL socket throught proxy server: " + iOException.getMessage(), iOException);
                }
            } else {
                this.er.setMess("Unable to tunnel SSL connection through proxy server.", null);
            }
        }
        this.isConnected = true;
    }

    public long addRequestProperty(String string, String string2) {
        long l = string.length() + ": ".length() + string2.length() + "\r\n".length();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(string, string2);
        this.requestProperties.add(hashMap);
        return l;
    }

    public long prependRequestProperty(String string, String string2) {
        long l = string.length() + ": ".length() + string2.length() + "\r\n".length();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(string, string2);
        this.requestProperties.add(0, hashMap);
        return l;
    }

    public String getResponseProperty(String string) {
        return this.responseProperties.get(string);
    }

    public String getRequestProperties() {
        String string = "";
        Iterator<Map<String, String>> iterator = this.requestProperties.iterator();
        while (iterator.hasNext()) {
            for (Map.Entry<String, String> entry : iterator.next().entrySet()) {
                string = string + entry.getKey() + ": " + entry.getValue() + "\r\n";
            }
        }
        this.requestProperties.clear();
        try {
            return new String(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.er.setMess("HTTP POST request could not be converted to UTF-8.", unsupportedEncodingException);
            return null;
        }
    }

    public void send(String string) {
        block3: {
            try {
                this.out.write(string.getBytes());
                if (this.debug) {
                    System.out.print(string);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (error) break block3;
                this.er.setMess("Error while sending to the server: " + exception.getMessage(), exception);
                error = true;
            }
        }
    }

    public void send(byte[] byArray) {
        block2: {
            try {
                this.out.write(byArray);
            }
            catch (IOException iOException) {
                if (error) break block2;
                this.er.setMess("Error while sending to the server: " + iOException.getMessage(), iOException);
                error = true;
            }
        }
    }

    public void send(byte[] byArray, int n, int n2) {
        block2: {
            try {
                this.out.write(byArray, n, n2);
            }
            catch (IOException iOException) {
                if (error) break block2;
                this.er.setMess("Error while sending to the server: " + iOException.getMessage(), iOException);
                error = true;
            }
        }
    }

    public String receive(BufferedReader bufferedReader) {
        boolean bl = true;
        String string = "";
        String string2 = "";
        try {
            while ((string = bufferedReader.readLine()) != null && string.length() > 0) {
                if (bl) {
                    if (string.startsWith("HTTP")) {
                        string2 = string;
                        bl = false;
                    }
                } else {
                    String string3 = string.split(":[\\s\\t]+")[0];
                    String string4 = string.split(":[\\s\\t]+")[1];
                    this.responseProperties.put(string3.toUpperCase(), string4);
                }
                if (!this.debug) continue;
                System.err.println("\t" + string);
            }
        }
        catch (IOException iOException) {
            if (iOException.getMessage().equals("Connection reset")) {
                System.out.println("Communication terminated. Server has reset the connection.");
            }
            this.er.setMess("Can not read from Server: " + string, iOException);
            return string;
        }
        return string2;
    }

    public String[] parseURL(String string) {
        String[] stringArray = new String[4];
        try {
            URL uRL = new URL(string);
            stringArray[0] = uRL.getProtocol();
            stringArray[1] = uRL.getHost();
            stringArray[2] = "" + uRL.getPort();
            stringArray[3] = uRL.getFile();
            if (!stringArray[0].equals("http") && !stringArray[0].equals("https")) {
                throw new IllegalArgumentException("Protocol must be http or https.");
            }
            if (Integer.parseInt(stringArray[2]) == -1) {
                stringArray[2] = stringArray[0].equals("https") ? "443" : "80";
            }
        }
        catch (MalformedURLException malformedURLException) {
            this.er.setMess("Malformed Server URL: " + string, malformedURLException);
        }
        return stringArray;
    }

    public int getPort() {
        return this.fexPort;
    }

    public String getHost() {
        return this.fexHost;
    }

    public String getURLifProxified() {
        if (this.isProxyfied && !this.isSecureConn) {
            return "http://" + this.getHost() + ":" + this.getPort();
        }
        return "";
    }

    public Socket getSocket() {
        return this.socket;
    }

    public final SSLSocketFactory getSocketFactory() {
        if (sslSocketFactory == null) {
            try {
                TrustManager[] trustManagerArray = new TrustManager[]{new NaiveTrustManager()};
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init(new KeyManager[0], trustManagerArray, new SecureRandom());
                sslSocketFactory = sSLContext.getSocketFactory();
            }
            catch (KeyManagementException keyManagementException) {
                this.er.setMess("No SSL algorithm support: ", keyManagementException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                this.er.setMess("Exception when setting up the Naive key management.", noSuchAlgorithmException);
            }
        }
        return sslSocketFactory;
    }
}

