/* -*- mode: c++ -*-

  This file is part of the Feel library

  Author(s): Christophe Prud'homme <christophe.prudhomme@ujf-grenoble.fr>
       Date: 2009-08-11

  Copyright (C) 2009 Universit Joseph Fourier (Grenoble I)

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
*/
/**
   \file test_parameter.cpp
   \author Christophe Prud'homme <christophe.prudhomme@ujf-grenoble.fr>
   \date 2009-08-11
 */
#define BOOST_TEST_MODULE parameter testsuite
#include <boost/test/unit_test.hpp>
using boost::unit_test::test_suite;
#include <iostream>
#include <algorithm>
#include <boost/foreach.hpp>
#include <boost/lambda/lambda.hpp>

#include <feel/feelcrb/parameterspace.hpp>

BOOST_AUTO_TEST_SUITE( parameter_testsuite )

BOOST_AUTO_TEST_CASE( parameter1 )
{
    boost::shared_ptr<Feel::ParameterSpace<1> > space( new Feel::ParameterSpace<1> );
    Feel::ParameterSpace<1>::Element mu_min( space );
    mu_min << 0.1;
    space->setMin( mu_min );
    Feel::ParameterSpace<1>::Element mu_max( space );
    mu_max << 10;
    space->setMax( mu_max );

    Feel::ParameterSpace<1>::Sampling Xi( space );
    Xi.randomize( 10 );

    std::for_each( Xi.begin(), Xi.end(), (std::cout << boost::lambda::_1 << "\n") );

}

BOOST_AUTO_TEST_CASE( parameter2 )
{
    boost::shared_ptr<Feel::ParameterSpace<10> > space( new Feel::ParameterSpace<10> );
    Feel::ParameterSpace<10>::Element mu_min( space );
    mu_min << 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1 ;
    space->setMin( mu_min );
    Feel::ParameterSpace<10>::Element mu_max( space );
    mu_max << 10, 10, 10, 10, 10, 10, 10, 10, 10, 10;
    space->setMax( mu_max );

    Feel::ParameterSpace<10>::Sampling Xi( space );
    Xi.equidistribute( 3 );

    std::for_each( Xi.begin(), Xi.end(), (std::cout << boost::lambda::_1 << "\n") );

}

BOOST_AUTO_TEST_CASE( parameter3 )
{
    boost::shared_ptr<Feel::ParameterSpace<10> > space( new Feel::ParameterSpace<10> );
    Feel::ParameterSpace<10>::Element mu_min( space );
    mu_min << 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1, 0.1 ;
    space->setMin( mu_min );
    Feel::ParameterSpace<10>::Element mu_max( space );
    mu_max << 10, 10, 10, 10, 10, 10, 10, 10, 10, 10;
    space->setMax( mu_max );

    Feel::ParameterSpace<10>::Sampling Xi( space );
    Xi.equidistribute( 3 );

    std::cout << "min Xi = " << Xi.min().get<0>() << ", " << Xi.min().get<1>() << "\n";
    std::cout << "max Xi = " << Xi.max().get<0>() << ", " << Xi.max().get<1>() << "\n";

}

BOOST_AUTO_TEST_CASE( parameter4 )
{
    static const int N = 2;
    boost::shared_ptr<Feel::ParameterSpace<2> > space( new Feel::ParameterSpace<2> );
    Feel::ParameterSpace<2>::Element mu_min( space );
    mu_min << 0.1, 0.1;
    space->setMin( mu_min );
    Feel::ParameterSpace<2>::Element mu_max( space );
    mu_max << 10, 10;
    space->setMax( mu_max );

    Feel::ParameterSpace<2>::Sampling Xi( space );
    Xi.equidistribute( 10 );

    Feel::ParameterSpace<2>::Element mu( space );
    mu = Feel::ParameterSpace<2>::logRandom( space );
    std::cout << "mu = " << mu << "\n";
    Feel::ParameterSpace<2>::sampling_ptrtype S = Xi.searchNearestNeighbors( mu, 2);

    std::cout << "Neighbors:\n";
    std::for_each( S->begin(), S->end(), (std::cout << boost::lambda::_1 << "\n") );


}

BOOST_AUTO_TEST_CASE( parameter_random )
{
    std::srand(static_cast<unsigned>(std::time(0)));
    static const int N = 2;
    boost::shared_ptr<Feel::ParameterSpace<2> > space( new Feel::ParameterSpace<2> );
    Feel::ParameterSpace<2>::Element mu_min( space );
    mu_min << 0.1, 0.1;
    space->setMin( mu_min );
    Feel::ParameterSpace<2>::Element mu_max( space );
    mu_max << 10, 10;
    space->setMax( mu_max );

    Feel::ParameterSpace<2>::Sampling Xi( space );
    Xi.randomize( 10 );
    for( int i = 0; i < 10; ++i )
        std::cout  << "Xi["<< i << "]=" << Xi[i] << "\n";


}

BOOST_AUTO_TEST_SUITE_END()

